/*
 * Decompiled with CFR 0.152.
 */
package ky.korins.blake3;

import java.io.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ModuleSerializationProxy;

public final class RFC4648$
implements Serializable {
    private static final char[] base64_alphabet;
    private static final char[] base64_url_alphabet;
    private static final char[] base32_alphabet;
    private static final char[] base32_hex_alphabet;
    private static final char[] base16_alphabet;
    public static final RFC4648$ MODULE$;

    private RFC4648$() {
    }

    static {
        MODULE$ = new RFC4648$();
        base64_alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        base64_url_alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
        base32_alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray();
        base32_hex_alphabet = "0123456789ABCDEFGHIJKLMNOPQRSTUV".toCharArray();
        base16_alphabet = "0123456789ABCDEF".toCharArray();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RFC4648$.class);
    }

    public char[] base64_alphabet() {
        return base64_alphabet;
    }

    public char[] base64_url_alphabet() {
        return base64_url_alphabet;
    }

    public char[] base32_alphabet() {
        return base32_alphabet;
    }

    public char[] base32_hex_alphabet() {
        return base32_hex_alphabet;
    }

    public char[] base16_alphabet() {
        return base16_alphabet;
    }

    public void base64_b2c(byte[] bytes, int offset, int len, char[] alphabet, StringBuilder sb) {
        int n = len;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                sb.append(alphabet[bytes[offset] >>> 2 & 0x3F]);
                sb.append(alphabet[(bytes[offset] & 3) << 4]);
                break;
            }
            case 2: {
                sb.append(alphabet[bytes[offset] >>> 2 & 0x3F]);
                sb.append(alphabet[(bytes[offset] & 3) << 4 | bytes[offset + 1] >>> 4 & 0xF]);
                sb.append(alphabet[(bytes[offset + 1] & 0xF) << 2]);
                break;
            }
            default: {
                sb.append(alphabet[bytes[offset] >>> 2 & 0x3F]);
                sb.append(alphabet[(bytes[offset] & 3) << 4 | bytes[offset + 1] >>> 4 & 0xF]);
                sb.append(alphabet[(bytes[offset + 1] & 0xF) << 2 | bytes[offset + 2] >>> 6 & 3]);
                sb.append(alphabet[bytes[offset + 2] & 0x3F]);
                break;
            }
        }
    }

    private void base32_b2c(byte[] bytes, int offset, int len, char[] alphabet, StringBuilder sb) {
        int n = len;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                sb.append(alphabet[bytes[offset] >>> 3 & 0x1F]);
                sb.append(alphabet[(bytes[offset] & 7) << 2]);
                break;
            }
            case 2: {
                sb.append(alphabet[bytes[offset] >>> 3 & 0x1F]);
                sb.append(alphabet[(bytes[offset] & 7) << 2 | bytes[offset + 1] >>> 6 & 3]);
                sb.append(alphabet[bytes[offset + 1] >>> 1 & 0x1F]);
                sb.append(alphabet[(bytes[offset + 1] & 1) << 4]);
                break;
            }
            case 3: {
                sb.append(alphabet[bytes[offset] >>> 3 & 0x1F]);
                sb.append(alphabet[(bytes[offset] & 7) << 2 | bytes[offset + 1] >>> 6 & 3]);
                sb.append(alphabet[bytes[offset + 1] >>> 1 & 0x1F]);
                sb.append(alphabet[(bytes[offset + 1] & 1) << 4 | bytes[offset + 2] >>> 4 & 0xF]);
                sb.append(alphabet[(bytes[offset + 2] & 0xF) << 1]);
                break;
            }
            case 4: {
                sb.append(alphabet[bytes[offset] >>> 3 & 0x1F]);
                sb.append(alphabet[(bytes[offset] & 7) << 2 | bytes[offset + 1] >>> 6 & 3]);
                sb.append(alphabet[bytes[offset + 1] >>> 1 & 0x1F]);
                sb.append(alphabet[(bytes[offset + 1] & 1) << 4 | bytes[offset + 2] >>> 4 & 0xF]);
                sb.append(alphabet[(bytes[offset + 2] & 0xF) << 1 | bytes[offset + 3] >>> 7 & 1]);
                sb.append(alphabet[bytes[offset + 3] >>> 2 & 0x1F]);
                sb.append(alphabet[(bytes[offset + 3] & 3) << 3]);
                break;
            }
            default: {
                sb.append(alphabet[bytes[offset] >>> 3 & 0x1F]);
                sb.append(alphabet[(bytes[offset] & 7) << 2 | bytes[offset + 1] >>> 6 & 3]);
                sb.append(alphabet[bytes[offset + 1] >>> 1 & 0x1F]);
                sb.append(alphabet[(bytes[offset + 1] & 1) << 4 | bytes[offset + 2] >>> 4 & 0xF]);
                sb.append(alphabet[(bytes[offset + 2] & 0xF) << 1 | bytes[offset + 3] >>> 7 & 1]);
                sb.append(alphabet[bytes[offset + 3] >>> 2 & 0x1F]);
                sb.append(alphabet[(bytes[offset + 3] & 3) << 3 | bytes[offset + 4] >>> 5 & 7]);
                sb.append(alphabet[bytes[offset + 4] & 0x1F]);
                break;
            }
        }
    }

    private void base16_b2c(byte by, char[] alphabet, StringBuilder sb) {
        sb.append(alphabet[by >>> 4 & 0xF]);
        sb.append(alphabet[by & 0xF]);
    }

    public String base64(byte[] data, int offset, int len, char[] alphabet) {
        StringBuilder sb = new StringBuilder(4 * (len / 3));
        int lim = offset + len;
        for (int i = offset; i < lim; i += 3) {
            this.base64_b2c(data, i, lim - i, alphabet, sb);
        }
        return sb.toString();
    }

    public String base64(byte[] data, char[] alphabet) {
        return this.base64(data, 0, data.length, alphabet);
    }

    public String base64(byte[] data, int offset, int len) {
        return this.base64(data, offset, len, this.base64_alphabet());
    }

    public String base64(byte[] data) {
        return this.base64(data, 0, data.length, this.base64_alphabet());
    }

    public String base64_url(byte[] data, int offset, int len) {
        return this.base64(data, offset, len, this.base64_url_alphabet());
    }

    public String base64_url(byte[] data) {
        return this.base64(data, 0, data.length, this.base64_url_alphabet());
    }

    public String base32(byte[] data, int offset, int len, char[] alphabet) {
        StringBuilder sb = new StringBuilder(8 * (len / 5));
        int lim = offset + len;
        for (int i = offset; i < lim; i += 5) {
            this.base32_b2c(data, i, lim - i, alphabet, sb);
        }
        return sb.toString();
    }

    public String base32(byte[] data, char[] alphabet) {
        return this.base32(data, 0, data.length, alphabet);
    }

    public String base32(byte[] data, int offset, int len) {
        return this.base32(data, offset, len, this.base32_alphabet());
    }

    public String base32(byte[] data) {
        return this.base32(data, 0, data.length, this.base32_alphabet());
    }

    public String base32_hex(byte[] data, int offset, int len) {
        return this.base32(data, offset, len, this.base32_hex_alphabet());
    }

    public String base32_hex(byte[] data) {
        return this.base32(data, 0, data.length, this.base32_hex_alphabet());
    }

    public String base16(byte[] data, int offset, int len, char[] alphabet) {
        StringBuilder sb = new StringBuilder(len * 2);
        int lim = offset + len;
        for (int i = offset; i < lim; ++i) {
            this.base16_b2c(data[i], alphabet, sb);
        }
        return sb.toString();
    }

    public String base16(byte[] data, char[] alphabet) {
        return this.base16(data, 0, data.length, alphabet);
    }

    public String base16(byte[] data, int offset, int len) {
        return this.base16(data, offset, len, this.base16_alphabet());
    }

    public String base16(byte[] data) {
        return this.base16(data, 0, data.length, this.base16_alphabet());
    }
}

