/*
 * Decompiled with CFR 0.152.
 */
package la.alsocan.jsonshapeshifter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import la.alsocan.jsonshapeshifter.Transformation;
import la.alsocan.jsonshapeshifter.bindings.ArrayNodeBinding;
import la.alsocan.jsonshapeshifter.bindings.StringConstantBinding;
import la.alsocan.jsonshapeshifter.bindings.StringNodeBinding;
import la.alsocan.jsonshapeshifter.schemas.Schema;
import la.alsocan.jsonshapeshifter.schemas.SchemaNode;

public class Main {
    private static final String SOURCE_PAYLOAD = "target/classes/payloads/source.json";
    private static final String SOURCE_SCHEMA = "target/classes/schemas/source.json";
    private static final String TARGET_SCHEMA = "target/classes/schemas/target.json";

    public static void main(String[] args) throws IOException {
        Schema target;
        Schema source;
        try {
            source = Schema.buildSchema(SOURCE_SCHEMA);
            target = Schema.buildSchema(TARGET_SCHEMA);
        }
        catch (IOException ex) {
            System.err.println("Oups: " + ex);
            return;
        }
        Transformation t = new Transformation(source, target);
        Iterator<SchemaNode> it = t.toBind();
        t.bind(it.next(), new ArrayNodeBinding(source.at("/rootSourceArray")));
        t.bind(it.next(), new ArrayNodeBinding(source.at("/rootSourceArray/{i}")));
        t.bind(it.next(), new StringConstantBinding("Constant value"));
        t.bind(it.next(), new StringNodeBinding(source.at("/rootSourceString")));
        t.bind(it.next(), new ArrayNodeBinding(source.at("/rootSourceArray/{i}/{i}/someSourceArray")));
        t.bind(it.next(), new StringNodeBinding(source.at("/rootSourceArray/{i}/{i}/someSourceArray/{i}")));
        JsonNode payload = new ObjectMapper().readTree(new File(SOURCE_PAYLOAD));
        JsonNode result = t.apply(payload);
        ObjectMapper om = new ObjectMapper();
        try {
            System.out.println("Original payload:");
            System.out.println(om.writerWithDefaultPrettyPrinter().writeValueAsString((Object)payload));
            System.out.println("\nResulting payload:");
            System.out.println(om.writerWithDefaultPrettyPrinter().writeValueAsString((Object)result));
        }
        catch (JsonProcessingException ex) {
            System.err.println("Oups: " + (Object)((Object)ex));
        }
    }
}

