/*
 * Decompiled with CFR 0.152.
 */
package la.alsocan.jsonshapeshifter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import la.alsocan.jsonshapeshifter.Default;
import la.alsocan.jsonshapeshifter.bindings.ArrayNodeBinding;
import la.alsocan.jsonshapeshifter.bindings.Binding;
import la.alsocan.jsonshapeshifter.bindings.IllegalBindingException;
import la.alsocan.jsonshapeshifter.schemas.ENodeType;
import la.alsocan.jsonshapeshifter.schemas.Schema;
import la.alsocan.jsonshapeshifter.schemas.SchemaArrayNode;
import la.alsocan.jsonshapeshifter.schemas.SchemaNode;
import la.alsocan.jsonshapeshifter.schemas.SchemaObjectNode;

public class Transformation {
    private final Schema source;
    private final Schema target;
    private final Map<SchemaNode, Binding<?>> bindings;

    public Transformation(Schema source, Schema target) {
        this.source = source;
        this.target = target;
        this.bindings = new TreeMap();
    }

    public Iterator<SchemaNode> toBind() {
        final Iterator<SchemaNode> itNodes = this.target.iterator();
        return new Iterator<SchemaNode>(){
            private SchemaNode remainingNode = this.getNextNode();

            @Override
            public boolean hasNext() {
                return this.remainingNode != null;
            }

            @Override
            public SchemaNode next() {
                if (this.remainingNode == null) {
                    throw new NoSuchElementException();
                }
                SchemaNode toReturn = this.remainingNode;
                this.remainingNode = this.getNextNode();
                return toReturn;
            }

            private SchemaNode getNextNode() {
                SchemaNode node = null;
                do {
                    if (!itNodes.hasNext()) {
                        return null;
                    }
                    node = (SchemaNode)itNodes.next();
                } while (Transformation.this.bindings.containsKey(node) || ENodeType.OBJECT.equals((Object)node.getType()) || ENodeType.NULL.equals((Object)node.getType()));
                return node;
            }
        };
    }

    public void bind(SchemaNode targetNode, Binding binding) {
        if (binding == null || !binding.getSourceNodes().isEmpty() && !this.legalNodesFor(targetNode).containsAll(binding.getSourceNodes())) {
            throw new IllegalBindingException();
        }
        this.bindings.put(targetNode, binding);
    }

    public Set<SchemaNode> legalNodesFor(SchemaNode targetNode) {
        TreeSet<SchemaNode> sources = new TreeSet<SchemaNode>();
        this.source.getChildren().stream().forEach(sourceNode -> this.collectDown((Set<SchemaNode>)sources, (SchemaNode)sourceNode, targetNode.getType()));
        SchemaNode current = targetNode;
        while ((current = current.getParent()) != null) {
            if (!(this.bindings.get(current) instanceof ArrayNodeBinding)) continue;
            SchemaArrayNode sourceNode2 = (SchemaArrayNode)((ArrayNodeBinding)this.bindings.get(current)).getSourceNodes().iterator().next();
            this.collectDown(sources, sourceNode2, targetNode.getType());
            this.collectDown(sources, sourceNode2.getChild(), targetNode.getType());
        }
        return sources;
    }

    private void collectDown(Set<SchemaNode> sources, SchemaNode sourceNode, ENodeType type) {
        switch (type) {
            case INTEGER: 
            case BOOLEAN: 
            case ARRAY: {
                if (!sourceNode.getType().equals((Object)type)) break;
                sources.add(sourceNode);
                break;
            }
            case NUMBER: {
                switch (sourceNode.getType()) {
                    case INTEGER: 
                    case NUMBER: {
                        sources.add(sourceNode);
                    }
                }
                break;
            }
            case STRING: {
                switch (sourceNode.getType()) {
                    case INTEGER: 
                    case NUMBER: 
                    case BOOLEAN: 
                    case STRING: {
                        sources.add(sourceNode);
                    }
                }
            }
        }
        if (ENodeType.OBJECT.equals((Object)sourceNode.getType())) {
            ((SchemaObjectNode)sourceNode).getChildren().stream().forEach(child -> this.collectDown(sources, (SchemaNode)child, type));
        }
    }

    public JsonNode apply(JsonNode payload) {
        ObjectMapper om = new ObjectMapper();
        ObjectNode root = om.createObjectNode();
        ArrayList pointerContext = new ArrayList();
        this.target.getChildren().stream().forEach(tNode -> this.resolveNode(om, (SchemaNode)tNode, (JsonNode)root, payload, pointerContext));
        return root;
    }

    private void resolveNode(ObjectMapper om, SchemaNode node, JsonNode parentNode, JsonNode payload, List<Integer> pointerContext) {
        switch (node.getType()) {
            case OBJECT: {
                ObjectNode oNode = om.createObjectNode();
                ((SchemaObjectNode)node).getChildren().stream().forEach(tChildNode -> this.resolveNode(om, (SchemaNode)tChildNode, (JsonNode)oNode, payload, pointerContext));
                if (parentNode.isObject()) {
                    ((ObjectNode)parentNode).set(node.getName(), (JsonNode)oNode);
                    break;
                }
                ((ArrayNode)parentNode).add((JsonNode)oNode);
                break;
            }
            case ARRAY: {
                ArrayNode aNode = om.createArrayNode();
                SchemaNode tChildNode2 = ((SchemaArrayNode)node).getChild();
                int index = 0;
                pointerContext.add(index);
                Iterator it = (Iterator)this.resolveValue(node, payload, pointerContext);
                while (it.hasNext()) {
                    it.next();
                    this.resolveNode(om, tChildNode2, (JsonNode)aNode, payload, pointerContext);
                    pointerContext.set(pointerContext.size() - 1, ++index);
                }
                pointerContext.remove(pointerContext.size() - 1);
                if (parentNode.isObject()) {
                    ((ObjectNode)parentNode).set(node.getName(), (JsonNode)aNode);
                    break;
                }
                ((ArrayNode)parentNode).add((JsonNode)aNode);
                break;
            }
            case BOOLEAN: {
                if (parentNode.isObject()) {
                    ((ObjectNode)parentNode).put(node.getName(), (Boolean)this.resolveValue(node, payload, pointerContext));
                    break;
                }
                ((ArrayNode)parentNode).add((Boolean)this.resolveValue(node, payload, pointerContext));
                break;
            }
            case INTEGER: {
                if (parentNode.isObject()) {
                    ((ObjectNode)parentNode).put(node.getName(), (Integer)this.resolveValue(node, payload, pointerContext));
                    break;
                }
                ((ArrayNode)parentNode).add((Integer)this.resolveValue(node, payload, pointerContext));
                break;
            }
            case NUMBER: {
                if (parentNode.isObject()) {
                    ((ObjectNode)parentNode).put(node.getName(), (Double)this.resolveValue(node, payload, pointerContext));
                    break;
                }
                ((ArrayNode)parentNode).add((Double)this.resolveValue(node, payload, pointerContext));
                break;
            }
            case NULL: {
                if (parentNode.isObject()) {
                    ((ObjectNode)parentNode).putNull(node.getName());
                    break;
                }
                ((ArrayNode)parentNode).addNull();
                break;
            }
            case STRING: {
                if (parentNode.isObject()) {
                    ((ObjectNode)parentNode).put(node.getName(), (String)this.resolveValue(node, payload, pointerContext));
                    break;
                }
                ((ArrayNode)parentNode).add((String)this.resolveValue(node, payload, pointerContext));
            }
        }
    }

    private Object resolveValue(SchemaNode node, JsonNode payload, List<Integer> pointerContext) {
        Object value;
        Binding<?> b = this.bindings.get(node);
        if (b == null || (value = b.getValue(payload, pointerContext)) == null) {
            switch (node.getType()) {
                case ARRAY: {
                    return Default.DEFAULT_ARRAY;
                }
                case BOOLEAN: {
                    return Default.DEFAULT_BOOLEAN;
                }
                case INTEGER: {
                    return Default.DEFAULT_INTEGER;
                }
                case NUMBER: {
                    return Default.DEFAULT_NUMBER;
                }
                case STRING: {
                    return "?";
                }
            }
            return null;
        }
        return value;
    }
}

