/*
 * Decompiled with CFR 0.152.
 */
package la.alsocan.jsonshapeshifter.bindings;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import la.alsocan.jsonshapeshifter.bindings.Binding;
import la.alsocan.jsonshapeshifter.bindings.IllegalBindingException;
import la.alsocan.jsonshapeshifter.schemas.SchemaNode;

public abstract class AbstractNodeBinding<T>
extends Binding<T> {
    private final SchemaNode source;
    private static final String PATH_DELIMITER_REGEX = "\\{i\\}";

    public AbstractNodeBinding(SchemaNode source) {
        this.source = source;
        if (source == null) {
            throw new IllegalBindingException();
        }
    }

    @Override
    public Set<SchemaNode> getSourceNodes() {
        HashSet<SchemaNode> nodes = new HashSet<SchemaNode>();
        nodes.add(this.source);
        return nodes;
    }

    @Override
    public final T getValue(JsonNode payload, List<Integer> context) {
        JsonNode node = payload.at(AbstractNodeBinding.jsonPointer(this.source.getSchemaPointer(), context));
        return node == null ? null : (T)this.readValue(node);
    }

    protected abstract T readValue(JsonNode var1);

    static String jsonPointer(String schemaPointer, List<Integer> context) {
        for (Integer index : context) {
            schemaPointer = schemaPointer.replaceFirst(PATH_DELIMITER_REGEX, String.valueOf(index));
        }
        return schemaPointer;
    }
}

