/*
 * Decompiled with CFR 0.152.
 */
package la.alsocan.jsonshapeshifter.bindings;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import la.alsocan.jsonshapeshifter.bindings.Binding;
import la.alsocan.jsonshapeshifter.schemas.SchemaNode;

public class StringHandlebarsBinding
extends Binding<String> {
    private final Template template;
    private final Map<String, Binding> params;

    public StringHandlebarsBinding(String template, Map<String, Binding> params) throws IOException {
        Handlebars handlebars = new Handlebars();
        this.template = handlebars.compileInline(template);
        this.params = params;
    }

    @Override
    public Set<SchemaNode> getSourceNodes() {
        HashSet<SchemaNode> nodes = new HashSet<SchemaNode>();
        this.params.values().stream().forEach(b -> nodes.addAll(b.getSourceNodes()));
        return nodes;
    }

    @Override
    public String getValue(JsonNode payload, List context) {
        String result;
        HashMap values = new HashMap();
        this.params.keySet().stream().forEach(key -> values.put(key, this.params.get(key).getValue(payload, context)));
        try {
            result = this.template.apply(values);
        }
        catch (IOException e) {
            result = "?";
        }
        return result;
    }
}

