/*
 * Decompiled with CFR 0.152.
 */
package la.alsocan.jsonshapeshifter.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Stack;
import java.util.TreeMap;
import la.alsocan.jsonshapeshifter.schemas.ENodeType;
import la.alsocan.jsonshapeshifter.schemas.SchemaArrayNode;
import la.alsocan.jsonshapeshifter.schemas.SchemaNode;
import la.alsocan.jsonshapeshifter.schemas.SchemaObjectNode;

public class Schema
extends SchemaObjectNode
implements Iterable<SchemaNode> {
    private final JsonNode schemaNode;
    private final TreeMap<String, SchemaNode> nodeIndex = new TreeMap();

    private Schema(JsonNode schemaNode, String name, String schemaPointer, boolean required) {
        super(name, schemaPointer, required);
        this.schemaNode = schemaNode;
    }

    public static final Schema buildSchema(String schemaPath) throws IOException {
        return Schema.buildSchema(new File(schemaPath));
    }

    public static final Schema buildSchema(File schemaFile) throws IOException {
        return Schema.buildSchema(new ObjectMapper().readTree(schemaFile));
    }

    public static final Schema buildSchema(JsonNode schemaNode) {
        Schema schema = new Schema(schemaNode, "", "", true);
        schema.withResolvedChildren(schemaNode);
        schema.buildIndex();
        return schema;
    }

    public ProcessingReport validate(JsonNode payload) throws ProcessingException {
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        JsonSchema schema = factory.getJsonSchema(this.schemaNode);
        return schema.validate(payload);
    }

    public final SchemaNode at(String schemaPointer) {
        return this.nodeIndex.get(schemaPointer);
    }

    private void buildIndex() {
        for (SchemaNode node : this) {
            this.nodeIndex.put(node.getSchemaPointer(), node);
        }
    }

    @Override
    public final Iterator<SchemaNode> iterator() {
        return new SchemaNodesIterator(this);
    }

    private class SchemaNodesIterator
    implements Iterator<SchemaNode> {
        private final Stack<Queue<SchemaNode>> buffer = new Stack();
        private SchemaNode nextNode;

        public SchemaNodesIterator(Schema schema2) {
            LinkedList<SchemaNode> rootNodes = new LinkedList<SchemaNode>(schema2.getChildren());
            this.buffer.push(rootNodes);
            this.nextNode = this.readFromBuffer();
        }

        @Override
        public SchemaNode next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            SchemaNode toReturn = this.nextNode;
            this.nextNode = this.calculateNext();
            return toReturn;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        private SchemaNode readFromBuffer() {
            if (this.buffer.isEmpty()) {
                return null;
            }
            Queue<SchemaNode> queue = this.buffer.peek();
            SchemaNode node = queue.poll();
            if (queue.isEmpty()) {
                this.buffer.pop();
            }
            return node;
        }

        private SchemaNode calculateNext() {
            if (this.nextNode == null) {
                return null;
            }
            if (ENodeType.OBJECT.equals((Object)this.nextNode.type)) {
                LinkedList<SchemaNode> childrenNodes = new LinkedList<SchemaNode>(((SchemaObjectNode)this.nextNode).getChildren());
                this.buffer.push(childrenNodes);
            } else if (ENodeType.ARRAY.equals((Object)this.nextNode.type)) {
                LinkedList<SchemaNode> childNode = new LinkedList<SchemaNode>();
                childNode.add(((SchemaArrayNode)this.nextNode).getChild());
                this.buffer.push(childNode);
            }
            return this.readFromBuffer();
        }
    }
}

