/*
 * Decompiled with CFR 0.152.
 */
package la.alsocan.jsonshapeshifter.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import la.alsocan.jsonshapeshifter.schemas.ENodeType;
import la.alsocan.jsonshapeshifter.schemas.SchemaNode;
import la.alsocan.jsonshapeshifter.schemas.UnsupportedJsonSchemaException;

public class SchemaArrayNode
extends SchemaNode {
    private SchemaNode child;

    protected SchemaArrayNode(String name, String path, boolean required) {
        super(name, path, ENodeType.ARRAY, required);
    }

    protected SchemaArrayNode withResolvedChild(JsonNode node) {
        JsonNode items = node.get("items");
        if (items != null && items.has("type")) {
            this.child = SchemaArrayNode.buildSchemaNode(items, null, this.path + "/{i}", false);
            this.child.setParent(this);
            return this;
        }
        throw new UnsupportedJsonSchemaException("Tuples and untyped arrays are currently not supported");
    }

    public final SchemaNode getChild() {
        return this.child;
    }
}

