/*
 * Decompiled with CFR 0.152.
 */
package la.alsocan.jsonshapeshifter.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import la.alsocan.jsonshapeshifter.schemas.ENodeType;
import la.alsocan.jsonshapeshifter.schemas.SchemaArrayNode;
import la.alsocan.jsonshapeshifter.schemas.SchemaObjectNode;
import la.alsocan.jsonshapeshifter.schemas.UnsupportedJsonSchemaException;

public class SchemaNode
implements Comparable<SchemaNode> {
    protected final String name;
    protected final String path;
    protected final ENodeType type;
    protected final boolean required;
    private SchemaNode parent;

    protected SchemaNode(String name, String path, ENodeType type, boolean required) {
        this.name = name;
        this.path = path;
        this.type = type;
        this.required = required;
    }

    protected static final SchemaNode buildSchemaNode(JsonNode node, String name, String path, boolean required) {
        switch (node.get("type") != null ? node.get("type").asText() : "?") {
            case "object": {
                return new SchemaObjectNode(name, path, required).withResolvedChildren(node);
            }
            case "array": {
                return new SchemaArrayNode(name, path, required).withResolvedChild(node);
            }
            case "string": {
                return new SchemaNode(name, path, ENodeType.STRING, required);
            }
            case "integer": {
                return new SchemaNode(name, path, ENodeType.INTEGER, required);
            }
            case "number": {
                return new SchemaNode(name, path, ENodeType.NUMBER, required);
            }
            case "boolean": {
                return new SchemaNode(name, path, ENodeType.BOOLEAN, required);
            }
            case "null": {
                return new SchemaNode(name, path, ENodeType.NULL, required);
            }
        }
        throw new UnsupportedJsonSchemaException("Unknown type for element '" + path + "'");
    }

    public SchemaNode getParent() {
        return this.parent;
    }

    protected void setParent(SchemaNode parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public String getSchemaPointer() {
        return this.path;
    }

    public ENodeType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public int compareTo(SchemaNode o) {
        return this.path.compareTo(o.path);
    }
}

