/*
 * Decompiled with CFR 0.152.
 */
package la.alsocan.jsonshapeshifter.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import la.alsocan.jsonshapeshifter.schemas.ENodeType;
import la.alsocan.jsonshapeshifter.schemas.SchemaNode;
import la.alsocan.jsonshapeshifter.schemas.UnsupportedJsonSchemaException;

public class SchemaObjectNode
extends SchemaNode {
    private final List<SchemaNode> children = new LinkedList<SchemaNode>();

    protected SchemaObjectNode(String name, String path, boolean required) {
        super(name, path, ENodeType.OBJECT, required);
    }

    protected SchemaObjectNode withResolvedChildren(JsonNode node) {
        JsonNode props = node.get("properties");
        if (props == null) {
            throw new UnsupportedJsonSchemaException("Untyped objects are currently not supported");
        }
        HashSet<String> reqSet = new HashSet<String>();
        JsonNode reqs = node.get("required");
        if (reqs != null) {
            Iterator itReqs = reqs.elements();
            while (itReqs.hasNext()) {
                reqSet.add(((JsonNode)itReqs.next()).asText());
            }
        }
        Iterator itName = props.fieldNames();
        Iterator itNode = props.elements();
        while (itNode.hasNext()) {
            String childName = (String)itName.next();
            SchemaNode typedChild = SchemaObjectNode.buildSchemaNode((JsonNode)itNode.next(), childName, this.path + "/" + childName, reqSet.contains(childName));
            this.children.add(typedChild);
            typedChild.setParent(this);
        }
        return this;
    }

    public List<SchemaNode> getChildren() {
        return this.children;
    }
}

