/**
 * Copyright (c) 2016 Kristian Kraljic
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package lc.kra.system.mouse.event;

import java.util.EventListener;

public interface GlobalMouseListener extends EventListener {
    /**
     * Invoked when a mouse button has been pressed.
     * 
     * @param event a global mouse event
     */
	public void mousePressed(GlobalMouseEvent event);

    /**
     * Invoked when a mouse button has been released.
     * 
     * @param event a global mouse event
     */
	public void mouseReleased(GlobalMouseEvent event);
	
	/**
     * Invoked when the mouse was moved.
     * 
     * @param event a global mouse event
     */
	public void mouseMoved(GlobalMouseEvent event);
	
	/**
     * Invoked when a mouse wheel was scrolled.
     * 
     * @param event a global mouse event
     */
	public void mouseWheel(GlobalMouseEvent event);
}