/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.ldif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import org.apache.avalon.framework.logger.Logger;

public class LdifIterator
implements Iterator {
    private static final boolean DEBUG = false;
    private String m_prefetched = null;
    private Logger m_logger = null;
    private BufferedReader m_in = null;
    private StringBuffer m_buf = new StringBuffer();

    public LdifIterator(InputStream a_in) throws IOException {
        this(new InputStreamReader(a_in));
    }

    public LdifIterator(Reader a_in) throws IOException {
        this.m_in = new BufferedReader(a_in);
        this.debug("<init>: -- opended file");
        this.prefetch();
        this.debug("<init>: -- prefetch complete");
    }

    public LdifIterator(InputStream a_in, Logger a_logger) throws IOException {
        this(new InputStreamReader(a_in), a_logger);
    }

    public LdifIterator(Reader a_in, Logger a_logger) throws IOException {
        this(a_in);
        this.m_logger = a_logger;
    }

    public boolean hasNext() {
        return null != this.m_prefetched;
    }

    public Object next() {
        String l_retVal = this.m_prefetched;
        try {
            this.debug("next(): -- called");
            this.prefetch();
        }
        catch (IOException e) {
            this.error("Premature termination of LDIF iterator due to underlying stream error", e);
        }
        return l_retVal;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void error(String a_msg, Throwable a_throwable) {
        if (null == this.m_logger) {
            System.err.println(a_msg);
            a_throwable.printStackTrace(System.err);
        } else {
            this.m_logger.error(a_msg, a_throwable);
        }
    }

    private void debug(String a_msg) {
    }

    private void debug(String a_msg, Throwable a_throwable) {
    }

    private void prefetch() throws IOException {
        boolean l_insideLdif = false;
        String l_line = null;
        while (null != (l_line = this.m_in.readLine())) {
            this.debug("readLine(): " + l_line);
            l_line = LdifIterator.filterComment(l_line).trim();
            if (l_insideLdif) {
                if (l_line.equals("")) break;
                this.debug("prefetch(): -- appending last line to buffer");
                this.m_buf.append(l_line).append('\n');
                continue;
            }
            if (l_line.equals("")) continue;
            l_insideLdif = true;
            this.debug("prefetch(): -- appending last line to buffer");
            this.m_buf.append(l_line).append('\n');
        }
        if (null == l_line && 0 == this.m_buf.length()) {
            this.debug("prefetch(): -- line was null and buffer was empty");
            this.debug("prefetch(): -- iterator has been consumed");
            this.m_prefetched = null;
        } else {
            this.debug("prefetch(): -- LDIF prefetched and set as next");
            this.m_prefetched = this.m_buf.toString();
        }
        this.m_buf.setLength(0);
        this.debug("prefetch(): -- LDIF buffer cleared");
    }

    public static String filterComment(String a_line) {
        int l_index = a_line.indexOf(35);
        if (-1 == l_index) {
            return a_line;
        }
        if (l_index == 0) {
            return "";
        }
        while (-1 != l_index) {
            if (l_index - 1 > 0 && '\\' == a_line.charAt(l_index - 1)) {
                if (l_index + 1 < a_line.length()) {
                    l_index = a_line.indexOf(35, l_index + 1);
                    continue;
                }
                return a_line;
            }
            return a_line.substring(0, l_index);
        }
        return a_line;
    }
}

