/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ldap.common.AbstractLockable;
import org.apache.ldap.common.message.Control;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.MessageException;
import org.apache.ldap.common.message.MessageTypeEnum;

public class AbstractMessage
extends AbstractLockable
implements Message {
    private final Map m_controls;
    private final BigInteger m_id;
    private final MessageTypeEnum m_type;
    private final Map m_parameters;

    protected AbstractMessage(BigInteger a_id, MessageTypeEnum a_type) {
        super(true);
        this.m_id = a_id;
        this.m_type = a_type;
        this.m_controls = new HashMap();
        this.m_parameters = new HashMap();
    }

    public BigInteger getMessageId() {
        return this.m_id;
    }

    public Collection getControls() {
        return Collections.unmodifiableCollection(this.m_controls.values());
    }

    public void add(Control a_control) throws MessageException {
        this.lockCheck("Attempt to add control to locked message envelope!");
        this.m_controls.put(a_control.getType(), a_control);
    }

    public void remove(Control a_control) throws MessageException {
        this.lockCheck("Attempt to remove control from locked message envelope!");
        this.m_controls.remove(a_control.getType());
    }

    public MessageTypeEnum getType() {
        return this.m_type;
    }

    public Object get(Object a_key) {
        return this.m_parameters.get(a_key);
    }

    public Object put(Object a_key, Object a_value) {
        return this.m_parameters.put(a_key, a_value);
    }
}

