/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.avalon.framework.ExceptionUtil;
import org.apache.ldap.common.AbstractLockable;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.message.IteratorNamingEnumeration;
import org.apache.ldap.common.message.LockableAttributeImpl;
import org.apache.ldap.common.message.LockableAttributes;

public class LockableAttributesImpl
extends AbstractLockable
implements LockableAttributes {
    private final Map m_map = new HashMap();
    private final transient Map m_keyMap;

    public LockableAttributesImpl() {
        super(false);
        this.m_keyMap = new HashMap();
    }

    public LockableAttributesImpl(Lockable a_parent) {
        super(a_parent, false);
        this.m_keyMap = new HashMap();
    }

    private LockableAttributesImpl(Lockable a_parent, Map a_map, Map a_keyMap) {
        super(a_parent, false);
        this.m_map.putAll(a_map);
        this.m_keyMap = a_keyMap;
        this.m_keyMap.putAll(a_keyMap);
    }

    public boolean isCaseIgnored() {
        return true;
    }

    public int size() {
        return this.m_map.size();
    }

    public Attribute get(String a_attrId) {
        String l_key = this.getUserProvidedId(a_attrId);
        if (l_key == null) {
            return null;
        }
        return (Attribute)this.m_map.get(l_key);
    }

    public NamingEnumeration getAll() {
        return new IteratorNamingEnumeration(this.m_map.values().iterator());
    }

    public NamingEnumeration getIDs() {
        return new IteratorNamingEnumeration(this.m_map.keySet().iterator());
    }

    public Attribute put(String a_attrId, Object a_val) {
        super.lockCheck("Attempt to add value to locked Attributes");
        Attribute l_attr = this.get(a_attrId);
        if (l_attr == null) {
            l_attr = new LockableAttributeImpl((Lockable)this, a_attrId);
            this.setUserProvidedId(a_attrId);
        }
        l_attr.add(a_val);
        this.m_map.put(a_attrId, l_attr);
        return l_attr;
    }

    public Attribute put(Attribute a_attr) {
        super.lockCheck("Attempt to Attribute to locked Attributes");
        Attribute l_old = this.get(a_attr.getID());
        if (l_old != null) {
            this.m_map.remove(l_old.getID());
            this.m_keyMap.remove(l_old.getID().toLowerCase());
        }
        this.m_map.put(a_attr.getID(), a_attr);
        this.setUserProvidedId(a_attr.getID());
        return l_old;
    }

    public Attribute remove(String a_attrId) {
        super.lockCheck("Attempt to remove Attribute from locked Attributes");
        Attribute l_old = this.get(a_attrId);
        if (l_old != null) {
            this.m_map.remove(l_old.getID());
            this.m_keyMap.remove(l_old.getID().toLowerCase());
        }
        return l_old;
    }

    public Object clone() {
        return new LockableAttributesImpl(this.getParent(), this.m_map, this.m_keyMap);
    }

    public String toString() {
        StringBuffer l_buf = new StringBuffer();
        Iterator l_attrs = this.m_map.values().iterator();
        while (l_attrs.hasNext()) {
            Attribute l_attr = (Attribute)l_attrs.next();
            try {
                NamingEnumeration<?> l_values = l_attr.getAll();
                while (l_values.hasMore()) {
                    String l_value = (String)l_values.next();
                    l_buf.append(l_attr.getID());
                    l_buf.append(": ");
                    l_buf.append(l_value);
                    l_buf.append('\n');
                }
            }
            catch (NamingException e) {
                l_buf.append(ExceptionUtil.printStackTrace((Throwable)e));
            }
        }
        return l_buf.toString();
    }

    private void setUserProvidedId(String a_userProvidedId) {
        if (this.m_keyMap.get(a_userProvidedId) == null) {
            this.m_keyMap.put(a_userProvidedId.toLowerCase(), a_userProvidedId);
        }
    }

    private String getUserProvidedId(String a_attrId) {
        if (this.m_map.containsKey(a_attrId)) {
            return a_attrId;
        }
        return (String)this.m_keyMap.get(a_attrId.toLowerCase());
    }
}

