/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message.spi;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.ldap.common.message.spi.DecoderSpi;
import org.apache.ldap.common.message.spi.EncoderSpi;
import org.apache.ldap.common.message.spi.ProviderException;
import org.apache.ldap.common.message.spi.TransformerSpi;
import org.apache.ldap.common.util.StringTools;

public abstract class Provider {
    public static final String DEFAULT_PROVIDER = "org.apache.ldap.common.berlib.snacc.SnaccProvider";
    public static final String BERLIB_PROVIDER = "asn.1.berlib.provider";
    public static final String BERLIB_PROPFILE = "berlib.properties";
    private final String m_name;
    private final String m_vendor;

    protected Provider(String a_name, String a_vendor) {
        this.m_name = a_name;
        this.m_vendor = a_vendor;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String getVendor() {
        return this.m_vendor;
    }

    public abstract EncoderSpi getEncoder() throws ProviderException;

    public abstract DecoderSpi getDecoder() throws ProviderException;

    public abstract TransformerSpi getTransformer() throws ProviderException;

    public static Provider getProvider() throws ProviderException {
        return Provider.getProvider(Provider.getEnvironment());
    }

    public static Provider getProvider(Properties a_env) throws ProviderException {
        Provider l_provider = null;
        Object l_providerClass = null;
        String l_className = a_env.getProperty(BERLIB_PROVIDER);
        if (l_className == null || l_className.trim().equals("")) {
            throw new ProviderException(null, "Could not instantiate provider - environment does not specify asn.1.berlib.provider property!");
        }
        try {
            Class<?> l_clazz = Class.forName(l_className);
            Method l_method = l_clazz.getMethod("getProvider", null);
            l_provider = (Provider)l_method.invoke(null, null);
        }
        catch (ClassNotFoundException cnfe) {
            ProviderException l_pe = new ProviderException(null, "Count not find the Provider class " + l_className);
            l_pe.addThrowable(cnfe);
            throw l_pe;
        }
        catch (NoSuchMethodException nsme) {
            ProviderException l_pe = new ProviderException(null, "Count not invoke the Provider's factory method: " + l_className + ".getProvider() - it may not exist!");
            l_pe.addThrowable(nsme);
            throw l_pe;
        }
        catch (IllegalAccessException iae) {
            ProviderException l_pe = new ProviderException(null, "Count not invoke the Provider's factory method: " + l_className + ".getProvider() - it does seem to be a public method!");
            l_pe.addThrowable(iae);
            throw l_pe;
        }
        catch (InvocationTargetException ite) {
            ProviderException l_pe = new ProviderException(null, "Call to Provider's factory method: " + l_className + ".getProvider() threw the following exception:\n" + ite.getTargetException());
            l_pe.addThrowable(ite.getTargetException());
            throw l_pe;
        }
        return l_provider;
    }

    public static Properties getEnvironment() {
        File l_propFile;
        String l_cp = System.getProperty("java.class.path");
        FileFilter l_filter = new FileFilter(){

            public boolean accept(File a_file) {
                return a_file.exists() && a_file.isDirectory();
            }
        };
        List l_paths = StringTools.getPaths(l_cp, l_filter);
        Properties l_env = null;
        for (int ii = 0; ii < l_paths.size(); ++ii) {
            File l_dir = new File((String)l_paths.get(ii));
            File l_propFile2 = new File(l_dir, BERLIB_PROPFILE);
            if (!l_propFile2.exists()) continue;
            l_env = new Properties();
            try {
                l_env.load(new FileInputStream(l_propFile2));
            }
            catch (FileNotFoundException fnfe) {
                ProviderException l_pe = new ProviderException(null, "Failed to load " + l_propFile2.getAbsolutePath());
                l_pe.addThrowable(fnfe);
            }
            catch (IOException ioe) {
                ProviderException l_pe = new ProviderException(null, "Failed to load " + l_propFile2.getAbsolutePath());
                l_pe.addThrowable(ioe);
            }
            break;
        }
        File l_javaHome = new File(System.getProperty("java.home"), "lib");
        if (l_env == null && (l_propFile = new File(l_javaHome, BERLIB_PROPFILE)).exists()) {
            ProviderException l_pe;
            l_env = new Properties();
            try {
                l_env.load(new FileInputStream(l_propFile));
            }
            catch (FileNotFoundException fnfe) {
                l_pe = new ProviderException(null, "Failed to load " + l_propFile.getAbsolutePath());
                l_pe.addThrowable(fnfe);
            }
            catch (IOException ioe) {
                l_pe = new ProviderException(null, "Failed to load " + l_propFile.getAbsolutePath());
                l_pe.addThrowable(ioe);
            }
        }
        if (l_env == null) {
            System.err.println("Could not find the ASN.1 berlib provider properties file: berlib.properties.\nFile is not present on the classpath or in $JAVA_HOME/lib:\n\tjava.home = " + System.getProperty("java.home") + "\n\tjava.class.path = " + System.getProperty("java.class.path"));
            System.err.println("Using default provider class: org.apache.ldap.common.berlib.snacc.SnaccProvider");
            l_env = new Properties();
            l_env.setProperty(BERLIB_PROVIDER, DEFAULT_PROVIDER);
        }
        if (((Hashtable)System.getProperties()).containsKey(BERLIB_PROVIDER) && System.getProperty(BERLIB_PROVIDER) != null) {
            l_env.setProperty(BERLIB_PROVIDER, System.getProperty(BERLIB_PROVIDER));
        }
        return l_env;
    }
}

