/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.name;

import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamSelector;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.ExceptionUtil;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.name.NameComponentNormalizer;
import org.apache.ldap.common.name.antlrNameParser;
import org.apache.ldap.common.name.antlrTypeLexer;
import org.apache.ldap.common.name.antlrValueLexer;

public class DnParser
implements NameParser {
    private PipedOutputStream m_parserIn;
    private TokenStreamSelector m_selector;
    private final boolean m_isNormalizing;
    private antlrNameParser m_parser;

    public DnParser() throws IOException {
        this.m_isNormalizing = false;
        this.init();
    }

    public DnParser(NameComponentNormalizer a_normalizer) throws IOException {
        this.init();
        this.m_isNormalizing = true;
        this.m_parser.setNormalizer(a_normalizer);
    }

    public boolean isNormizing() {
        return this.m_isNormalizing;
    }

    private void init() throws IOException {
        this.m_parserIn = new PipedOutputStream();
        this.m_selector = new TokenStreamSelector();
        PipedInputStream l_in = new PipedInputStream();
        this.m_parserIn.connect(l_in);
        antlrTypeLexer l_typeLexer = new antlrTypeLexer(l_in);
        this.m_selector.addInputStream((TokenStream)l_typeLexer, "typeLexer");
        l_typeLexer.setSelector(this.m_selector);
        antlrValueLexer l_valueLexer = new antlrValueLexer(l_typeLexer.getInputState());
        this.m_selector.addInputStream((TokenStream)l_valueLexer, "valueLexer");
        l_typeLexer.setSelector(this.m_selector);
        l_typeLexer.setSelector(this.m_selector);
        l_valueLexer.setSelector(this.m_selector);
        this.m_selector.select("typeLexer");
        this.m_parser = new antlrNameParser((TokenStream)this.m_selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name parse(String a_name, LdapName a_emptyName) throws NamingException {
        if (a_name == null || a_name.trim().equals("")) {
            return null == a_emptyName ? new LdapName() : a_emptyName;
        }
        try {
            PipedOutputStream pipedOutputStream = this.m_parserIn;
            synchronized (pipedOutputStream) {
                this.m_parserIn.write(a_name.getBytes());
                this.m_parserIn.write(35);
                this.m_parserIn.write(10);
                this.m_parserIn.flush();
                if (null == a_emptyName) {
                    a_emptyName = new LdapName(this.m_parser.name());
                } else {
                    a_emptyName.setList(this.m_parser.name());
                }
            }
        }
        catch (IOException e) {
            String l_msg = "Parser failure on name:\n\t" + a_name;
            l_msg = l_msg + "\nAntlr exception trace:\n" + ExceptionUtil.printStackTrace((Throwable)e);
            try {
                this.init();
            }
            catch (IOException a_initError) {
                throw new NamingException("Failed to reinitialize dn parser");
            }
            throw new NamingException(l_msg);
        }
        catch (RecognitionException e) {
            String l_msg = "[34] Parser failure on name:\n\t" + a_name;
            l_msg = l_msg + "\nAntlr exception trace:\n" + ExceptionUtil.printStackTrace((Throwable)e);
            try {
                this.init();
            }
            catch (IOException a_initError) {
                throw new NamingException("Failed to reinitialize dn parser");
            }
            throw new InvalidNameException(l_msg);
        }
        catch (TokenStreamException e2) {
            String l_msg = "[34] Parser failure on name:\n\t" + a_name;
            l_msg = l_msg + "\nAntlr exception trace:\n" + ExceptionUtil.printStackTrace((Throwable)e2);
            try {
                this.init();
            }
            catch (IOException a_initError) {
                throw new NamingException("Failed to reinitialize dn parser");
            }
            throw new InvalidNameException(l_msg);
        }
        catch (CascadingRuntimeException e) {
            Throwable l_throwable = e.getCause();
            if (l_throwable instanceof NamingException) {
                NamingException l_ne = (NamingException)l_throwable;
                throw l_ne;
            }
            throw e;
        }
        return a_emptyName;
    }

    public Name parse(String a_name) throws NamingException {
        return this.parse(a_name, new LdapName());
    }
}

