/*
 * Decompiled with CFR 0.152.
 */
package li.songe.json5;

import java.util.HashMap;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u0017\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0017\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0017\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0017\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0017\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0017\u0010\r\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0017\u0010\u000e\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0017\u0010\u000f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u001a\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0000\u001a\u001a\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"unicodeLetterCategories", "Ljava/util/HashSet;", "Lkotlin/text/CharCategory;", "unicodeIdCategories", "isIdStartChar", "", "c", "", "(Ljava/lang/Character;)Z", "isIdContinueChar", "isDigit", "isHexDigit", "isPowerStartChar", "isHexStartChar", "isWhiteSpace", "isNewLine", "escapeReplacements", "Ljava/util/HashMap;", "", "stringifyString", "value", "singleQuote", "stringifyKey", "key", "json5"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\nli/songe/json5/UtilKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,150:1\n1188#2,3:151\n*S KotlinDebug\n*F\n+ 1 Util.kt\nli/songe/json5/UtilKt\n*L\n100#1:151,3\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final HashSet<CharCategory> unicodeLetterCategories;
    @NotNull
    private static final HashSet<CharCategory> unicodeIdCategories;
    @NotNull
    private static final HashMap<Character, String> escapeReplacements;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIdStartChar(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) return false;
        c2.charValue();
        if (unicodeLetterCategories.contains(CharsKt.getCategory((char)c.charValue()))) return true;
        char c3 = '_';
        if (c.charValue() == c3) return true;
        c3 = '$';
        if (c.charValue() != c3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIdContinueChar(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) return false;
        c2.charValue();
        if (UtilKt.isIdStartChar(c)) return true;
        if (unicodeIdCategories.contains(CharsKt.getCategory((char)c.charValue()))) return true;
        char c3 = '\u200c';
        if (c.charValue() == c3) return true;
        c3 = '\u200d';
        if (c.charValue() != c3) return false;
        return true;
    }

    public static final boolean isDigit(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) {
            return false;
        }
        c2.charValue();
        return new CharRange('0', '9').contains(c.charValue());
    }

    public static final boolean isHexDigit(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) {
            return false;
        }
        c2.charValue();
        return new CharRange('0', '9').contains(c.charValue()) || new CharRange('A', 'F').contains(c.charValue()) || new CharRange('a', 'f').contains(c.charValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPowerStartChar(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) return false;
        c2.charValue();
        char c3 = 'e';
        if (c.charValue() == c3) return true;
        c3 = 'E';
        if (c.charValue() != c3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isHexStartChar(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) return false;
        c2.charValue();
        char c3 = 'x';
        if (c.charValue() == c3) return true;
        c3 = 'X';
        if (c.charValue() != c3) return false;
        return true;
    }

    public static final boolean isWhiteSpace(@Nullable Character c) {
        boolean bl;
        Character c2 = c;
        if (c2 == null) {
            return false;
        }
        c2.charValue();
        Character c3 = c;
        char c4 = '\t';
        if (c3.charValue() == c4) {
            bl = true;
        } else if (new CharRange('\n', '\r').contains(c3.charValue())) {
            bl = true;
        } else {
            c4 = ' ';
            if (c3.charValue() == c4) {
                bl = true;
            } else {
                c4 = '\u00a0';
                if (c3.charValue() == c4) {
                    bl = true;
                } else {
                    c4 = '\u2028';
                    if (c3.charValue() == c4) {
                        bl = true;
                    } else {
                        c4 = '\u2029';
                        if (c3.charValue() == c4) {
                            bl = true;
                        } else {
                            c4 = '\ufeff';
                            if (c3.charValue() == c4) {
                                bl = true;
                            } else {
                                c4 = '\u1680';
                                if (c3.charValue() == c4) {
                                    bl = true;
                                } else if (new CharRange('\u2000', '\u200a').contains(c3.charValue())) {
                                    bl = true;
                                } else {
                                    c4 = '\u202f';
                                    if (c3.charValue() == c4) {
                                        bl = true;
                                    } else {
                                        c4 = '\u205f';
                                        if (c3.charValue() == c4) {
                                            bl = true;
                                        } else {
                                            c4 = '\u3000';
                                            bl = c3.charValue() == c4;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    public static final boolean isNewLine(@Nullable Character c) {
        boolean bl;
        Character c2 = c;
        if (c2 == null) {
            return false;
        }
        c2.charValue();
        Character c3 = c;
        char c4 = '\n';
        if (c3.charValue() == c4) {
            bl = true;
        } else {
            c4 = '\r';
            if (c3.charValue() == c4) {
                bl = true;
            } else {
                c4 = '\u2028';
                if (c3.charValue() == c4) {
                    bl = true;
                } else {
                    c4 = '\u2029';
                    bl = c3.charValue() == c4;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String stringifyString(@NotNull String value, boolean singleQuote) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        char wrapChar = singleQuote ? (char)'\'' : '\"';
        StringBuilder sb = new StringBuilder();
        sb.append(wrapChar);
        CharSequence $this$forEachIndexed$iv = value;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            StringBuilder stringBuilder;
            void c;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int i2 = n;
            boolean bl = false;
            if (c == wrapChar) {
                stringBuilder = sb.append("\\" + wrapChar);
                continue;
            }
            if (c == false) {
                if (UtilKt.isDigit(StringsKt.getOrNull((CharSequence)value, (int)(i2 + 1)))) {
                    stringBuilder = sb.append("\\x00");
                    continue;
                }
                stringBuilder = sb.append("\\0");
                continue;
            }
            if (escapeReplacements.keySet().contains(Character.valueOf((char)c))) {
                stringBuilder = sb.append(escapeReplacements.get(Character.valueOf((char)c)));
                continue;
            }
            void var12_12 = c;
            boolean bl2 = false <= var12_12 ? var12_12 < 16 : false;
            if (bl2) {
                String string = Integer.toString((int)c, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                stringBuilder = sb.append("\\x0" + string);
                continue;
            }
            var12_12 = c;
            boolean bl3 = false <= var12_12 ? var12_12 < 32 : false;
            if (bl3) {
                String string = Integer.toString((int)c, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                stringBuilder = sb.append("\\x" + string);
                continue;
            }
            stringBuilder = sb.append((char)c);
        }
        sb.append(wrapChar);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String stringifyString$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return UtilKt.stringifyString(string, bl);
    }

    @NotNull
    public static final String stringifyKey(@NotNull String key, boolean singleQuote) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (((CharSequence)key).length() == 0) {
            return UtilKt.stringifyString(key, singleQuote);
        }
        if (!UtilKt.isIdStartChar(Character.valueOf(key.charAt(0)))) {
            return UtilKt.stringifyString(key, singleQuote);
        }
        int n = key.length();
        for (int i = 0; i < n; ++i) {
            char c = key.charAt(i);
            if (UtilKt.isIdContinueChar(Character.valueOf(c))) continue;
            return UtilKt.stringifyString(key, singleQuote);
        }
        return key;
    }

    public static /* synthetic */ String stringifyKey$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return UtilKt.stringifyKey(string, bl);
    }

    static {
        Object[] objectArray = new CharCategory[]{CharCategory.UPPERCASE_LETTER, CharCategory.LOWERCASE_LETTER, CharCategory.TITLECASE_LETTER, CharCategory.MODIFIER_LETTER, CharCategory.OTHER_LETTER, CharCategory.LETTER_NUMBER};
        unicodeLetterCategories = SetsKt.hashSetOf((Object[])objectArray);
        objectArray = new CharCategory[]{CharCategory.NON_SPACING_MARK, CharCategory.COMBINING_SPACING_MARK, CharCategory.DECIMAL_DIGIT_NUMBER, CharCategory.CONNECTOR_PUNCTUATION};
        unicodeIdCategories = SetsKt.hashSetOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\\'), (Object)"\\\\"), TuplesKt.to((Object)Character.valueOf('\b'), (Object)"\\b"), TuplesKt.to((Object)Character.valueOf('\f'), (Object)"\\f"), TuplesKt.to((Object)Character.valueOf('\n'), (Object)"\\n"), TuplesKt.to((Object)Character.valueOf('\r'), (Object)"\\r"), TuplesKt.to((Object)Character.valueOf('\t'), (Object)"\\t"), TuplesKt.to((Object)Character.valueOf('\u000b'), (Object)"\\v"), TuplesKt.to((Object)Character.valueOf('\u0000'), (Object)"\\0"), TuplesKt.to((Object)Character.valueOf('\u2028'), (Object)"\\u2028"), TuplesKt.to((Object)Character.valueOf('\u2029'), (Object)"\\u2029")};
        escapeReplacements = MapsKt.hashMapOf((Pair[])objectArray);
    }
}

