/*
 * Decompiled with CFR 0.152.
 */
package li.songe.json5;

import java.util.HashMap;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0017\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0017\u0010\n\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0017\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0017\u0010\f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0017\u0010\r\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0017\u0010\u000e\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0017\u0010\u000f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0006H\u0000\u001a \u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0000\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u0015j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"unicodeLetterCategories", "Ljava/util/HashSet;", "Lkotlin/text/CharCategory;", "Lkotlin/collections/HashSet;", "unicodeIdCategories", "isIdStartChar", "", "c", "", "(Ljava/lang/Character;)Z", "isIdContinueChar", "isDigit", "isHexDigit", "isPowerStartChar", "isHexStartChar", "isWhiteSpace", "newLineChars", "", "getNewLineChars", "()[C", "escapeReplacements", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "stringifyString", "value", "singleQuote", "stringifyKey", "unquotedKey", "json5"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\nli/songe/json5/UtilKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,142:1\n1188#2,3:143\n*S KotlinDebug\n*F\n+ 1 Util.kt\nli/songe/json5/UtilKt\n*L\n92#1:143,3\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final HashSet<CharCategory> unicodeLetterCategories;
    @NotNull
    private static final HashSet<CharCategory> unicodeIdCategories;
    @NotNull
    private static final char[] newLineChars;
    @NotNull
    private static final HashMap<Character, String> escapeReplacements;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIdStartChar(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) return false;
        c2.charValue();
        if (unicodeLetterCategories.contains(CharsKt.getCategory((char)c.charValue()))) return true;
        char c3 = '_';
        if (c.charValue() == c3) return true;
        c3 = '$';
        if (c.charValue() != c3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIdContinueChar(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) return false;
        c2.charValue();
        if (UtilKt.isIdStartChar(c)) return true;
        if (unicodeIdCategories.contains(CharsKt.getCategory((char)c.charValue()))) return true;
        char c3 = '\u200c';
        if (c.charValue() == c3) return true;
        c3 = '\u200d';
        if (c.charValue() != c3) return false;
        return true;
    }

    public static final boolean isDigit(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) {
            return false;
        }
        c2.charValue();
        return new CharRange('0', '9').contains(c.charValue());
    }

    public static final boolean isHexDigit(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) {
            return false;
        }
        c2.charValue();
        return new CharRange('0', '9').contains(c.charValue()) || new CharRange('A', 'F').contains(c.charValue()) || new CharRange('a', 'f').contains(c.charValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPowerStartChar(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) return false;
        c2.charValue();
        char c3 = 'e';
        if (c.charValue() == c3) return true;
        c3 = 'E';
        if (c.charValue() != c3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isHexStartChar(@Nullable Character c) {
        Character c2 = c;
        if (c2 == null) return false;
        c2.charValue();
        char c3 = 'x';
        if (c.charValue() == c3) return true;
        c3 = 'X';
        if (c.charValue() != c3) return false;
        return true;
    }

    public static final boolean isWhiteSpace(@Nullable Character c) {
        boolean bl;
        Character c2 = c;
        if (c2 == null) {
            return false;
        }
        c2.charValue();
        Character c3 = c;
        char c4 = '\t';
        if (c3.charValue() == c4) {
            bl = true;
        } else if (new CharRange('\n', '\r').contains(c3.charValue())) {
            bl = true;
        } else {
            c4 = ' ';
            if (c3.charValue() == c4) {
                bl = true;
            } else {
                c4 = '\u00a0';
                if (c3.charValue() == c4) {
                    bl = true;
                } else {
                    c4 = '\u2028';
                    if (c3.charValue() == c4) {
                        bl = true;
                    } else {
                        c4 = '\u2029';
                        if (c3.charValue() == c4) {
                            bl = true;
                        } else {
                            c4 = '\ufeff';
                            if (c3.charValue() == c4) {
                                bl = true;
                            } else {
                                c4 = '\u1680';
                                if (c3.charValue() == c4) {
                                    bl = true;
                                } else if (new CharRange('\u2000', '\u200a').contains(c3.charValue())) {
                                    bl = true;
                                } else {
                                    c4 = '\u202f';
                                    if (c3.charValue() == c4) {
                                        bl = true;
                                    } else {
                                        c4 = '\u205f';
                                        if (c3.charValue() == c4) {
                                            bl = true;
                                        } else {
                                            c4 = '\u3000';
                                            bl = c3.charValue() == c4;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    @NotNull
    public static final char[] getNewLineChars() {
        return newLineChars;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String stringifyString(@NotNull String value, boolean singleQuote) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        char wrapChar = singleQuote ? (char)'\'' : '\"';
        StringBuilder sb = new StringBuilder();
        sb.append(wrapChar);
        CharSequence $this$forEachIndexed$iv = value;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            StringBuilder stringBuilder;
            void c;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int i2 = n;
            boolean bl = false;
            if (c == wrapChar) {
                stringBuilder = sb.append("\\" + wrapChar);
                continue;
            }
            if (c == false) {
                if (UtilKt.isDigit(StringsKt.getOrNull((CharSequence)value, (int)(i2 + 1)))) {
                    stringBuilder = sb.append("\\x00");
                    continue;
                }
                stringBuilder = sb.append("\\0");
                continue;
            }
            if (escapeReplacements.keySet().contains(Character.valueOf((char)c))) {
                stringBuilder = sb.append(escapeReplacements.get(Character.valueOf((char)c)));
                continue;
            }
            void var12_12 = c;
            boolean bl2 = false <= var12_12 ? var12_12 < 16 : false;
            if (bl2) {
                String string = Integer.toString((int)c, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                stringBuilder = sb.append("\\x0" + string);
                continue;
            }
            var12_12 = c;
            boolean bl3 = false <= var12_12 ? var12_12 < 32 : false;
            if (bl3) {
                String string = Integer.toString((int)c, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                stringBuilder = sb.append("\\x" + string);
                continue;
            }
            stringBuilder = sb.append((char)c);
        }
        sb.append(wrapChar);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String stringifyKey(@NotNull String value, boolean singleQuote, boolean unquotedKey) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0 || !unquotedKey) {
            return UtilKt.stringifyString(value, singleQuote);
        }
        if (!UtilKt.isIdStartChar(Character.valueOf(value.charAt(0)))) {
            return UtilKt.stringifyString(value, singleQuote);
        }
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            if (UtilKt.isIdContinueChar(Character.valueOf(c))) continue;
            return UtilKt.stringifyString(value, singleQuote);
        }
        return value;
    }

    static {
        Object[] objectArray = new CharCategory[]{CharCategory.UPPERCASE_LETTER, CharCategory.LOWERCASE_LETTER, CharCategory.TITLECASE_LETTER, CharCategory.MODIFIER_LETTER, CharCategory.OTHER_LETTER, CharCategory.LETTER_NUMBER};
        unicodeLetterCategories = SetsKt.hashSetOf((Object[])objectArray);
        objectArray = new CharCategory[]{CharCategory.NON_SPACING_MARK, CharCategory.COMBINING_SPACING_MARK, CharCategory.DECIMAL_DIGIT_NUMBER, CharCategory.CONNECTOR_PUNCTUATION};
        unicodeIdCategories = SetsKt.hashSetOf((Object[])objectArray);
        char[] cArray = "\n\r\u2028\u2029".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        newLineChars = cArray;
        objectArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\\'), (Object)"\\\\"), TuplesKt.to((Object)Character.valueOf('\b'), (Object)"\\b"), TuplesKt.to((Object)Character.valueOf('\f'), (Object)"\\f"), TuplesKt.to((Object)Character.valueOf('\n'), (Object)"\\n"), TuplesKt.to((Object)Character.valueOf('\r'), (Object)"\\r"), TuplesKt.to((Object)Character.valueOf('\t'), (Object)"\\t"), TuplesKt.to((Object)Character.valueOf('\u000b'), (Object)"\\v"), TuplesKt.to((Object)Character.valueOf('\u0000'), (Object)"\\0"), TuplesKt.to((Object)Character.valueOf('\u2028'), (Object)"\\u2028"), TuplesKt.to((Object)Character.valueOf('\u2029'), (Object)"\\u2029")};
        escapeReplacements = MapsKt.hashMapOf((Pair[])objectArray);
    }
}

