/*
 * Decompiled with CFR 0.152.
 */
package li.songe.json5;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u00a8\u0006\u000e"}, d2={"hexToDecimal", "", "hexStr", "getHexDigit", "c", "", "multiplyBy16", "numStr", "multiplyBySingleDigit", "digit", "", "addStrings", "num1", "num2", "json5"})
public final class HexUtilKt {
    @NotNull
    public static final String hexToDecimal(@NotNull String hexStr) {
        Intrinsics.checkNotNullParameter((Object)hexStr, (String)"hexStr");
        String decimalStr = "0";
        int n = hexStr.length();
        for (int i = 0; i < n; ++i) {
            char c = hexStr.charAt(i);
            decimalStr = HexUtilKt.addStrings(HexUtilKt.multiplyBy16(decimalStr), HexUtilKt.getHexDigit(c));
        }
        return decimalStr;
    }

    private static final String getHexDigit(char c) {
        return switch (c) {
            case '0' -> "0";
            case '1' -> "1";
            case '2' -> "2";
            case '3' -> "3";
            case '4' -> "4";
            case '5' -> "5";
            case '6' -> "6";
            case '7' -> "7";
            case '8' -> "8";
            case '9' -> "9";
            case 'a' -> "10";
            case 'b' -> "11";
            case 'c' -> "12";
            case 'd' -> "13";
            case 'e' -> "14";
            case 'f' -> "15";
            case 'A' -> "10";
            case 'B' -> "11";
            case 'C' -> "12";
            case 'D' -> "13";
            case 'E' -> "14";
            case 'F' -> "15";
            default -> throw new IllegalArgumentException("invalid hex digit: " + c);
        };
    }

    private static final String multiplyBy16(String numStr) {
        if (Intrinsics.areEqual((Object)numStr, (Object)"0")) {
            return "0";
        }
        String multipliedBy10 = numStr + "0";
        String multipliedBy6 = HexUtilKt.multiplyBySingleDigit(numStr, 6);
        return HexUtilKt.addStrings(multipliedBy10, multipliedBy6);
    }

    private static final String multiplyBySingleDigit(String numStr, int digit) {
        if (digit == 0) {
            return "0";
        }
        Object result = "";
        int carry = 0;
        for (int i = numStr.length() - 1; -1 < i; --i) {
            int currentDigit = numStr.charAt(i) - 48;
            int product = currentDigit * digit + carry;
            result = product % 10 + (String)result;
            carry = product / 10;
        }
        if (carry > 0) {
            result = carry + (String)result;
        }
        return result;
    }

    private static final String addStrings(String num1, String num2) {
        int i = num1.length() - 1;
        int j = num2.length() - 1;
        int carry = 0;
        StringBuilder result = new StringBuilder();
        while (i >= 0 || j >= 0 || carry > 0) {
            int digit1 = i >= 0 ? num1.charAt(i--) - 48 : 0;
            int digit2 = j >= 0 ? num2.charAt(j--) - 48 : 0;
            int sum = digit1 + digit2 + carry;
            result.append(sum % 10);
            carry = sum / 10;
        }
        String string = result.reverse().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

