/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import li.strolch.model.Order;
import li.strolch.persistence.api.StrolchPersistenceException;
import li.strolch.persistence.api.TransactionResult;
import li.strolch.persistence.postgresql.DataType;
import li.strolch.persistence.postgresql.PostgreSqlOrderDao;

public class ArchivePostgreSqlOrderDao
extends PostgreSqlOrderDao {
    public static final String TABLE_NAME = "archive_orders";
    private boolean descending;

    public ArchivePostgreSqlOrderDao(DataType dataType, Connection connection, TransactionResult txResult, boolean versioningEnabled) {
        super(dataType, connection, txResult, versioningEnabled);
    }

    @Override
    protected String getTableName() {
        return TABLE_NAME;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Order> queryAll(long limit, long offset, String ... types) {
        if (types.length == 0) {
            return this.queryAll(limit, offset);
        }
        ArrayList<Order> list = new ArrayList<Order>();
        String ordering = this.descending ? "DESC" : "ASC";
        Object sql = "select id, type, asxml from {0} where type = ANY(?) and latest = true order by date " + ordering + " limit {1,number,#} offset {2,number,#}";
        sql = MessageFormat.format((String)sql, TABLE_NAME, limit, offset);
        try (PreparedStatement statement = this.connection.prepareStatement((String)sql);){
            ArrayList<Order> arrayList;
            block16: {
                Array typesArray = statement.getConnection().createArrayOf("varchar", types);
                statement.setArray(1, typesArray);
                ResultSet result = statement.executeQuery();
                try {
                    while (result.next()) {
                        String id = result.getString("id");
                        String type = result.getString("type");
                        list.add((Order)this.parseDbObject(result, id, type));
                    }
                    arrayList = list;
                    if (result == null) break block16;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
    }
}

