/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import li.strolch.model.activity.Activity;
import li.strolch.model.json.ActivityFromJsonVisitor;
import li.strolch.model.xml.SimpleStrolchElementListener;
import li.strolch.model.xml.StrolchElementListener;
import li.strolch.model.xml.XmlModelSaxReader;
import li.strolch.persistence.api.ActivityDao;
import li.strolch.persistence.api.StrolchPersistenceException;
import li.strolch.persistence.api.TransactionResult;
import li.strolch.persistence.postgresql.DataType;
import li.strolch.persistence.postgresql.PostgresqlDao;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PostgreSqlActivityDao
extends PostgresqlDao<Activity>
implements ActivityDao {
    public static final String ACTIVITIES = "activities";
    private static final String insertAsXmlSqlS = "insert into {0} (id, version, created_by, created_at, updated_at, deleted, latest, name, type, state, asxml) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?::order_state, ?)";
    private static final String insertAsJsonSqlS = "insert into {0} (id, version, created_by, created_at, updated_at, deleted, latest, name, type, state, asjson) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?::order_state, ?)";
    private static final String updateAsXmlSqlS = "update {0} set created_by = ?, created_at = ?, updated_at = ?, deleted = ?, latest = ?, name = ?, type = ?, state = ?::order_state, asxml = ? where id = ? and version = ?";
    private static final String updateAsJsonSqlS = "update {0} set created_by = ?, created_at = ?, updated_at = ?, deleted = ?, latest = ?, name = ?, type = ?, state = ?::order_state, asjson = ? where id = ? and version = ?";
    private static final String updateLatestSqlS = "update {0} SET latest = false WHERE id = ? AND version = ?";

    public PostgreSqlActivityDao(DataType dataType, Connection connection, TransactionResult txResult, boolean versioningEnabled) {
        super(dataType, connection, txResult, versioningEnabled);
    }

    @Override
    protected String getClassName() {
        return "Activity";
    }

    @Override
    protected String getTableName() {
        return ACTIVITIES;
    }

    @Override
    protected Activity parseFromXml(String id, String type, SQLXML sqlxml) {
        SimpleStrolchElementListener listener = new SimpleStrolchElementListener();
        try (InputStream binaryStream = sqlxml.getBinaryStream();){
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(binaryStream, (DefaultHandler)new XmlModelSaxReader((StrolchElementListener)listener));
        }
        catch (IOException | SQLException | ParserConfigurationException | SAXException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to extract Activity from sqlxml value for {0} / {1}", id, type), (Throwable)e);
        }
        if (listener.getActivities().size() == 0) {
            throw new StrolchPersistenceException(MessageFormat.format("No Activity parsed from sqlxml value for {0} / {1}", id, type));
        }
        if (listener.getActivities().size() > 1) {
            throw new StrolchPersistenceException(MessageFormat.format("Multiple Activities parsed from sqlxml value for {0} / {1}", id, type));
        }
        return (Activity)listener.getActivities().get(0);
    }

    @Override
    protected Activity parseFromJson(String id, String type, String json) {
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        return new ActivityFromJsonVisitor().visit(jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalSave(Activity activity) {
        PreparedStatement preparedStatement;
        String sql = this.getSql(insertAsXmlSqlS, insertAsJsonSqlS);
        try {
            preparedStatement = this.connection.prepareStatement(sql);
            try {
                preparedStatement.setString(1, activity.getId());
                preparedStatement.setInt(2, activity.getVersion().getVersion());
                preparedStatement.setString(3, activity.getVersion().getCreatedBy());
                preparedStatement.setTimestamp(4, new Timestamp(activity.getVersion().getCreated().getTime()), Calendar.getInstance());
                preparedStatement.setTimestamp(5, new Timestamp(activity.getVersion().getUpdated().getTime()), Calendar.getInstance());
                preparedStatement.setBoolean(6, activity.getVersion().isDeleted());
                preparedStatement.setBoolean(7, !activity.getVersion().isDeleted());
                preparedStatement.setString(8, activity.getName());
                preparedStatement.setString(9, activity.getType());
                preparedStatement.setString(10, activity.getState().name());
                SQLXML sqlxml = this.writeObject(preparedStatement, activity, 11);
                try {
                    int modCount = preparedStatement.executeUpdate();
                    if (modCount != 1) {
                        String msg = "Expected to save 1 element with id {0} but SQL statement modified {1} elements!";
                        msg = MessageFormat.format(msg, activity.getId(), modCount);
                        throw new StrolchPersistenceException(msg);
                    }
                }
                finally {
                    if (sqlxml != null) {
                        sqlxml.free();
                    }
                }
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException | SAXException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to insert Activity {0} due to {1}", activity.getLocator(), e.getLocalizedMessage()), (Throwable)e);
        }
        if (activity.getVersion().isFirstVersion()) {
            return;
        }
        sql = MessageFormat.format(updateLatestSqlS, this.getTableName());
        try {
            preparedStatement = this.connection.prepareStatement(sql);
            try {
                preparedStatement.setString(1, activity.getId());
                preparedStatement.setInt(2, activity.getVersion().getPreviousVersion());
                int modCount = preparedStatement.executeUpdate();
                if (modCount != 1) {
                    String msg = "Expected to update 1 previous element with id {0} and version {1} but SQL statement modified {2} elements!";
                    msg = MessageFormat.format(msg, activity.getId(), activity.getVersion().getPreviousVersion(), modCount);
                    throw new StrolchPersistenceException(msg);
                }
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to update previous version of Activity {0} due to {1}", activity.getVersion(), e.getLocalizedMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalUpdate(Activity activity) {
        if (this.versioningEnabled) {
            this.internalSave(activity);
            return;
        }
        if (!activity.getVersion().isFirstVersion()) {
            throw new StrolchPersistenceException(MessageFormat.format("Versioning is not enabled, so version must always be 0 to perform an update, but it is {0}", activity.getVersion()));
        }
        if (activity.getVersion().isDeleted()) {
            throw new StrolchPersistenceException(MessageFormat.format("Versioning is not enabled, so version can not be marked as deleted for {0}", activity.getVersion()));
        }
        String sql = this.getSql(updateAsXmlSqlS, updateAsJsonSqlS);
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setString(1, activity.getVersion().getCreatedBy());
            preparedStatement.setTimestamp(2, new Timestamp(activity.getVersion().getCreated().getTime()), Calendar.getInstance());
            preparedStatement.setTimestamp(3, new Timestamp(activity.getVersion().getUpdated().getTime()), Calendar.getInstance());
            preparedStatement.setBoolean(4, activity.getVersion().isDeleted());
            preparedStatement.setBoolean(5, !activity.getVersion().isDeleted());
            preparedStatement.setString(6, activity.getName());
            preparedStatement.setString(7, activity.getType());
            preparedStatement.setString(8, activity.getState().name());
            SQLXML sqlxml = this.writeObject(preparedStatement, activity, 9);
            preparedStatement.setString(10, activity.getId());
            preparedStatement.setInt(11, activity.getVersion().getVersion());
            try {
                int modCount = preparedStatement.executeUpdate();
                if (modCount != 1) {
                    String msg = "Expected to update 1 element with id {0} but SQL statement modified {1} elements!";
                    msg = MessageFormat.format(msg, activity.getId(), modCount);
                    throw new StrolchPersistenceException(msg);
                }
            }
            finally {
                if (sqlxml != null) {
                    sqlxml.free();
                }
            }
        }
        catch (SQLException | SAXException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to update Activity {0} due to {1}", activity.getLocator(), e.getLocalizedMessage()), (Throwable)e);
        }
    }
}

