/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import li.strolch.model.audit.AccessType;
import li.strolch.model.audit.Audit;
import li.strolch.persistence.api.AuditDao;
import li.strolch.persistence.api.StrolchPersistenceException;
import li.strolch.persistence.postgresql.PostgreSqlStrolchTransaction;
import li.strolch.utils.collections.DateRange;
import li.strolch.utils.helper.StringHelper;

public class PostgreSqlAuditDao
implements AuditDao {
    public static final String ID = "id";
    public static final String ACCESS_TYPE = "access_type";
    public static final String ACCESS_TYPE_TYPE = "::access_type";
    public static final String ACTION = "action";
    public static final String NEW_VERSION = "new_version";
    public static final String ELEMENT_TYPE = "element_type";
    public static final String ELEMENT_SUB_TYPE = "element_sub_type";
    public static final String ELEMENT_ACCESSED = "element_accessed";
    public static final String DATE = "date";
    public static final String LASTNAME = "lastname";
    public static final String FIRSTNAME = "firstname";
    public static final String USERNAME = "username";
    public static final String FIELDS = StringHelper.commaSeparated((String[])new String[]{"id", "username", "firstname", "lastname", "date", "element_type", "element_sub_type", "element_accessed", "new_version", "action", "access_type"});
    public static final String TABLE_NAME = "audits";
    private static final String hasElementSql = "select count(*) from audits where element_type = ? and id = ?";
    private static final String querySizeSql = "select count(*) from audits where date between ? and ?";
    private static final String querySizeTypeSql = "select count(*) from audits where element_type = ? and date between ? and ?";
    private static final String queryTypesSql = "select distinct element_type from audits";
    private static final String queryBySql = "select " + FIELDS + " from audits where element_type = ? and ID = ?";
    private static final String queryAllSql = "select " + FIELDS + " from audits where element_type = ? and date between ? and ?";
    private static final String insertSql = "insert into audits (" + FIELDS + ") values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?::access_type)";
    private static final String updateSql = "update audits set id = ?, username = ?, firstname = ?, lastname = ?, date = ?, element_type = ?, element_sub_type = ?, element_accessed = ?, new_version = ?, action = ?, access_type = ?::access_type where id = ?";
    private static final String removeSql = "delete from audits where id = ?";
    private static final String removeAllSql = "delete from audits where element_type = ? and date between ? and ?";
    private PostgreSqlStrolchTransaction tx;

    public PostgreSqlAuditDao(PostgreSqlStrolchTransaction postgreSqlStrolchTransaction) {
        this.tx = postgreSqlStrolchTransaction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasElement(String type, Long id) {
        try (PreparedStatement statement = this.tx.getConnection().prepareStatement(hasElementSql);){
            statement.setString(1, type);
            statement.setLong(2, id);
            try (ResultSet result = statement.executeQuery();){
                result.next();
                long numberOfElements = result.getLong(1);
                if (numberOfElements == 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (numberOfElements == 1L) {
                    boolean bl = true;
                    return bl;
                }
                String msg = MessageFormat.format("Non unique number of elements with type {0} and id {1}", type, id);
                throw new StrolchPersistenceException(msg);
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query size due to: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long querySize(DateRange dateRange) {
        try (PreparedStatement statement = this.tx.getConnection().prepareStatement(querySizeSql);){
            long l;
            block14: {
                statement.setTimestamp(1, new Timestamp(dateRange.getFromDate().getTime()), Calendar.getInstance());
                statement.setTimestamp(2, new Timestamp(dateRange.getToDate().getTime()), Calendar.getInstance());
                ResultSet result = statement.executeQuery();
                try {
                    result.next();
                    l = result.getLong(1);
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query size due to: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long querySize(String type, DateRange dateRange) {
        try (PreparedStatement statement = this.tx.getConnection().prepareStatement(querySizeTypeSql);){
            long l;
            block14: {
                statement.setString(1, type);
                statement.setTimestamp(2, new Timestamp(dateRange.getFromDate().getTime()), Calendar.getInstance());
                statement.setTimestamp(3, new Timestamp(dateRange.getToDate().getTime()), Calendar.getInstance());
                ResultSet result = statement.executeQuery();
                try {
                    result.next();
                    l = result.getLong(1);
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query size due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public Set<String> queryTypes() {
        HashSet<String> keySet = new HashSet<String>();
        try (PreparedStatement statement = this.tx.getConnection().prepareStatement(queryTypesSql);
             ResultSet result = statement.executeQuery();){
            while (result.next()) {
                keySet.add(result.getString(ELEMENT_TYPE));
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
        return keySet;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Audit queryBy(String type, Long id) {
        try (PreparedStatement statement = this.tx.getConnection().prepareStatement(queryBySql);){
            Audit audit;
            block19: {
                ResultSet result;
                block17: {
                    Audit audit2;
                    block18: {
                        statement.setString(1, type);
                        statement.setLong(2, id);
                        result = statement.executeQuery();
                        try {
                            if (result.next()) break block17;
                            audit2 = null;
                            if (result == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return audit2;
                }
                Audit audit3 = this.auditFrom(result);
                if (result.next()) {
                    throw new StrolchPersistenceException("Non unique result for query: " + queryBySql + " (type=" + type + ", id=" + id);
                }
                audit = audit3;
                if (result == null) break block19;
                result.close();
            }
            return audit;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<Audit> queryAll(String type, DateRange dateRange) {
        ArrayList<Audit> list = new ArrayList<Audit>();
        try (PreparedStatement statement = this.tx.getConnection().prepareStatement(queryAllSql);){
            statement.setString(1, type);
            statement.setTimestamp(2, new Timestamp(dateRange.getFromDate().getTime()), Calendar.getInstance());
            statement.setTimestamp(3, new Timestamp(dateRange.getToDate().getTime()), Calendar.getInstance());
            try (ResultSet result = statement.executeQuery();){
                while (result.next()) {
                    list.add(this.auditFrom(result));
                }
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public void save(Audit audit) {
        try (PreparedStatement preparedStatement = this.tx.getConnection().prepareStatement(insertSql);){
            this.setAuditFields(audit, preparedStatement);
            int count = preparedStatement.executeUpdate();
            if (count != 1) {
                throw new StrolchPersistenceException(MessageFormat.format("Expected to insert 1 record, but inserted {0} for audit {2}", count, audit.getId()));
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to insert Audit {0} due to {1}", audit, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void saveAll(List<Audit> audits) {
        for (Audit audit : audits) {
            this.save(audit);
        }
    }

    public void update(Audit audit) {
        try (PreparedStatement preparedStatement = this.tx.getConnection().prepareStatement(updateSql);){
            this.setAuditFields(audit, preparedStatement);
            preparedStatement.setLong(12, audit.getId());
            int count = preparedStatement.executeUpdate();
            if (count != 1) {
                throw new StrolchPersistenceException(MessageFormat.format("Expected to update 1 record, but updated {0} for audit {2}", count, audit.getId()));
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to update Audit {0} due to {1}", audit, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void updateAll(List<Audit> audits) {
        for (Audit audit : audits) {
            this.update(audit);
        }
    }

    public void remove(Audit audit) {
        try (PreparedStatement preparedStatement = this.tx.getConnection().prepareStatement(removeSql);){
            preparedStatement.setLong(1, audit.getId());
            int count = preparedStatement.executeUpdate();
            if (count != 1) {
                String msg = "Expected to delete 1 audit with id {0} but deleted {1} elements!";
                msg = MessageFormat.format(msg, audit.getId(), count);
                throw new StrolchPersistenceException(msg);
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to remove {0} due to {2}", audit.getId(), e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void removeAll(List<Audit> audits) {
        for (Audit audit : audits) {
            this.remove(audit);
        }
    }

    public long removeAll(String type, DateRange dateRange) {
        long l;
        block8: {
            PreparedStatement preparedStatement = this.tx.getConnection().prepareStatement(removeAllSql);
            try {
                preparedStatement.setString(1, type);
                preparedStatement.setTimestamp(2, new Timestamp(dateRange.getFromDate().getTime()), Calendar.getInstance());
                preparedStatement.setTimestamp(3, new Timestamp(dateRange.getToDate().getTime()), Calendar.getInstance());
                l = preparedStatement.executeUpdate();
                if (preparedStatement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StrolchPersistenceException(MessageFormat.format("Failed to remove all elements due to {0}", e.getLocalizedMessage()), (Throwable)e);
                }
            }
            preparedStatement.close();
        }
        return l;
    }

    private void setAuditFields(Audit audit, PreparedStatement ps) throws SQLException {
        ps.setLong(1, audit.getId());
        ps.setString(2, audit.getUsername());
        ps.setString(3, audit.getFirstname());
        ps.setString(4, audit.getLastname());
        ps.setTimestamp(5, new Timestamp(audit.getDate().getTime()), Calendar.getInstance());
        ps.setString(6, audit.getElementType());
        ps.setString(7, audit.getElementSubType());
        ps.setString(8, audit.getElementAccessed());
        if (audit.getNewVersion() == null) {
            ps.setDate(9, null);
        } else {
            ps.setTimestamp(9, new Timestamp(audit.getNewVersion().getTime()), Calendar.getInstance());
        }
        ps.setString(10, audit.getAction());
        ps.setString(11, audit.getAccessType().name());
    }

    private Audit auditFrom(ResultSet resultSet) throws SQLException {
        Audit audit = new Audit();
        audit.setId(resultSet.getLong(1));
        audit.setUsername(resultSet.getString(2));
        audit.setFirstname(resultSet.getString(3));
        audit.setLastname(resultSet.getString(4));
        audit.setDate((Date)resultSet.getTimestamp(5));
        audit.setElementType(resultSet.getString(6));
        audit.setElementSubType(resultSet.getString(7));
        audit.setElementAccessed(resultSet.getString(8));
        audit.setNewVersion((Date)resultSet.getTimestamp(9));
        audit.setAction(resultSet.getString(10));
        audit.setAccessType(AccessType.valueOf((String)resultSet.getString(11)));
        return audit;
    }
}

