/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.sql.DataSource;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchComponent;
import li.strolch.db.DbSchemaVersionCheck;
import li.strolch.persistence.api.ActivityDao;
import li.strolch.persistence.api.DataArchiveHandler;
import li.strolch.persistence.api.OrderDao;
import li.strolch.persistence.api.PersistenceHandler;
import li.strolch.persistence.api.ResourceDao;
import li.strolch.persistence.api.StrolchPersistenceException;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.persistence.api.TransactionResult;
import li.strolch.persistence.postgresql.ArchivePostgreSqlActivityDao;
import li.strolch.persistence.postgresql.ArchivePostgreSqlOrderDao;
import li.strolch.persistence.postgresql.ArchivePostgreSqlResourceDao;
import li.strolch.persistence.postgresql.DataType;
import li.strolch.persistence.postgresql.PostgreSqlPersistenceHandler;
import li.strolch.runtime.configuration.ComponentConfiguration;

public class PostgreSqlDataArchiveHandler
extends StrolchComponent
implements DataArchiveHandler {
    private static final String SCRIPT_PREFIX = "archive";

    public PostgreSqlDataArchiveHandler(ComponentContainer container, String componentName) {
        super(container, componentName);
    }

    public void start() throws Exception {
        PostgreSqlPersistenceHandler persistenceHandler = (PostgreSqlPersistenceHandler)((Object)this.getComponent(PersistenceHandler.class));
        Map<String, DataSource> dsMap = persistenceHandler.getDataSources();
        ComponentConfiguration configuration = persistenceHandler.getConfiguration();
        boolean allowSchemaCreation = configuration.getBoolean("allowSchemaCreation", Boolean.FALSE);
        boolean allowSchemaMigration = configuration.getBoolean("allowSchemaMigration", Boolean.FALSE);
        boolean allowSchemaDrop = configuration.getBoolean("allowSchemaDrop", Boolean.FALSE);
        DbSchemaVersionCheck schemaVersionCheck = new DbSchemaVersionCheck(SCRIPT_PREFIX, ((Object)((Object)this)).getClass(), allowSchemaCreation, allowSchemaMigration, allowSchemaDrop);
        schemaVersionCheck.checkSchemaVersion(dsMap);
        super.start();
    }

    public Connection getConnection(StrolchTransaction tx) {
        PostgreSqlPersistenceHandler persistenceHandler = (PostgreSqlPersistenceHandler)((Object)this.getComponent(PersistenceHandler.class));
        return persistenceHandler.getConnection(tx.getRealmName());
    }

    public void run(StrolchTransaction tx, BiConsumer<Connection, TransactionResult> runnable) {
        try (Connection connection = this.getConnection(tx);){
            TransactionResult txResult = new TransactionResult(tx.getRealmName(), System.nanoTime(), new Date());
            runnable.accept(connection, txResult);
            connection.commit();
        }
        catch (Exception e) {
            throw new StrolchPersistenceException("Archive DB Connection failed", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T runWithResult(StrolchTransaction tx, BiFunction<Connection, TransactionResult, T> runnable) {
        try (Connection connection = this.getConnection(tx);){
            TransactionResult txResult = new TransactionResult(tx.getRealmName(), System.nanoTime(), new Date());
            Connection t2 = runnable.apply(connection, txResult);
            connection.commit();
            Connection t = t2;
            return (T)t;
        }
        catch (Exception e) {
            throw new StrolchPersistenceException("Archive DB Connection failed", (Throwable)e);
        }
    }

    public OrderDao getOrderDao(Connection connection, TransactionResult txResult) {
        return new ArchivePostgreSqlOrderDao(DataType.xml, connection, txResult, false);
    }

    public ResourceDao getResourceDao(Connection connection, TransactionResult txResult) {
        return new ArchivePostgreSqlResourceDao(DataType.xml, connection, txResult, false);
    }

    public ActivityDao getActivityDao(Connection connection, TransactionResult txResult) {
        return new ArchivePostgreSqlActivityDao(DataType.xml, connection, txResult, false);
    }
}

