/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.configuration.DbConnectionBuilder;
import li.strolch.utils.dbc.DBC;

public final class PostgreSqlDbConnectionBuilder
extends DbConnectionBuilder {
    public PostgreSqlDbConnectionBuilder(ComponentContainer container, ComponentConfiguration persistenceHandlerConfiguration) {
        super(container, persistenceHandlerConfiguration);
    }

    protected void validateConnection(DataSource dataSource) {
        super.validateConnection(dataSource);
        HikariDataSource ds = (HikariDataSource)dataSource;
        ds.validate();
    }

    public DataSource build(String realm, String url, String username, String password, Properties props) {
        HikariConfig config = new HikariConfig(props);
        config.setAutoCommit(false);
        config.setPoolName(realm);
        config.setJdbcUrl(url);
        config.setUsername(username);
        config.setPassword(password);
        HikariDataSource ds = new HikariDataSource(config);
        logger.info("[" + realm + "] PostgreSQL Connection pool to " + url + " has a maximum pool size of " + ds.getMaximumPoolSize() + " connections");
        return new StrolchPostgreDataSource(ds);
    }

    public class StrolchPostgreDataSource
    implements DataSource {
        private HikariDataSource ds;

        public StrolchPostgreDataSource(HikariDataSource ds) {
            DBC.PRE.assertNotNull("DataSource must be set!", (Object)ds);
            this.ds = ds;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.ds.getLogWriter();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return (T)this.ds.unwrap(iface);
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.ds.setLogWriter(out);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.ds.isWrapperFor(iface);
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.ds.getConnection();
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.ds.setLoginTimeout(seconds);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            throw new UnsupportedOperationException("Deprecated, use parameterless version!");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.ds.getLoginTimeout();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.ds.getParentLogger();
        }

        public String toString() {
            return "HikariDataSource for realm " + this.ds.getPoolName() + " for " + this.ds.getUsername() + " at " + this.ds.getJdbcUrl();
        }

        public void shutdown() {
            this.ds.close();
        }

        public void validate() {
            this.ds.validate();
        }
    }
}

