/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import li.strolch.utils.StringMatchMode;
import li.strolch.utils.collections.DateRange;

public class PostgreSqlHelper {
    public static void toSql(String indent, StringBuilder sb, List<Object> values, String column, DateRange dateRange) {
        if (dateRange.isDate()) {
            sb.append(indent);
            sb.append(column);
            sb.append(" = ?\n");
            values.add(new Date(dateRange.getFromDate().getTime()));
        } else if (dateRange.isBounded()) {
            sb.append(indent);
            sb.append(column);
            sb.append(" between ? and ?\n");
            values.add(new Date(dateRange.getFromDate().getTime()));
            values.add(new Date(dateRange.getToDate().getTime()));
        } else if (dateRange.isToBounded()) {
            sb.append(indent);
            sb.append(column);
            sb.append(" <= ?\n");
            values.add(new Date(dateRange.getToDate().getTime()));
        } else if (dateRange.isFromBounded()) {
            sb.append(indent);
            sb.append(column);
            sb.append(" >= ?\n");
            values.add(new Date(dateRange.getFromDate().getTime()));
        }
    }

    public static String toSql(String column, String indent, StringMatchMode mm, List<Object> values, String ... query) {
        StringBuilder sb = new StringBuilder();
        if (mm.isCaseSensitve() && mm.isEquals()) {
            if (query.length == 1) {
                sb.append(column + " = ?\n");
                values.add(query[0]);
            } else {
                sb.append(column + " in ( ");
                for (int i = 0; i < query.length; ++i) {
                    sb.append("?");
                    values.add(query[i]);
                    if (i >= query.length - 1) continue;
                    sb.append(", ");
                }
                sb.append(" )\n");
            }
        } else if (!mm.isCaseSensitve() && mm.isEquals()) {
            if (query.length == 1) {
                sb.append("lower(" + column + ") = ?\n");
                values.add(query[0].toLowerCase());
            } else {
                sb.append("lower(" + column + ") in ( ");
                for (int i = 0; i < query.length; ++i) {
                    sb.append("?");
                    values.add(query[i].toLowerCase());
                    if (i >= query.length - 1) continue;
                    sb.append(", ");
                }
                sb.append(" )\n");
            }
        } else if (!mm.isEquals() && mm.isCaseSensitve()) {
            if (query.length == 1) {
                sb.append(column + " like ?\n");
                values.add("%" + query[0] + "%");
            } else {
                sb.append("(\n");
                for (int i = 0; i < query.length; ++i) {
                    sb.append(indent);
                    sb.append("  ");
                    sb.append(column + " like ?");
                    values.add("%" + query[i] + "%");
                    if (i < query.length - 1) {
                        sb.append(" or");
                    }
                    sb.append("\n");
                }
                sb.append(")\n");
            }
        } else if (query.length == 1) {
            sb.append("lower(" + column + ") like ?\n");
            values.add("%" + query[0].toLowerCase() + "%");
        } else {
            sb.append("(\n");
            for (int i = 0; i < query.length; ++i) {
                sb.append(indent);
                sb.append("  ");
                sb.append("lower(" + column + ") like ?");
                values.add("%" + query[i].toLowerCase() + "%");
                if (i < query.length - 1) {
                    sb.append(" or");
                }
                sb.append("\n");
            }
            sb.append(")\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = PostgreSqlHelper.toSql("name", "  ", StringMatchMode.CONTAINS_CASE_INSENSITIVE, values, "foo", "bar", "fub");
        System.out.println(sql);
        System.out.println();
        sql = PostgreSqlHelper.toSql("name", "  ", StringMatchMode.CONTAINS_CASE_INSENSITIVE, values, "foo");
        System.out.println(sql);
        System.out.println();
        sql = PostgreSqlHelper.toSql("name", "  ", StringMatchMode.CONTAINS_CASE_SENSITIVE, values, "foo", "bar", "fub");
        System.out.println(sql);
        System.out.println();
        sql = PostgreSqlHelper.toSql("name", "  ", StringMatchMode.CONTAINS_CASE_SENSITIVE, values, "foo");
        System.out.println(sql);
        System.out.println();
        sql = PostgreSqlHelper.toSql("name", "  ", StringMatchMode.EQUALS_CASE_INSENSITIVE, values, "foo", "bar", "fub");
        System.out.println(sql);
        System.out.println();
        sql = PostgreSqlHelper.toSql("name", "  ", StringMatchMode.EQUALS_CASE_INSENSITIVE, values, "foo");
        System.out.println(sql);
        System.out.println();
        sql = PostgreSqlHelper.toSql("name", "  ", StringMatchMode.EQUALS_CASE_SENSITIVE, values, "foo", "bar", "fub");
        System.out.println(sql);
        System.out.println();
        sql = PostgreSqlHelper.toSql("name", "  ", StringMatchMode.EQUALS_CASE_SENSITIVE, values, "foo");
        System.out.println(sql);
        System.out.println();
    }
}

