/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import java.io.File;
import java.text.MessageFormat;
import li.strolch.agent.api.RealmHandler;
import li.strolch.agent.api.StrolchAgent;
import li.strolch.agent.impl.StoreToDaoElementListener;
import li.strolch.db.DbMigrationState;
import li.strolch.model.ModelStatistics;
import li.strolch.model.xml.StrolchElementListener;
import li.strolch.model.xml.XmlModelSaxFileReader;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.persistence.postgresql.PostgreSqlPersistenceHandler;
import li.strolch.privilege.handler.SystemAction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.StrolchConstants;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.configuration.RuntimeConfiguration;
import li.strolch.runtime.configuration.StrolchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PostgreSqlInitializer
extends SystemAction {
    protected static final Logger logger = LoggerFactory.getLogger(PostgreSqlInitializer.class);
    protected StrolchAgent agent;
    protected PostgreSqlPersistenceHandler persistenceHandler;
    protected RuntimeConfiguration runtimeConfig;
    protected ComponentConfiguration realmConfig;

    public PostgreSqlInitializer(StrolchAgent agent, PostgreSqlPersistenceHandler persistenceHandler) {
        this.agent = agent;
        this.persistenceHandler = persistenceHandler;
        StrolchConfiguration strolchConfiguration = agent.getStrolchConfiguration();
        this.runtimeConfig = strolchConfiguration.getRuntimeConfiguration();
        this.realmConfig = strolchConfiguration.getComponentConfiguration(RealmHandler.class.getSimpleName());
    }

    protected abstract Certificate getCertificate();

    protected void initSchemaFromDataStore(DbMigrationState migrationType, String realmName) {
        ModelStatistics statistics;
        boolean needsDbInit = this.checkNeedsDbInit(migrationType);
        if (!needsDbInit) {
            String msg = "Schema for realm {0} had no migration run. No need for data initialization.";
            logger.info(MessageFormat.format(msg, realmName));
            return;
        }
        String msg = "Migration for schema for realm {0} was {1} so need to initialize the data from the databaseStore...";
        logger.info(MessageFormat.format(msg, realmName, migrationType));
        try (StrolchTransaction tx = this.persistenceHandler.openTx(this.agent.getContainer().getRealm(realmName), this.getCertificate(), ((Object)((Object)this)).getClass().getSimpleName(), false);){
            File dataStoreF = this.getDataStoreFile(this.runtimeConfig, this.realmConfig, realmName);
            StoreToDaoElementListener listener = new StoreToDaoElementListener(tx);
            XmlModelSaxFileReader handler = new XmlModelSaxFileReader((StrolchElementListener)listener, dataStoreF, true);
            handler.parseFile();
            statistics = handler.getStatistics();
            tx.commitOnClose();
        }
        logger.info(MessageFormat.format("Realm {0} initialization statistics: {1}", realmName, statistics));
    }

    protected boolean checkNeedsDbInit(DbMigrationState migrationType) {
        return switch (migrationType) {
            case DbMigrationState.CREATED, DbMigrationState.DROPPED_CREATED -> true;
            default -> false;
        };
    }

    protected File getDataStoreFile(RuntimeConfiguration runtimeConfiguration, ComponentConfiguration realmConfiguration, String realmName) {
        String dataStoreKey = StrolchConstants.makeRealmKey((String)realmName, (String)"dataStoreFile");
        return realmConfiguration.getDataFile(dataStoreKey, null, runtimeConfiguration, true);
    }
}

