/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import li.strolch.model.Locator;
import li.strolch.model.log.LogMessage;
import li.strolch.model.log.LogMessageState;
import li.strolch.model.log.LogSeverity;
import li.strolch.persistence.api.LogMessageDao;
import li.strolch.persistence.api.StrolchPersistenceException;
import li.strolch.persistence.postgresql.PostgreSqlStrolchTransaction;
import li.strolch.utils.helper.StringHelper;

public class PostgreSqlLogMessageDao
implements LogMessageDao {
    private static final String ID = "id";
    private static final String REALM = "realm";
    private static final String DATE_TIME = "dateTime";
    private static final String USERNAME = "username";
    private static final String SEVERITY = "severity";
    private static final String LOCATOR = "locator";
    private static final String BUNDLE = "bundle";
    private static final String KEY = "key";
    private static final String MESSAGE = "message";
    private static final String STACK_TRACE = "stacktrace";
    private static final String STATE = "state";
    private static final String FIELDS = StringHelper.commaSeparated((String[])new String[]{"id", "realm", "dateTime", "username", "severity", "state", "locator", "bundle", "key", "message", "stacktrace"});
    private static final String queryByRealmMaxSql = "select " + FIELDS + " from operations_log where realm = ? order by id desc limit ?";
    private static final String queryValuesSql = "select key, value from operations_log_values where id = ?";
    private static final String insertLogMessageSql = "insert into operations_log (" + FIELDS + ") values (?, ?, ?, ?, ?::log_severity_type, ?::log_state_type, ?, ?, ?, ?, ?)";
    private static final String insertValuesSql = "insert into operations_log_values (id, key, value) values (?, ?, ?)";
    private static final String updateLogMessageStateSql = "update operations_log set state = ?::log_state_type where id = ?";
    private static final String removeSql = "delete from operations_log where id = ?";
    private static final String removeValuesSql = "delete from operations_log_values where id = ?";
    private final PostgreSqlStrolchTransaction tx;

    public PostgreSqlLogMessageDao(PostgreSqlStrolchTransaction postgreSqlStrolchTransaction) {
        this.tx = postgreSqlStrolchTransaction;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public List<LogMessage> queryLatest(String realm, int maxNr) {
        try {
            queryMsgStatement = this.tx.getConnection().prepareStatement(PostgreSqlLogMessageDao.queryByRealmMaxSql);
            try {
                block27: {
                    queryValuesStatement = this.tx.getConnection().prepareStatement("select key, value from operations_log_values where id = ?");
                    try {
                        queryMsgStatement.setString(1, realm);
                        queryMsgStatement.setInt(2, maxNr);
                        messages = new ArrayList<LogMessage>();
                        result = queryMsgStatement.executeQuery();
lbl10:
                        // 2 sources

                        try {
                            while (result.next()) {
                                id = result.getString(1);
                                queryValuesStatement.setString(1, id);
                                valuesResult = queryValuesStatement.executeQuery();
                                try {
                                    messages.add(this.logMessageFrom(result, valuesResult));
                                }
                                finally {
                                    if (valuesResult == null) ** GOTO lbl10
                                    valuesResult.close();
                                }
                            }
                        }
                        finally {
                            if (result != null) {
                                result.close();
                            }
                        }
                        var6_10 = messages;
                        if (queryValuesStatement == null) break block27;
                    }
                    catch (Throwable var5_8) {
                        if (queryValuesStatement != null) {
                            try {
                                queryValuesStatement.close();
                            }
                            catch (Throwable var6_11) {
                                var5_8.addSuppressed(var6_11);
                            }
                        }
                        throw var5_8;
                    }
                    queryValuesStatement.close();
                }
                return var6_10;
            }
            finally {
                if (queryMsgStatement != null) {
                    queryMsgStatement.close();
                }
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public void save(LogMessage logMessage) {
        try (PreparedStatement insertStatement = this.tx.getConnection().prepareStatement(insertLogMessageSql);
             PreparedStatement valuesStatement = this.tx.getConnection().prepareStatement(insertValuesSql);){
            this.setLogMessageFields(logMessage, insertStatement);
            int count = insertStatement.executeUpdate();
            if (count != 1) {
                throw new StrolchPersistenceException(MessageFormat.format("Expected to insert 1 log_message record, but inserted {0} for LogMessage {1}", count, logMessage.getId()));
            }
            int nrOfInserts = this.setValues(logMessage, valuesStatement);
            int[] ints = valuesStatement.executeBatch();
            this.validateValuesStatement(logMessage, nrOfInserts, ints);
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to insert LogMessage {0} due to {1}", logMessage.getId(), e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void saveAll(List<LogMessage> logMessages) {
        logMessages.forEach(this::save);
    }

    public void updateState(LogMessage logMessage) {
        try (PreparedStatement ps = this.tx.getConnection().prepareStatement(updateLogMessageStateSql);){
            ps.setString(1, logMessage.getState().name());
            ps.setString(2, logMessage.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to update LogMessage state {0} due to {1}", logMessage.getId(), e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void updateStates(Collection<LogMessage> logMessages) {
        try (PreparedStatement ps = this.tx.getConnection().prepareStatement(updateLogMessageStateSql);){
            for (LogMessage logMessage : logMessages) {
                ps.setString(1, logMessage.getState().name());
                ps.setString(2, logMessage.getId());
                ps.addBatch();
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to update states for {0} LogMessages due to {1}", logMessages.size(), e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void remove(LogMessage logMessage) {
        try (PreparedStatement removeStatement = this.tx.getConnection().prepareStatement(removeSql);
             PreparedStatement removeValuesStatement = this.tx.getConnection().prepareStatement(removeValuesSql);){
            this.remove(removeStatement, removeValuesStatement, logMessage);
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to remove {0} due to {1}", logMessage.getId(), e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void removeAll(List<LogMessage> logMessages) {
        try (PreparedStatement removeStatement = this.tx.getConnection().prepareStatement(removeSql);
             PreparedStatement removeValuesStatement = this.tx.getConnection().prepareStatement(removeValuesSql);){
            Object msg;
            int nrOfRemoves = 0;
            int[] nrOfValueRemoves = new int[logMessages.size()];
            for (LogMessage logMessage : logMessages) {
                removeStatement.setString(1, logMessage.getId());
                removeValuesStatement.setString(1, logMessage.getId());
                removeStatement.addBatch();
                removeValuesStatement.addBatch();
                nrOfValueRemoves[nrOfRemoves] = logMessage.getValues().size();
                ++nrOfRemoves;
            }
            int[] countAll = removeStatement.executeBatch();
            if (countAll.length != nrOfRemoves) {
                msg = "Expected to delete {0} LogMessages but deleted {1} elements!";
                msg = MessageFormat.format((String)msg, nrOfRemoves, countAll.length);
                throw new StrolchPersistenceException((String)msg);
            }
            for (Object count : (Object)countAll) {
                if (count == true) continue;
                String msg2 = "Expected to delete 1 LogMessages per delete statement but deleted {0} elements!";
                msg2 = MessageFormat.format(msg2, nrOfRemoves, (int)count);
                throw new StrolchPersistenceException(msg2);
            }
            countAll = removeValuesStatement.executeBatch();
            if (countAll.length != nrOfRemoves) {
                msg = "Expected to execute {0} delete value statements but executed {1} elements!";
                msg = MessageFormat.format((String)msg, nrOfRemoves, countAll.length);
                throw new StrolchPersistenceException((String)msg);
            }
            for (int i = 0; i < countAll.length; ++i) {
                if (countAll[i] == nrOfValueRemoves[i]) continue;
                String msg3 = "Expected to delete {0} values for LogMessage {1} but deleted {2} elements!";
                msg3 = MessageFormat.format(msg3, nrOfValueRemoves[i], logMessages.get(i).getId(), countAll[i]);
                throw new StrolchPersistenceException(msg3);
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to remove LogMessages due to {0}", e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private void remove(PreparedStatement removeStatement, PreparedStatement removeValuesStatement, LogMessage logMessage) throws SQLException {
        removeStatement.setString(1, logMessage.getId());
        removeValuesStatement.setString(1, logMessage.getId());
        int count = removeStatement.executeUpdate();
        if (count != 1) {
            String msg = "Expected to delete 1 LogMessage with id {0} but deleted {1} elements!";
            msg = MessageFormat.format(msg, logMessage.getId(), count);
            throw new StrolchPersistenceException(msg);
        }
        count = removeValuesStatement.executeUpdate();
        if (count != logMessage.getValues().size()) {
            String msg = "Expected to delete {0} values for LogMessage with id {1} but deleted {2} elements!";
            msg = MessageFormat.format(msg, logMessage.getValues().size(), logMessage.getId(), count);
            throw new StrolchPersistenceException(msg);
        }
    }

    private void validateValuesStatement(LogMessage logMessage, int nrOfInserts, int[] ints) {
        if (ints.length != nrOfInserts) {
            throw new StrolchPersistenceException(MessageFormat.format("Expected to insert {0} value record, but inserted {1} for LogMessage {2}", nrOfInserts, ints.length, logMessage.getId()));
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] == 1) continue;
            throw new StrolchPersistenceException(MessageFormat.format("Expected to insert 1 record per value, but inserted {0} for value at index {1} for LogMessage {2}", ints[i], i, logMessage.getId()));
        }
    }

    private int setValues(LogMessage logMessage, PreparedStatement valuesStatement) throws SQLException {
        Properties values = logMessage.getValues();
        int nrOfInserts = 0;
        Set<String> keys = values.stringPropertyNames();
        for (String key : keys) {
            valuesStatement.setString(1, logMessage.getId());
            valuesStatement.setString(2, key);
            valuesStatement.setString(3, values.getProperty(key));
            valuesStatement.addBatch();
            ++nrOfInserts;
        }
        return nrOfInserts;
    }

    private void setLogMessageFields(LogMessage logMessage, PreparedStatement ps) throws SQLException {
        ps.setString(1, logMessage.getId());
        ps.setString(2, logMessage.getRealm());
        ps.setTimestamp(3, new Timestamp(logMessage.getZonedDateTime().toInstant().toEpochMilli()), Calendar.getInstance());
        ps.setString(4, logMessage.getUsername());
        ps.setString(5, logMessage.getSeverity().name());
        ps.setString(6, logMessage.getState().name());
        ps.setString(7, logMessage.getLocator().toString());
        ps.setString(8, logMessage.getBundle());
        ps.setString(9, logMessage.getKey());
        ps.setString(10, logMessage.getMessage());
        ps.setString(11, logMessage.getStackTrace());
    }

    private LogMessage logMessageFrom(ResultSet resultSet, ResultSet valuesResult) throws SQLException {
        String id = resultSet.getString(1);
        String realm = resultSet.getString(2);
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(resultSet.getTimestamp(3).toInstant(), ZoneId.systemDefault());
        String username = resultSet.getString(4);
        LogSeverity severity = LogSeverity.valueOf((String)resultSet.getString(5));
        LogMessageState state = LogMessageState.valueOf((String)resultSet.getString(6));
        Locator locator = Locator.valueOf((String)resultSet.getString(7));
        String bundle = resultSet.getString(8);
        String key = resultSet.getString(9);
        String message = resultSet.getString(10);
        String exception = resultSet.getString(11);
        Properties properties = new Properties();
        while (valuesResult.next()) {
            String valueK = valuesResult.getString(1);
            String valueV = valuesResult.getString(2);
            properties.setProperty(valueK, valueV);
        }
        return new LogMessage(id, dateTime, realm, username, locator, severity, state, bundle, key, properties, message, exception);
    }
}

