/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import li.strolch.model.Order;
import li.strolch.model.json.OrderFromJsonVisitor;
import li.strolch.model.xml.SimpleStrolchElementListener;
import li.strolch.model.xml.StrolchElementListener;
import li.strolch.model.xml.XmlModelSaxReader;
import li.strolch.persistence.api.OrderDao;
import li.strolch.persistence.api.StrolchPersistenceException;
import li.strolch.persistence.api.TransactionResult;
import li.strolch.persistence.postgresql.DataType;
import li.strolch.persistence.postgresql.PostgresqlDao;
import li.strolch.utils.collections.DateRange;
import li.strolch.utils.iso8601.ISO8601;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PostgreSqlOrderDao
extends PostgresqlDao<Order>
implements OrderDao {
    public static final String ORDERS = "orders";
    private static final String querySizeDrSqlS = "select count(*) from {0} where latest = true {1}";
    private static final String querySizeOfTypeDrSqlS = "select count(*) from {0} where type = ANY(?) and latest = true {1}";
    private static final String queryAllDrAsXmlSqlS = "select id, type, asxml from {0} where latest = true {1}";
    private static final String queryAllDrAsXmlLimitSqlS = "select id, type, asxml from {0} where latest = true {1} order by date {2} limit {3} offset {4}";
    private static final String queryAllDrAsJsonSqlS = "select id, type, asjson from {0} where latest = true {1}";
    private static final String queryAllDrAsJsonLimitSqlS = "select id, type, asjson from {0} where latest = true {1} order by date {2} limit {3} offset {4}";
    private static final String queryAllByTypeDrAsXmlSqlS = "select id, type, asxml from {0} where type = ANY(?) and latest = true {1}";
    private static final String queryAllByTypeDrAsXmlLimitSqlS = "select id, type, asxml from {0} where type = ANY(?) and latest = true {1} order by date {2} limit {3,number,#} offset {4,number,#}";
    private static final String queryAllByTypeDrAsJsonSqlS = "select id, type, asjson from {0} where type = ANY(?) and latest = true {1}";
    private static final String queryAllByTypeDrAsJsonLimitSqlS = "select id, type, asjson from {0} where type = ANY(?) and latest = true {1} order by date {2} limit {3,number,#} offset {4,number,#}";
    private static final String insertAsXmlSqlS = "insert into {0} (id, version, created_by, created_at, updated_at, deleted, latest, name, type, state, date, asxml) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?::order_state, ?, ?)";
    private static final String insertAsJsonSqlS = "insert into {0} (id, version, created_by, created_at, updated_at, deleted, latest, name, type, state, date, asjson) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?::order_state, ?, ?)";
    private static final String updateAsXmlSqlS = "update {0} set created_by = ?, created_at = ?, updated_at = ?, deleted = ?, latest = ?, name = ?, type = ?, state = ?::order_state, date = ?, asxml = ? where id = ? and version = ?";
    private static final String updateAsJsonSqlS = "update {0} set created_by = ?, created_at = ?, updated_at = ?, deleted = ?, latest = ?, name = ?, type = ?, state = ?::order_state, date = ?, asjson = ? where id = ? and version = ?";
    private static final String updateLatestSqlS = "update {0} SET latest = false WHERE id = ? AND version = ?";

    public PostgreSqlOrderDao(DataType dataType, Connection connection, TransactionResult txResult, boolean versioningEnabled) {
        super(dataType, connection, txResult, versioningEnabled);
    }

    @Override
    protected String getClassName() {
        return "Order";
    }

    @Override
    protected String getTableName() {
        return ORDERS;
    }

    @Override
    protected Order parseFromXml(String id, String type, SQLXML sqlxml) {
        SimpleStrolchElementListener listener = new SimpleStrolchElementListener();
        try (InputStream binaryStream = sqlxml.getBinaryStream();){
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(binaryStream, (DefaultHandler)new XmlModelSaxReader((StrolchElementListener)listener));
        }
        catch (IOException | SQLException | ParserConfigurationException | SAXException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to extract Order from sqlxml value for {0} / {1}", id, type), (Throwable)e);
        }
        if (listener.getOrders().size() == 0) {
            throw new StrolchPersistenceException(MessageFormat.format("No Orders parsed from sqlxml value for {0} / {1}", id, type));
        }
        if (listener.getOrders().size() > 1) {
            throw new StrolchPersistenceException(MessageFormat.format("Multiple Orders parsed from sqlxml value for {0} / {1}", id, type));
        }
        return (Order)listener.getOrders().get(0);
    }

    @Override
    protected Order parseFromJson(String id, String type, String json) {
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        return new OrderFromJsonVisitor().visit(jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalSave(Order order) {
        PreparedStatement preparedStatement;
        String sql = this.getSql(insertAsXmlSqlS, insertAsJsonSqlS);
        try {
            preparedStatement = this.connection.prepareStatement(sql);
            try {
                preparedStatement.setString(1, order.getId());
                preparedStatement.setInt(2, order.getVersion().getVersion());
                preparedStatement.setString(3, order.getVersion().getCreatedBy());
                preparedStatement.setTimestamp(4, new Timestamp(order.getVersion().getCreated().getTime()), Calendar.getInstance());
                preparedStatement.setTimestamp(5, new Timestamp(order.getVersion().getUpdated().getTime()), Calendar.getInstance());
                preparedStatement.setBoolean(6, order.getVersion().isDeleted());
                preparedStatement.setBoolean(7, !order.getVersion().isDeleted());
                preparedStatement.setString(8, order.getName());
                preparedStatement.setString(9, order.getType());
                preparedStatement.setString(10, order.getState().name());
                preparedStatement.setTimestamp(11, new Timestamp(order.getDate().getTime()), Calendar.getInstance());
                SQLXML sqlxml = this.writeObject(preparedStatement, order, 12);
                try {
                    int modCount = preparedStatement.executeUpdate();
                    if (modCount != 1) {
                        String msg = "Expected to save 1 element with id {0} but SQL statement modified {1} elements!";
                        msg = MessageFormat.format(msg, order.getId(), modCount);
                        throw new StrolchPersistenceException(msg);
                    }
                }
                finally {
                    if (sqlxml != null) {
                        sqlxml.free();
                    }
                }
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException | SAXException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to insert Order {0} due to {1}", order.getVersion(), e.getLocalizedMessage()), (Throwable)e);
        }
        if (order.getVersion().isFirstVersion()) {
            return;
        }
        sql = MessageFormat.format(updateLatestSqlS, this.getTableName());
        try {
            preparedStatement = this.connection.prepareStatement(sql);
            try {
                preparedStatement.setString(1, order.getId());
                preparedStatement.setInt(2, order.getVersion().getPreviousVersion());
                int modCount = preparedStatement.executeUpdate();
                if (modCount != 1) {
                    String msg = "Expected to update 1 previous element with id {0} and version {1} but SQL statement modified {2} elements!";
                    msg = MessageFormat.format(msg, order.getId(), order.getVersion().getPreviousVersion(), modCount);
                    throw new StrolchPersistenceException(msg);
                }
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to update previous version of Order {0} due to {1}", order.getVersion(), e.getLocalizedMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalUpdate(Order order) {
        if (this.versioningEnabled) {
            this.internalSave(order);
            return;
        }
        if (!order.getVersion().isFirstVersion()) {
            throw new StrolchPersistenceException(MessageFormat.format("Versioning is not enabled, so version must always be 0 to perform an update, but it is {0}", order.getVersion()));
        }
        if (order.getVersion().isDeleted()) {
            throw new StrolchPersistenceException(MessageFormat.format("Versioning is not enabled, so version can not be marked as deleted for {0}", order.getVersion()));
        }
        String sql = this.getSql(updateAsXmlSqlS, updateAsJsonSqlS);
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setString(1, order.getVersion().getCreatedBy());
            preparedStatement.setTimestamp(2, new Timestamp(order.getVersion().getCreated().getTime()), Calendar.getInstance());
            preparedStatement.setTimestamp(3, new Timestamp(order.getVersion().getUpdated().getTime()), Calendar.getInstance());
            preparedStatement.setBoolean(4, order.getVersion().isDeleted());
            preparedStatement.setBoolean(5, !order.getVersion().isDeleted());
            preparedStatement.setString(6, order.getName());
            preparedStatement.setString(7, order.getType());
            preparedStatement.setString(8, order.getState().name());
            preparedStatement.setTimestamp(9, new Timestamp(order.getDate().getTime()), Calendar.getInstance());
            SQLXML sqlxml = this.writeObject(preparedStatement, order, 10);
            preparedStatement.setString(11, order.getId());
            preparedStatement.setInt(12, order.getVersion().getVersion());
            try {
                int modCount = preparedStatement.executeUpdate();
                if (modCount != 1) {
                    String msg = "Expected to update 1 element with id {0} and version {1} but SQL statement modified {2} elements!";
                    msg = MessageFormat.format(msg, order.getId(), order.getVersion().getVersion(), modCount);
                    throw new StrolchPersistenceException(msg);
                }
            }
            finally {
                if (sqlxml != null) {
                    sqlxml.free();
                }
            }
        }
        catch (SQLException | SAXException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to update Order {0} due to {1}", order.getLocator(), e.getLocalizedMessage()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long querySize(DateRange dateRange) {
        String sql = MessageFormat.format(querySizeDrSqlS, this.getTableName(), this.buildDateRangeClaus(dateRange));
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            long l;
            block14: {
                ResultSet result = statement.executeQuery();
                try {
                    result.next();
                    l = result.getLong(1);
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query size due to: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long querySize(DateRange dateRange, String ... types) {
        if (types.length == 0) {
            return this.querySize();
        }
        String sql = MessageFormat.format(querySizeOfTypeDrSqlS, this.getTableName(), this.buildDateRangeClaus(dateRange));
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            long l;
            block15: {
                Array typesArray = statement.getConnection().createArrayOf("varchar", types);
                statement.setArray(1, typesArray);
                ResultSet result = statement.executeQuery();
                try {
                    result.next();
                    l = result.getLong(1);
                    if (result == null) break block15;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query size due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<Order> queryAll(DateRange dateRange) throws StrolchPersistenceException {
        return this.queryAll(dateRange, Integer.MAX_VALUE, 0L, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Order> queryAll(DateRange dateRange, long limit, long offset, boolean asc) throws StrolchPersistenceException {
        ArrayList<Order> list = new ArrayList<Order>();
        String sql = this.getLimitSql(dateRange, limit, offset, asc, queryAllDrAsXmlSqlS, queryAllDrAsJsonSqlS, queryAllDrAsXmlLimitSqlS, queryAllDrAsJsonLimitSqlS);
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            ArrayList<Order> arrayList;
            block15: {
                ResultSet result = statement.executeQuery();
                try {
                    while (result.next()) {
                        String id = result.getString("id");
                        String type = result.getString("type");
                        list.add((Order)this.parseDbObject(result, id, type));
                    }
                    arrayList = list;
                    if (result == null) break block15;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<Order> queryAll(DateRange dateRange, String ... types) throws StrolchPersistenceException {
        return this.queryAll(dateRange, Integer.MAX_VALUE, 0L, true, types);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Order> queryAll(DateRange dateRange, long limit, long offset, boolean asc, String ... types) throws StrolchPersistenceException {
        if (types.length == 0) {
            return this.queryAll(limit, offset);
        }
        ArrayList<Order> list = new ArrayList<Order>();
        String sql = this.getLimitSql(dateRange, limit, offset, asc, queryAllByTypeDrAsXmlSqlS, queryAllByTypeDrAsJsonSqlS, queryAllByTypeDrAsXmlLimitSqlS, queryAllByTypeDrAsJsonLimitSqlS);
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            ArrayList<Order> arrayList;
            block16: {
                Array typesArray = statement.getConnection().createArrayOf("varchar", types);
                statement.setArray(1, typesArray);
                ResultSet result = statement.executeQuery();
                try {
                    while (result.next()) {
                        String id = result.getString("id");
                        String type = result.getString("type");
                        list.add((Order)this.parseDbObject(result, id, type));
                    }
                    arrayList = list;
                    if (result == null) break block16;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String getLimitSql(DateRange dateRange, long limit, long offset, boolean asc, String xmlSql, String jsonSql, String xmlLimitSql, String jsonLimitSql) {
        String sql;
        if (limit == Integer.MAX_VALUE) {
            return this.getSql(dateRange, xmlSql, jsonSql);
        }
        if (this.dataType == DataType.xml) {
            sql = xmlLimitSql;
        } else if (this.dataType == DataType.json) {
            sql = jsonLimitSql;
        } else {
            throw new IllegalStateException("Unhandled DataType " + this.dataType);
        }
        String dateRangeClause = this.buildDateRangeClaus(dateRange);
        return MessageFormat.format(sql, this.getTableName(), dateRangeClause, asc ? "ASC" : "DESC", limit, offset);
    }

    protected String getSql(DateRange dateRange, String xmlSql, String jsonSql) {
        String sql;
        if (this.dataType == DataType.xml) {
            sql = xmlSql;
        } else if (this.dataType == DataType.json) {
            sql = jsonSql;
        } else {
            throw new IllegalStateException("Unhandled DataType " + this.dataType);
        }
        String dateRangeClause = this.buildDateRangeClaus(dateRange);
        return MessageFormat.format(sql, this.getTableName(), dateRangeClause);
    }

    private String buildDateRangeClaus(DateRange dateRange) {
        if (dateRange.isFromBounded() && dateRange.isToBounded()) {
            String from = ISO8601.toString((Date)dateRange.getFromDate());
            String to = ISO8601.toString((Date)dateRange.getToDate());
            if (dateRange.isFromInclusive() && dateRange.isToInclusive()) {
                return "and date >= '" + from + "' and date <= '" + to + "'";
            }
            if (dateRange.isFromInclusive()) {
                return "and date >= '" + from + "' and date < '" + to + "'";
            }
            if (dateRange.isToInclusive()) {
                return "and date > '" + from + "' and date <= '" + to + "'";
            }
            return "and date > '" + from + "' and date < '" + to + "'";
        }
        if (dateRange.isFromBounded()) {
            String from = ISO8601.toString((Date)dateRange.getFromDate());
            if (dateRange.isFromInclusive()) {
                return "and date >= '" + from + "'";
            }
            return "and date > '" + from + "'";
        }
        if (dateRange.isToBounded()) {
            String to = ISO8601.toString((Date)dateRange.getToDate());
            if (dateRange.isToInclusive()) {
                return "and date <= '" + to + "'";
            }
            return "and date < '" + to + "'";
        }
        return "";
    }
}

