/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Map;
import javax.sql.DataSource;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchAgent;
import li.strolch.agent.api.StrolchComponent;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.db.DbSchemaVersionCheck;
import li.strolch.persistence.api.ActivityDao;
import li.strolch.persistence.api.AuditDao;
import li.strolch.persistence.api.LogMessageDao;
import li.strolch.persistence.api.OrderDao;
import li.strolch.persistence.api.PersistenceHandler;
import li.strolch.persistence.api.ResourceDao;
import li.strolch.persistence.api.StrolchPersistenceException;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.persistence.postgresql.DataType;
import li.strolch.persistence.postgresql.PostgreSqlDbConnectionBuilder;
import li.strolch.persistence.postgresql.PostgreSqlSchemaInitializer;
import li.strolch.persistence.postgresql.PostgreSqlStrolchTransaction;
import li.strolch.privilege.handler.SystemAction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.privilege.PrivilegeHandler;
import org.postgresql.Driver;

public class PostgreSqlPersistenceHandler
extends StrolchComponent
implements PersistenceHandler {
    public static final String SCRIPT_PREFIX_STROLCH = "strolch";
    public static final String SCRIPT_PREFIX_ARCHIVE = "archive";
    public static final String PROP_DATA_TYPE = "dataType";
    public static final String DATA_TYPE_XML = "xml";
    public static final String DATA_TYPE_JSON = "json";
    private Map<String, DataSource> dsMap;
    private DataType dataType;

    public PostgreSqlPersistenceHandler(ComponentContainer container, String componentName) {
        super(container, componentName);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void initialize(ComponentConfiguration componentConfiguration) throws Exception {
        if (!Driver.isRegistered()) {
            Driver.register();
        }
        PostgreSqlDbConnectionBuilder connectionBuilder = new PostgreSqlDbConnectionBuilder(this.getContainer(), componentConfiguration);
        this.dsMap = connectionBuilder.build();
        this.dataType = DataType.valueOf(componentConfiguration.getString(PROP_DATA_TYPE, DATA_TYPE_XML).toLowerCase());
        super.initialize(componentConfiguration);
    }

    public ComponentConfiguration getConfiguration() {
        return super.getConfiguration();
    }

    public Map<String, DataSource> getDataSources() {
        return this.dsMap;
    }

    public void start() throws Exception {
        ComponentConfiguration configuration = this.getConfiguration();
        boolean allowSchemaCreation = configuration.getBoolean("allowSchemaCreation", Boolean.FALSE);
        boolean allowSchemaMigration = configuration.getBoolean("allowSchemaMigration", Boolean.FALSE);
        boolean allowSchemaDrop = configuration.getBoolean("allowSchemaDrop", Boolean.FALSE);
        boolean allowDataInitOnSchemaCreate = configuration.getBoolean("allowDataInitOnSchemaCreate", Boolean.FALSE);
        DbSchemaVersionCheck schemaVersionCheck = new DbSchemaVersionCheck(SCRIPT_PREFIX_STROLCH, ((Object)((Object)this)).getClass(), allowSchemaCreation, allowSchemaMigration, allowSchemaDrop);
        schemaVersionCheck.checkSchemaVersion(this.dsMap);
        if (!allowDataInitOnSchemaCreate) {
            logger.info("Data Initialization not enabled as 'allowDataInitOnSchemaCreate' is false!");
        } else {
            Map dbMigrationStates = schemaVersionCheck.getDbMigrationStates();
            String msg = "Data Initialization is enabled, checking for {0} realms if DB initialization is required...";
            logger.info(MessageFormat.format(msg, dbMigrationStates.size()));
            PrivilegeHandler privilegeHandler = this.getContainer().getPrivilegeHandler();
            StrolchAgent agent = this.getContainer().getAgent();
            PostgreSqlSchemaInitializer schemaInitializer = new PostgreSqlSchemaInitializer(agent, this, dbMigrationStates);
            privilegeHandler.runAsAgent((SystemAction)schemaInitializer);
        }
        super.start();
    }

    public void destroy() throws Exception {
        if (this.dsMap != null) {
            for (Map.Entry<String, DataSource> entry : this.dsMap.entrySet()) {
                PostgreSqlDbConnectionBuilder.StrolchPostgreDataSource ds = (PostgreSqlDbConnectionBuilder.StrolchPostgreDataSource)entry.getValue();
                ds.shutdown();
            }
        }
        if (Driver.isRegistered()) {
            Driver.deregister();
        }
        super.destroy();
    }

    public StrolchTransaction openTx(StrolchRealm realm, Certificate certificate, String action, boolean readOnly) {
        return new PostgreSqlStrolchTransaction(this.getContainer(), realm, certificate, action, readOnly, this);
    }

    public Connection getConnection(String realm) {
        DataSource ds = this.dsMap.get(realm);
        if (ds == null) {
            String msg = MessageFormat.format("There is no DataSource registered for the realm {0}", realm);
            throw new StrolchPersistenceException(msg);
        }
        try {
            return ds.getConnection();
        }
        catch (Exception e) {
            String msg = "Failed to open a connection to {0} due to {1}";
            throw new StrolchPersistenceException(MessageFormat.format(msg, ds, e.getMessage()), (Throwable)e);
        }
    }

    public OrderDao getOrderDao(StrolchTransaction tx) {
        return ((PostgreSqlStrolchTransaction)tx).getOrderDao();
    }

    public ResourceDao getResourceDao(StrolchTransaction tx) {
        return ((PostgreSqlStrolchTransaction)tx).getResourceDao();
    }

    public ActivityDao getActivityDao(StrolchTransaction tx) {
        return ((PostgreSqlStrolchTransaction)tx).getActivityDao();
    }

    public AuditDao getAuditDao(StrolchTransaction tx) {
        return ((PostgreSqlStrolchTransaction)tx).getAuditDao();
    }

    public LogMessageDao getLogMessageDao(StrolchTransaction tx) {
        return ((PostgreSqlStrolchTransaction)tx).getLogMessageDao();
    }
}

