/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import java.util.Map;
import li.strolch.agent.api.StrolchAgent;
import li.strolch.db.DbMigrationState;
import li.strolch.persistence.postgresql.PostgreSqlInitializer;
import li.strolch.persistence.postgresql.PostgreSqlPersistenceHandler;
import li.strolch.privilege.model.Certificate;
import li.strolch.privilege.model.PrivilegeContext;

public class PostgreSqlSchemaInitializer
extends PostgreSqlInitializer {
    private Map<String, DbMigrationState> dbMigrationStates;
    private Certificate certificate;

    public PostgreSqlSchemaInitializer(StrolchAgent agent, PostgreSqlPersistenceHandler persistenceHandler, Map<String, DbMigrationState> dbMigrationStates) {
        super(agent, persistenceHandler);
        this.dbMigrationStates = dbMigrationStates;
    }

    public void execute(PrivilegeContext privilegeContext) {
        this.certificate = privilegeContext.getCertificate();
        for (Map.Entry<String, DbMigrationState> entry : this.dbMigrationStates.entrySet()) {
            if (!this.checkNeedsDbInit(entry.getValue())) continue;
            this.getDataStoreFile(this.runtimeConfig, this.realmConfig, entry.getKey());
        }
        for (Map.Entry<String, DbMigrationState> entry : this.dbMigrationStates.entrySet()) {
            this.initSchemaFromDataStore(entry.getValue(), entry.getKey());
        }
    }

    @Override
    protected Certificate getCertificate() {
        return this.certificate;
    }
}

