/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import java.sql.Connection;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.persistence.api.AbstractTransaction;
import li.strolch.persistence.api.ActivityDao;
import li.strolch.persistence.api.AuditDao;
import li.strolch.persistence.api.LogMessageDao;
import li.strolch.persistence.api.OrderDao;
import li.strolch.persistence.api.PersistenceHandler;
import li.strolch.persistence.api.ResourceDao;
import li.strolch.persistence.postgresql.PostgreSqlActivityDao;
import li.strolch.persistence.postgresql.PostgreSqlAuditDao;
import li.strolch.persistence.postgresql.PostgreSqlLogMessageDao;
import li.strolch.persistence.postgresql.PostgreSqlOrderDao;
import li.strolch.persistence.postgresql.PostgreSqlPersistenceHandler;
import li.strolch.persistence.postgresql.PostgreSqlResourceDao;
import li.strolch.privilege.model.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlStrolchTransaction
extends AbstractTransaction {
    private static final Logger logger = LoggerFactory.getLogger(PostgreSqlStrolchTransaction.class);
    private PostgreSqlPersistenceHandler persistenceHandler;
    private PostgreSqlOrderDao orderDao;
    private PostgreSqlResourceDao resourceDao;
    private PostgreSqlActivityDao activityDao;
    private PostgreSqlLogMessageDao logMessageDao;
    private AuditDao auditDao;
    private Connection connection;

    public PostgreSqlStrolchTransaction(ComponentContainer container, StrolchRealm realm, Certificate certificate, String action, boolean readOnly, PostgreSqlPersistenceHandler persistenceHandler) {
        super(container, realm, certificate, action, readOnly);
        this.persistenceHandler = persistenceHandler;
    }

    protected void writeChanges() throws Exception {
        if (this.orderDao != null) {
            this.orderDao.flush();
        }
        if (this.resourceDao != null) {
            this.resourceDao.flush();
        }
        if (this.activityDao != null) {
            this.activityDao.flush();
        }
    }

    protected void rollback() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.rollback();
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                    logger.error("Failed to close connection due to " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void commit() throws Exception {
        if (this.connection != null) {
            this.connection.commit();
            this.connection.close();
        }
    }

    OrderDao getOrderDao() {
        if (this.orderDao == null) {
            this.orderDao = new PostgreSqlOrderDao(this.persistenceHandler.getDataType(), this.getConnection(), this.getTxResult(), this.isVersioningEnabled());
        }
        return this.orderDao;
    }

    ResourceDao getResourceDao() {
        if (this.resourceDao == null) {
            this.resourceDao = new PostgreSqlResourceDao(this.persistenceHandler.getDataType(), this.getConnection(), this.getTxResult(), this.isVersioningEnabled());
        }
        return this.resourceDao;
    }

    ActivityDao getActivityDao() {
        if (this.activityDao == null) {
            this.activityDao = new PostgreSqlActivityDao(this.persistenceHandler.getDataType(), this.getConnection(), this.getTxResult(), this.isVersioningEnabled());
        }
        return this.activityDao;
    }

    AuditDao getAuditDao() {
        if (this.auditDao == null) {
            this.auditDao = new PostgreSqlAuditDao(this);
        }
        return this.auditDao;
    }

    LogMessageDao getLogMessageDao() {
        if (this.logMessageDao == null) {
            this.logMessageDao = new PostgreSqlLogMessageDao(this);
        }
        return this.logMessageDao;
    }

    Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.persistenceHandler.getConnection(this.getRealm().getRealm());
        }
        return this.connection;
    }

    public PersistenceHandler getPersistenceHandler() {
        return this.persistenceHandler;
    }
}

