/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.postgresql;

import com.google.gson.JsonObject;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.sax.SAXResult;
import li.strolch.model.StrolchRootElement;
import li.strolch.model.json.StrolchRootElementToJsonVisitor;
import li.strolch.model.visitor.StrolchElementVisitor;
import li.strolch.model.xml.StrolchElementToSaxVisitor;
import li.strolch.persistence.api.StrolchDao;
import li.strolch.persistence.api.StrolchPersistenceException;
import li.strolch.persistence.api.TransactionResult;
import li.strolch.persistence.postgresql.DaoCommand;
import li.strolch.persistence.postgresql.DataType;
import org.postgresql.util.PGobject;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class PostgresqlDao<T extends StrolchRootElement>
implements StrolchDao<T> {
    private static final String querySizeSqlS = "select count(*) from {0} where latest = true";
    private static final String querySizeOfTypeSqlS = "select count(*) from {0} where type = ANY(?) and latest = true";
    private static final String querySizeOfElementSqlS = "select count(*) from {0} where type = ? and id = ?";
    private static final String queryTypesSqlS = "select distinct type from {0} where latest = true";
    private static final String queryLatestVersionNumberForSqlS = "select count(*), max(version) from {0} where type = ? and id = ?";
    private static final String queryVersionsSizeForSqlS = "select count(*) from {0} where type = ? and id = ?";
    private static final String updateLatestSqlS = "update {0} set latest = true where type = ? and id = ? and version = ?";
    private static final String deleteElementSqlS = "delete from {0} where id = ?";
    private static final String deleteVersionSqlS = "delete from {0} where type = ? and id = ? and version = ? and latest = true";
    private static final String deleteAllSqlS = "delete from {0}";
    private static final String deleteAllByTypeSqlS = "delete from {0} where type = ?";
    private static final String queryByVersionAsXmlSqlS = "select version, asxml from {0} where type = ? and id = ? and version = ?";
    private static final String queryByVersionAsJsonSqlS = "select version, asjson from {0} where type = ? and id = ? and version = ?";
    private static final String queryVersionsAsXmlForSqlS = "select asxml from {0} where type = ? and id = ? order by version";
    private static final String queryVersionsAsJsonForSqlS = "select asjson from {0} where type = ? and id = ? order by version";
    private static final String queryAllAsXmlSqlS = "select id, type, asxml from {0} where latest = true";
    private static final String queryAllAsXmlLimitSqlS = "select id, type, asxml from {0} where latest = true order by id limit {1} offset {2}";
    private static final String queryAllAsJsonSqlS = "select id, type, asjson from {0} where latest = true";
    private static final String queryAllAsJsonLimitSqlS = "select id, type, asjson from {0} where latest = true order by id limit {1} offset {2}";
    private static final String queryAllByTypeAsXmlSqlS = "select id, type, asxml from {0} where type = ANY(?) and latest = true";
    private static final String queryAllByTypeAsXmlLimitSqlS = "select id, type, asxml from {0} where type = ANY(?) and latest = true order by id limit {1,number,#} offset {2,number,#}";
    private static final String queryAllByTypeAsJsonSqlS = "select id, type, asjson from {0} where type = ANY(?) and latest = true";
    private static final String queryAllByTypeAsJsonLimitSqlS = "select id, type, asjson from {0} where type = ANY(?) and latest = true order by id limit {1,number,#} offset {2,number,#}";
    protected final DataType dataType;
    protected Connection connection;
    protected final TransactionResult txResult;
    protected final boolean versioningEnabled;
    protected List<DaoCommand> commands;

    public PostgresqlDao(DataType dataType, Connection connection, TransactionResult txResult, boolean versioningEnabled) {
        this.dataType = dataType;
        this.connection = connection;
        this.txResult = txResult;
        this.versioningEnabled = versioningEnabled;
        this.commands = new ArrayList<DaoCommand>();
    }

    public boolean supportsPaging() {
        return true;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    protected abstract String getClassName();

    protected abstract String getTableName();

    protected abstract T parseFromXml(String var1, String var2, SQLXML var3);

    protected abstract T parseFromJson(String var1, String var2, String var3);

    protected SQLXML createSqlXml(T t) throws SQLException, SAXException {
        SQLXML sqlxml = this.connection.createSQLXML();
        SAXResult saxResult = sqlxml.setResult(SAXResult.class);
        ContentHandler contentHandler = saxResult.getHandler();
        contentHandler.startDocument();
        t.accept((StrolchElementVisitor)new StrolchElementToSaxVisitor(contentHandler));
        contentHandler.endDocument();
        return sqlxml;
    }

    protected SQLXML writeObject(PreparedStatement preparedStatement, T t, int index) throws SQLException, SAXException {
        SQLXML sqlxml = null;
        if (this.dataType == DataType.xml) {
            sqlxml = this.createSqlXml(t);
            preparedStatement.setSQLXML(index, sqlxml);
        } else {
            PGobject jsonObj = new PGobject();
            jsonObj.setType("json");
            jsonObj.setValue(((JsonObject)t.accept((StrolchElementVisitor)new StrolchRootElementToJsonVisitor())).toString());
            preparedStatement.setObject(index, jsonObj);
        }
        return sqlxml;
    }

    protected T parseDbObject(ResultSet result, String id, String type) throws SQLException {
        if (this.dataType == DataType.xml) {
            SQLXML sqlxml = result.getSQLXML("asxml");
            return this.parseFromXml(id, type, sqlxml);
        }
        if (this.dataType == DataType.json) {
            PGobject pGobject = (PGobject)result.getObject("asjson");
            String json = pGobject.getValue();
            return this.parseFromJson(id, type, json);
        }
        throw new IllegalStateException("Unhandled DataType " + this.dataType);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long querySize() {
        String sql = MessageFormat.format(querySizeSqlS, this.getTableName());
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            long l;
            block14: {
                ResultSet result = statement.executeQuery();
                try {
                    result.next();
                    l = result.getLong(1);
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query size due to: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long querySize(String ... types) {
        if (types.length == 0) {
            return this.querySize();
        }
        String sql = MessageFormat.format(querySizeOfTypeSqlS, this.getTableName());
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            long l;
            block15: {
                Array typesArray = statement.getConnection().createArrayOf("varchar", types);
                statement.setArray(1, typesArray);
                ResultSet result = statement.executeQuery();
                try {
                    result.next();
                    l = result.getLong(1);
                    if (result == null) break block15;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query size due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public Set<String> queryTypes() {
        String sql = MessageFormat.format(queryTypesSqlS, this.getTableName());
        HashSet<String> keySet = new HashSet<String>();
        try (PreparedStatement statement = this.connection.prepareStatement(sql);
             ResultSet result = statement.executeQuery();){
            while (result.next()) {
                keySet.add(result.getString("type"));
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
        return keySet;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public T queryBy(String type, String id, int versionNr) {
        String sql = this.getSql(queryByVersionAsXmlSqlS, queryByVersionAsJsonSqlS);
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            T t;
            block20: {
                ResultSet result;
                block18: {
                    T t2;
                    block19: {
                        statement.setString(1, type);
                        statement.setString(2, id);
                        statement.setInt(3, versionNr);
                        result = statement.executeQuery();
                        try {
                            if (result.next()) break block18;
                            t2 = null;
                            if (result == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return t2;
                }
                T t3 = this.parseDbObject(result, id, type);
                int v = result.getInt("version");
                if (v != versionNr) {
                    throw new StrolchPersistenceException("Requested version " + versionNr + " != " + v + " for " + t3.getLocator());
                }
                if (result.next()) {
                    throw new StrolchPersistenceException("Non unique result for query: " + sql);
                }
                t = t3;
                if (result == null) break block20;
                result.close();
            }
            return t;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<T> queryVersionsFor(String type, String id) {
        String sql = this.getSql(queryVersionsAsXmlForSqlS, queryVersionsAsJsonForSqlS);
        ArrayList<T> list = new ArrayList<T>(1);
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            ArrayList<T> arrayList;
            block15: {
                statement.setString(1, type);
                statement.setString(2, id);
                ResultSet result = statement.executeQuery();
                try {
                    while (result.next()) {
                        T t = this.parseDbObject(result, id, type);
                        list.add(t);
                    }
                    arrayList = list;
                    if (result == null) break block15;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int queryLatestVersionFor(String type, String id) {
        String sql = MessageFormat.format(queryLatestVersionNumberForSqlS, this.getTableName());
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            int n;
            block18: {
                int max;
                ResultSet result;
                block16: {
                    int n2;
                    block17: {
                        statement.setString(1, type);
                        statement.setString(2, id);
                        result = statement.executeQuery();
                        try {
                            result.next();
                            int count = result.getInt(1);
                            max = result.getInt(2);
                            if (count != 0) break block16;
                            n2 = -1;
                            if (result == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return n2;
                }
                n = max;
                if (result == null) break block18;
                result.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long queryVersionsSizeFor(String type, String id) {
        String sql = MessageFormat.format("select count(*) from {0} where type = ? and id = ?", this.getTableName());
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            long l;
            block14: {
                statement.setString(1, type);
                statement.setString(2, id);
                ResultSet result = statement.executeQuery();
                try {
                    result.next();
                    l = result.getLong(1);
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<T> queryAll() {
        return this.queryAll(Integer.MAX_VALUE, 0L);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<T> queryAll(long limit, long offset) {
        ArrayList<T> list = new ArrayList<T>();
        String sql = this.getLimitSql(limit, offset, queryAllAsXmlSqlS, queryAllAsJsonSqlS, queryAllAsXmlLimitSqlS, queryAllAsJsonLimitSqlS);
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            ArrayList<T> arrayList;
            block15: {
                ResultSet result = statement.executeQuery();
                try {
                    while (result.next()) {
                        String id = result.getString("id");
                        String type = result.getString("type");
                        list.add(this.parseDbObject(result, id, type));
                    }
                    arrayList = list;
                    if (result == null) break block15;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<T> queryAll(String ... types) {
        return this.queryAll(Integer.MAX_VALUE, 0L, types);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<T> queryAll(long limit, long offset, String ... types) {
        if (types.length == 0) {
            return this.queryAll(limit, offset);
        }
        ArrayList<T> list = new ArrayList<T>();
        String sql = this.getLimitSql(limit, offset, queryAllByTypeAsXmlSqlS, queryAllByTypeAsJsonSqlS, queryAllByTypeAsXmlLimitSqlS, queryAllByTypeAsJsonLimitSqlS);
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            ArrayList<T> arrayList;
            block16: {
                Array typesArray = statement.getConnection().createArrayOf("varchar", types);
                statement.setArray(1, typesArray);
                ResultSet result = statement.executeQuery();
                try {
                    while (result.next()) {
                        String id = result.getString("id");
                        String type = result.getString("type");
                        list.add(this.parseDbObject(result, id, type));
                    }
                    arrayList = list;
                    if (result == null) break block16;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to query types due to: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String getLimitSql(long limit, long offset, String xmlSql, String jsonSql, String xmlLimitSql, String jsonLimitSql) {
        String sql;
        if (limit == Integer.MAX_VALUE) {
            return this.getSql(xmlSql, jsonSql);
        }
        if (this.dataType == DataType.xml) {
            sql = xmlLimitSql;
        } else if (this.dataType == DataType.json) {
            sql = jsonLimitSql;
        } else {
            throw new IllegalStateException("Unhandled DataType " + this.dataType);
        }
        return MessageFormat.format(sql, this.getTableName(), limit, offset);
    }

    protected String getSql(String xmlSql, String jsonSql) {
        String sql;
        if (this.dataType == DataType.xml) {
            sql = xmlSql;
        } else if (this.dataType == DataType.json) {
            sql = jsonSql;
        } else {
            throw new IllegalStateException("Unhandled DataType " + this.dataType);
        }
        return MessageFormat.format(sql, this.getTableName());
    }

    public void save(T res) {
        this.commands.add(txResult -> {
            this.internalSave(res);
            txResult.incCreated(1L);
        });
    }

    public void saveAll(List<T> elements) {
        this.commands.add(txResult -> {
            for (StrolchRootElement element : elements) {
                this.internalSave(element);
            }
            txResult.incCreated((long)elements.size());
        });
    }

    public void update(T element) {
        this.commands.add(txResult -> {
            this.internalUpdate(element);
            txResult.incUpdated(1L);
        });
    }

    public void updateAll(List<T> elements) {
        this.commands.add(txResult -> {
            for (StrolchRootElement element : elements) {
                this.internalUpdate(element);
            }
            txResult.incUpdated((long)elements.size());
        });
    }

    public void remove(T element) {
        this.commands.add(txResult -> {
            this.internalRemove(element);
            txResult.incDeleted(1L);
        });
    }

    public void removeAll(List<T> elements) {
        this.commands.add(txResult -> {
            for (StrolchRootElement element : elements) {
                this.internalRemove(element);
            }
            txResult.incDeleted((long)elements.size());
        });
    }

    public long removeAll() {
        long toRemove = this.querySize();
        this.commands.add(txResult -> {
            this.internalRemoveAll();
            txResult.incDeleted(toRemove);
        });
        return toRemove;
    }

    public long removeAllBy(String type) {
        long toRemove = this.querySize(type);
        this.commands.add(txResult -> {
            this.internalRemoveAllBy(type);
            txResult.incDeleted(toRemove);
        });
        return toRemove;
    }

    public void removeVersion(T element) throws StrolchPersistenceException {
        this.commands.add(txResult -> {
            this.internalRemoveVersion(element);
            txResult.incDeleted(1L);
        });
    }

    protected abstract void internalSave(T var1);

    protected abstract void internalUpdate(T var1);

    protected void internalRemove(T element) {
        long count = 0L;
        String sql = MessageFormat.format("select count(*) from {0} where type = ? and id = ?", this.getTableName());
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            statement.setString(1, element.getType());
            statement.setString(2, element.getId());
            try (ResultSet result = statement.executeQuery();){
                result.next();
                count = result.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to remove {0} due to {1}", element.getLocator(), e.getLocalizedMessage()), (Throwable)e);
        }
        if (count == 0L) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to remove {0} as it does not exist!", element.getLocator()));
        }
        sql = MessageFormat.format(deleteElementSqlS, this.getTableName());
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setString(1, element.getId());
            int modCount = preparedStatement.executeUpdate();
            if ((long)modCount != count) {
                String msg = "Expected to delete {0} element with id {1} but SQL statement deleted {2} elements!";
                msg = MessageFormat.format(msg, count, element.getId(), modCount);
                throw new StrolchPersistenceException(msg);
            }
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to remove {0} due to {1}", element.getLocator(), e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private void internalRemoveVersion(T element) {
        block16: {
            String sql = MessageFormat.format(deleteVersionSqlS, this.getTableName());
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
                preparedStatement.setString(1, element.getType());
                preparedStatement.setString(2, element.getId());
                preparedStatement.setInt(3, element.getVersion().getVersion());
                int modCount = preparedStatement.executeUpdate();
                if (modCount != 1) {
                    String msg = "Expected to delete 1 element with id {0} but SQL statement modified {1} elements! Verify that element {2} is the latest version!";
                    msg = MessageFormat.format(msg, element.getId(), modCount, element.getVersion());
                    throw new StrolchPersistenceException(msg);
                }
                if (element.getVersion().isFirstVersion()) break block16;
                sql = MessageFormat.format(updateLatestSqlS, this.getTableName());
                try (PreparedStatement updateStmt = this.connection.prepareStatement(sql);){
                    int previousVersion = element.getVersion().getPreviousVersion();
                    updateStmt.setString(1, element.getType());
                    updateStmt.setString(2, element.getId());
                    updateStmt.setInt(3, previousVersion);
                    modCount = updateStmt.executeUpdate();
                    if (modCount != 1) {
                        String msg = "Expected to update 1 element with id {0} but SQL statement modified {1} elements! Verify that element {2} with version {3} exists!";
                        msg = MessageFormat.format(msg, element.getId(), modCount, element.getLocator(), previousVersion);
                        throw new StrolchPersistenceException(msg);
                    }
                }
            }
            catch (SQLException e) {
                throw new StrolchPersistenceException(MessageFormat.format("Failed to remove version {0} due to {1}", element.getLocator(), e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    protected void internalRemoveAll() {
        String sql = MessageFormat.format(deleteAllSqlS, this.getTableName());
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to remove all elements due to {0}", e.getLocalizedMessage()), (Throwable)e);
        }
    }

    protected void internalRemoveAllBy(String type) {
        String sql = MessageFormat.format(deleteAllByTypeSqlS, this.getTableName());
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setString(1, type);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException(MessageFormat.format("Failed to remove all elements of type {0} due to {1}", type, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void flush() {
        for (DaoCommand command : this.commands) {
            command.doComand(this.txResult);
        }
        this.commands.clear();
    }
}

