/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.testbase.runtime;

import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.testbase.runtime.ActivityModelTestRunner;
import li.strolch.testbase.runtime.AuditModelTestRunner;
import li.strolch.testbase.runtime.LogMessagesTestRunner;
import li.strolch.testbase.runtime.OrderModelTestRunner;
import li.strolch.testbase.runtime.ResourceModelTestRunner;
import li.strolch.testbase.runtime.RuntimeMock;
import li.strolch.testbase.runtime.VersioningTestRunner;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelTest {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractModelTest.class);
    protected String realmName = "defaultRealm";

    protected abstract RuntimeMock getRuntimeMock();

    @Test
    public void shouldStartContainer() {
        PrivilegeHandler privilegeHandler = this.getRuntimeMock().getContainer().getPrivilegeHandler();
        Certificate certificate = privilegeHandler.authenticate("test", "test".toCharArray());
        try (StrolchTransaction tx = this.getRuntimeMock().getRealm(this.realmName).openTx(certificate, "test", true);){
            tx.getOrderMap().getAllKeys(tx);
        }
    }

    @Test
    public void shouldCreateQueryLogMessages() {
        LogMessagesTestRunner testRunner = new LogMessagesTestRunner(this.getRuntimeMock().getContainer(), this.realmName);
        testRunner.runLogMessagesTest();
    }

    @Test
    public void shouldCreateOrders() {
        OrderModelTestRunner testRunner = new OrderModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runCreateOrderTest();
    }

    @Test
    public void shouldQueryOrderSizes() {
        OrderModelTestRunner testRunner = new OrderModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runQuerySizeTest();
    }

    @Test
    public void shouldOrderCrud() {
        OrderModelTestRunner testRunner = new OrderModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runCrudTests();
    }

    @Test
    public void shouldOrderPerformBulkOperations() {
        OrderModelTestRunner testRunner = new OrderModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runBulkOperationTests();
    }

    @Test
    public void shouldCreateResources() {
        ResourceModelTestRunner testRunner = new ResourceModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runCreateResourceTest();
    }

    @Test
    public void shouldQueryResourceSizes() {
        ResourceModelTestRunner testRunner = new ResourceModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runQuerySizeTest();
    }

    @Test
    public void shouldResourceCrud() {
        ResourceModelTestRunner testRunner = new ResourceModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runCrudTests();
    }

    @Test
    public void shouldResourcePerformBulkOperations() {
        ResourceModelTestRunner testRunner = new ResourceModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runBulkOperationTests();
    }

    @Test
    public void shouldCreateActivities() {
        ActivityModelTestRunner testRunner = new ActivityModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runCreateActivityTest();
    }

    @Test
    public void shouldQueryActivitySizes() {
        ActivityModelTestRunner testRunner = new ActivityModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runQuerySizeTest();
    }

    @Test
    public void shouldActivityCrud() {
        ActivityModelTestRunner testRunner = new ActivityModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runCrudTests();
    }

    @Test
    public void shouldActivityPerformBulkOperations() {
        ActivityModelTestRunner testRunner = new ActivityModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runBulkOperationTests();
    }

    @Test
    public void shouldTestAudits() {
        AuditModelTestRunner testRunner = new AuditModelTestRunner(this.getRuntimeMock(), this.realmName);
        testRunner.runTestForAudits();
    }

    @Test
    public void shouldTestVersioning() {
        VersioningTestRunner testRunner = new VersioningTestRunner(this.getRuntimeMock());
        testRunner.runTestsForVersioning();
    }
}

