/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.testbase.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import li.strolch.agent.api.ActivityMap;
import li.strolch.agent.impl.DataStoreMode;
import li.strolch.model.AbstractStrolchElement;
import li.strolch.model.ModelGenerator;
import li.strolch.model.activity.Activity;
import li.strolch.model.activity.TimeOrdering;
import li.strolch.model.parameter.StringParameter;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.testbase.runtime.RuntimeMock;
import org.junit.Assert;

public class ActivityModelTestRunner {
    private static final String ID = "@testActivity";
    private static final String NAME = "Test Activity";
    private static final String TYPE = "Produce";
    private RuntimeMock runtimeMock;
    private String realmName;
    private Certificate certificate;

    public ActivityModelTestRunner(RuntimeMock runtimeMock, String realmName) {
        this.runtimeMock = runtimeMock;
        this.realmName = realmName;
        PrivilegeHandler privilegeHandler = runtimeMock.getContainer().getPrivilegeHandler();
        this.certificate = privilegeHandler.authenticate("test", "test".toCharArray());
    }

    public void runCreateActivityTest() {
        Activity newActivity = ModelGenerator.createActivity((String)"MyTestActivity", (String)"Test Name", (String)"TestType", (TimeOrdering)TimeOrdering.SERIES);
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.add(newActivity);
            tx.commitOnClose();
        }
    }

    public void runQuerySizeTest() {
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.getActivityMap().removeAll(tx, tx.getActivityMap().getAllElements(tx));
            tx.commitOnClose();
        }
        Activity activity1 = ModelGenerator.createActivity((String)"myTestActivity1", (String)"Test Name", (String)"QTestType1", (TimeOrdering)TimeOrdering.SERIES);
        Activity activity2 = ModelGenerator.createActivity((String)"myTestActivity2", (String)"Test Name", (String)"QTestType2", (TimeOrdering)TimeOrdering.SERIES);
        Activity activity3 = ModelGenerator.createActivity((String)"myTestActivity3", (String)"Test Name", (String)"QTestType3", (TimeOrdering)TimeOrdering.SERIES);
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.add(activity1);
            tx.add(activity2);
            tx.add(activity3);
            tx.commitOnClose();
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            long size = tx.getActivityMap().querySize(tx);
            Assert.assertEquals((String)"Should have three objects", (long)3L, (long)size);
            size = tx.getActivityMap().querySize(tx, "QTestType1");
            Assert.assertEquals((String)"Should have only one object of type 'QTestType1'", (long)1L, (long)size);
            size = tx.getActivityMap().querySize(tx, "QTestType2");
            Assert.assertEquals((String)"Should have only one object of type 'QTestType1'", (long)1L, (long)size);
            size = tx.getActivityMap().querySize(tx, "QTestType3");
            Assert.assertEquals((String)"Should have only one object of type 'QTestType1'", (long)1L, (long)size);
            size = tx.getActivityMap().querySize(tx, "NonExistingType");
            Assert.assertEquals((String)"Should have zero objects of type 'NonExistingType'", (long)0L, (long)size);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    public void runCrudTests() {
        Activity updatedActivity;
        Activity readActivity;
        Activity newActivity = ModelGenerator.createActivity((String)ID, (String)NAME, (String)TYPE, (TimeOrdering)TimeOrdering.SERIES);
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.add(newActivity);
            tx.commitOnClose();
        }
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            readActivity = tx.getActivityBy(TYPE, ID);
        }
        Assert.assertNotNull((String)"Should read Activity with id @testActivity", (Object)readActivity);
        StringParameter sParam = (StringParameter)readActivity.getParameter("@bag01", "@param5");
        String newStringValue = "Giddiya!";
        sParam.setValue(newStringValue);
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.update(readActivity);
            tx.commitOnClose();
        }
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            updatedActivity = tx.getActivityBy(TYPE, ID);
        }
        Assert.assertNotNull((String)"Should read Activity with id @testActivity", (Object)updatedActivity);
        if (this.runtimeMock.getRealm(this.realmName).getMode() != DataStoreMode.CACHED) {
            Assert.assertNotSame((String)"Objects can't be the same reference after re-reading!", (Object)readActivity, (Object)updatedActivity);
        }
        StringParameter updatedParam = (StringParameter)readActivity.getParameter("@bag01", "@param5");
        Assert.assertEquals((Object)newStringValue, (Object)updatedParam.getValue());
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.remove(readActivity);
            tx.commitOnClose();
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            Activity activity = tx.getActivityBy(TYPE, ID);
            Assert.assertNull((String)"Should not read Activity with id @testActivity", (Object)activity);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    public void runBulkOperationTests() {
        ActivityMap activityMap;
        ArrayList<Activity> activities = new ArrayList<Activity>();
        activities.addAll(ModelGenerator.createActivities((int)activities.size(), (int)5, (String)"@", (String)"My Activity", (String)"MyType1", (TimeOrdering)TimeOrdering.SERIES));
        activities.addAll(ModelGenerator.createActivities((int)activities.size(), (int)5, (String)"@", (String)"Other Activity", (String)"MyType2", (TimeOrdering)TimeOrdering.SERIES));
        activities.addAll(ModelGenerator.createActivities((int)activities.size(), (int)5, (String)"@", (String)"Further Activity", (String)"MyType3", (TimeOrdering)TimeOrdering.SERIES));
        Comparator<Activity> comparator = Comparator.comparing(AbstractStrolchElement::getId);
        activities.sort(comparator);
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            activityMap = tx.getActivityMap();
            List allElements = activityMap.getAllElements(tx);
            long removed = activityMap.removeAll(tx);
            Assert.assertEquals((long)allElements.size(), (long)removed);
            Assert.assertEquals((long)0L, (long)activityMap.querySize(tx));
            tx.commitOnClose();
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            activityMap = tx.getActivityMap();
            Assert.assertEquals((long)0L, (long)activityMap.querySize(tx));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            tx.getActivityMap().addAll(tx, activities);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            activityMap = tx.getActivityMap();
            Assert.assertEquals((long)activities.size(), (long)activityMap.querySize(tx));
            Assert.assertEquals((long)5L, (long)activityMap.querySize(tx, "MyType3"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            tx.getActivityMap().removeAllBy(tx, "MyType3");
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            activityMap = tx.getActivityMap();
            Assert.assertEquals((long)(activities.size() - 5), (long)activityMap.querySize(tx));
            Assert.assertEquals((long)0L, (long)activityMap.querySize(tx, "MyType3"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            long removed = tx.getActivityMap().removeAll(tx);
            Assert.assertEquals((long)(activities.size() - 5), (long)removed);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            ActivityMap activityMap2 = tx.getActivityMap();
            Assert.assertEquals((long)0L, (long)activityMap2.querySize(tx));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        activities.forEach(t -> t.setVersion(null));
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            tx.getActivityMap().addAll(tx, activities);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        HashSet<String> expectedTypes = new HashSet<String>();
        expectedTypes.add("MyType1");
        expectedTypes.add("MyType2");
        expectedTypes.add("MyType3");
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);){
            List allActivities = tx.getActivityMap().getAllElements(tx);
            allActivities.sort(comparator);
            Assert.assertEquals(activities, (Object)allActivities);
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            ActivityMap activityMap3 = tx.getActivityMap();
            Set types = activityMap3.getTypes(tx);
            Assert.assertEquals(expectedTypes, (Object)types);
            Set keySet = activityMap3.getAllKeys(tx);
            Assert.assertEquals((long)15L, (long)keySet.size());
            for (String type : types) {
                Set idsByType = activityMap3.getKeysBy(tx, type);
                Assert.assertEquals((long)5L, (long)idsByType.size());
                List activitiesByType = activityMap3.getElementsBy(tx, type);
                Assert.assertEquals((long)5L, (long)activitiesByType.size());
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            Activity activity = tx.getActivityBy("MyType1", "@00000001");
            Assert.assertNotNull((Object)activity);
            activity = tx.getActivityBy("MyType2", "@00000006");
            Assert.assertNotNull((Object)activity);
            activity = tx.getActivityBy("MyType3", "@00000011");
            Assert.assertNotNull((Object)activity);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

