/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.testbase.runtime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import li.strolch.agent.api.AuditTrail;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.model.ModelGenerator;
import li.strolch.model.audit.Audit;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.testbase.runtime.RuntimeMock;
import li.strolch.utils.collections.DateRange;
import org.junit.Assert;

public class AuditModelTestRunner {
    private RuntimeMock runtimeMock;
    private String realmName;
    private Certificate certificate;

    public AuditModelTestRunner(RuntimeMock runtimeMock, String realmName) {
        this.runtimeMock = runtimeMock;
        this.realmName = realmName;
        PrivilegeHandler privilegeHandler = runtimeMock.getContainer().getPrivilegeHandler();
        this.certificate = privilegeHandler.authenticate("test", "test".toCharArray());
    }

    public void runTestForAudits() {
        int i;
        List allElements;
        Audit randomAudit;
        Audit dbAudit;
        AuditTrail auditTrail;
        StrolchRealm realm = this.runtimeMock.getRealm(this.realmName);
        Calendar cal = Calendar.getInstance();
        cal.set(2000, 6, 1);
        Date beforeCurrent = cal.getTime();
        cal.set(2000, 6, 2);
        Date current = cal.getTime();
        cal.set(2000, 6, 3);
        Date afterCurrent = cal.getTime();
        cal.set(2000, 1, 1);
        Date earlier = cal.getTime();
        cal.set(2000, 11, 1);
        Date later = cal.getTime();
        DateRange earlierRange = new DateRange().from(earlier, true).to(beforeCurrent, true);
        DateRange equalsRange = new DateRange().from(current, true).to(current, true);
        DateRange laterRange = new DateRange().from(afterCurrent, true).to(later, true);
        DateRange containsRange = new DateRange().from(earlier, true).to(later, true);
        this.cleanup(realm);
        Audit audit = ModelGenerator.randomAudit();
        audit.setDate(current);
        try (StrolchTransaction tx = realm.openTx(this.certificate, "test", false);){
            auditTrail = tx.getAuditTrail();
            auditTrail.add(tx, audit);
            tx.commitOnClose();
        }
        tx = realm.openTx(this.certificate, "test", true);
        try {
            auditTrail = tx.getAuditTrail();
            Set types = auditTrail.getTypes(tx);
            Assert.assertEquals((long)1L, (long)types.size());
            Assert.assertTrue((boolean)types.contains(audit.getElementType()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", true);
        try {
            auditTrail = tx.getAuditTrail();
            Assert.assertTrue((boolean)auditTrail.hasAudit(tx, audit.getElementType(), audit.getId()));
            dbAudit = auditTrail.getBy(tx, audit.getElementType(), audit.getId());
            Assert.assertNotNull((Object)dbAudit);
            Assert.assertEquals((Object)audit, (Object)dbAudit);
            dbAudit = auditTrail.getBy(tx, "Foo", audit.getId());
            Assert.assertNull((Object)dbAudit);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", false);
        try {
            auditTrail = tx.getAuditTrail();
            auditTrail.remove(tx, audit);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", true);
        try {
            auditTrail = tx.getAuditTrail();
            dbAudit = auditTrail.getBy(tx, audit.getElementType(), audit.getId());
            Assert.assertNull((Object)dbAudit);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", false);
        try {
            auditTrail = tx.getAuditTrail();
            auditTrail.add(tx, audit);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", true);
        try {
            auditTrail = tx.getAuditTrail();
            dbAudit = auditTrail.getBy(tx, audit.getElementType(), audit.getId());
            dbAudit.setAction("Foo");
            auditTrail.update(tx, dbAudit);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", true);
        try {
            auditTrail = tx.getAuditTrail();
            dbAudit = auditTrail.getBy(tx, audit.getElementType(), audit.getId());
            Assert.assertEquals((Object)"Foo", (Object)dbAudit.getAction());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        audit = ModelGenerator.randomAudit();
        audit.setDate(current);
        tx = realm.openTx(this.certificate, "test", true);
        try {
            auditTrail = tx.getAuditTrail();
            Assert.assertEquals((long)1L, (long)auditTrail.querySize(tx, audit.getElementType(), equalsRange));
            Assert.assertEquals((long)1L, (long)auditTrail.querySize(tx, audit.getElementType(), containsRange));
            Assert.assertEquals((long)0L, (long)auditTrail.querySize(tx, audit.getElementType(), earlierRange));
            Assert.assertEquals((long)0L, (long)auditTrail.querySize(tx, audit.getElementType(), laterRange));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        ArrayList<Audit> audits = new ArrayList<Audit>();
        for (int i2 = 0; i2 < 100; ++i2) {
            randomAudit = ModelGenerator.randomAudit();
            randomAudit.setElementType("FooBar");
            randomAudit.setDate(current);
            audits.add(randomAudit);
        }
        audits.sort(new AuditByIdComparator());
        tx = realm.openTx(this.certificate, "test", false);
        try {
            auditTrail = tx.getAuditTrail();
            auditTrail.addAll(tx, audits);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", true);
        try {
            auditTrail = tx.getAuditTrail();
            Assert.assertEquals((long)100L, (long)auditTrail.querySize(tx, "FooBar", containsRange));
            allElements = auditTrail.getAllElements(tx, "FooBar", containsRange);
            allElements.sort(new AuditByIdComparator());
            Assert.assertEquals(audits, (Object)allElements);
            allElements = auditTrail.getAllElements(tx, "FooBar", earlierRange);
            Assert.assertEquals((long)0L, (long)allElements.size());
            allElements = auditTrail.getAllElements(tx, "FooBar", laterRange);
            Assert.assertEquals((long)0L, (long)allElements.size());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", false);
        try {
            auditTrail = tx.getAuditTrail();
            auditTrail.removeAll(tx, audits);
            Assert.assertEquals((long)0L, (long)auditTrail.querySize(tx, "FooBar", containsRange));
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", true);
        try {
            auditTrail = tx.getAuditTrail();
            Assert.assertEquals((long)0L, (long)auditTrail.querySize(tx, "FooBar", containsRange));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        audits = new ArrayList();
        for (int i3 = 0; i3 < 100; ++i3) {
            randomAudit = ModelGenerator.randomAudit();
            randomAudit.setElementType("Bar");
            randomAudit.setDate(current);
            randomAudit.setAction("BarFoo");
            audits.add(randomAudit);
        }
        audits.sort(new AuditByIdComparator());
        tx = realm.openTx(this.certificate, "test", false);
        try {
            auditTrail = tx.getAuditTrail();
            auditTrail.addAll(tx, audits);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", false);
        try {
            auditTrail = tx.getAuditTrail();
            allElements = auditTrail.getAllElements(tx, "Bar", containsRange);
            allElements.sort(new AuditByIdComparator());
            Assert.assertEquals(audits, (Object)allElements);
            for (Audit dbAudit2 : allElements) {
                Assert.assertEquals((Object)"BarFoo", (Object)dbAudit2.getAction());
            }
            for (Audit dbAudit2 : allElements) {
                dbAudit2.setAction("Foo");
            }
            auditTrail.updateAll(tx, allElements);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", false);
        try {
            auditTrail = tx.getAuditTrail();
            allElements = auditTrail.getAllElements(tx, "Bar", containsRange);
            for (Audit dbAudit2 : allElements) {
                Assert.assertEquals((Object)"Foo", (Object)dbAudit2.getAction());
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.cleanup(realm);
        audits = new ArrayList();
        for (i = 0; i < 5; ++i) {
            randomAudit = ModelGenerator.randomAudit();
            randomAudit.setDate(current);
            randomAudit.setElementType("BarBarBar");
            audits.add(randomAudit);
        }
        for (i = 0; i < 5; ++i) {
            randomAudit = ModelGenerator.randomAudit();
            randomAudit.setDate(current);
            randomAudit.setElementType("FooFooFoo");
            audits.add(randomAudit);
        }
        for (i = 0; i < 5; ++i) {
            randomAudit = ModelGenerator.randomAudit();
            randomAudit.setDate(current);
            randomAudit.setElementType("BarFooBar");
            audits.add(randomAudit);
        }
        tx = realm.openTx(this.certificate, "test", false);
        try {
            auditTrail = tx.getAuditTrail();
            auditTrail.addAll(tx, audits);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", false);
        try {
            auditTrail = tx.getAuditTrail();
            Assert.assertEquals((long)15L, (long)auditTrail.querySize(tx, containsRange));
            Assert.assertEquals((long)5L, (long)auditTrail.querySize(tx, "BarBarBar", containsRange));
            Assert.assertEquals((long)5L, (long)auditTrail.querySize(tx, "FooFooFoo", containsRange));
            Assert.assertEquals((long)5L, (long)auditTrail.querySize(tx, "BarFooBar", containsRange));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = realm.openTx(this.certificate, "test", false);
        try {
            auditTrail = tx.getAuditTrail();
            Assert.assertEquals((long)5L, (long)auditTrail.removeAll(tx, "BarBarBar", containsRange));
            Assert.assertEquals((long)10L, (long)auditTrail.querySize(tx, containsRange));
            Assert.assertEquals((long)5L, (long)auditTrail.removeAll(tx, "FooFooFoo", containsRange));
            Assert.assertEquals((long)5L, (long)auditTrail.querySize(tx, containsRange));
            Assert.assertEquals((long)5L, (long)auditTrail.removeAll(tx, "BarFooBar", containsRange));
            Assert.assertEquals((long)0L, (long)auditTrail.querySize(tx, containsRange));
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void cleanup(StrolchRealm realm) {
        DateRange dateRange = new DateRange().from(new Date(0L), true).to(new Date((long)Math.pow(2.0, 50.0)), true);
        try (StrolchTransaction tx = realm.openTx(this.certificate, "test", false);){
            AuditTrail auditTrail = tx.getAuditTrail();
            Set types = auditTrail.getTypes(tx);
            for (String type : types) {
                auditTrail.removeAll(tx, type, dateRange);
            }
            Assert.assertEquals((long)0L, (long)auditTrail.querySize(tx, dateRange));
            tx.commitOnClose();
        }
    }

    private final class AuditByIdComparator
    implements Comparator<Audit> {
        private AuditByIdComparator() {
        }

        @Override
        public int compare(Audit o1, Audit o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

