/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.testbase.runtime;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchAgent;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.handler.operationslog.OperationsLog;
import li.strolch.model.Locator;
import li.strolch.model.log.LogMessage;
import li.strolch.model.log.LogMessageState;
import li.strolch.model.log.LogSeverity;
import li.strolch.persistence.api.LogMessageDao;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.privilege.PrivilegeHandler;
import org.junit.Assert;

public class LogMessagesTestRunner {
    private static final int MAX_MESSAGES = 100;
    private final ComponentContainer container;
    private final String realmName;
    private final OperationsLog operationsLog;
    private final Certificate certificate;

    public LogMessagesTestRunner(ComponentContainer container, String realmName) {
        this.container = container;
        this.realmName = realmName;
        this.operationsLog = (OperationsLog)this.container.getComponent(OperationsLog.class);
        this.operationsLog.setMaxMessages(100);
        PrivilegeHandler privilegeHandler = this.container.getPrivilegeHandler();
        this.certificate = privilegeHandler.authenticate("test", "test".toCharArray());
    }

    public void runLogMessagesTest() {
        block28: {
            try {
                RuntimeException ex = new RuntimeException();
                ResourceBundle bundle = ResourceBundle.getBundle("li-strolch-testbase");
                LogMessage logMessage = new LogMessage(this.realmName, "agent", Locator.valueOf((String[])new String[]{"Agent", "li.strolch.testbase", StrolchAgent.getUniqueId()}), LogSeverity.Exception, LogMessageState.Information, bundle, "test-message").withException((Throwable)ex).value("reason", (Throwable)ex);
                this.operationsLog.addMessage(logMessage);
                Thread.sleep(100L);
                StrolchRealm realm = this.container.getRealm(this.realmName);
                if (realm.getMode().isTransient()) {
                    List messages = this.operationsLog.getMessages(this.realmName);
                    Assert.assertEquals((long)2L, (long)messages.size());
                } else {
                    try (StrolchTransaction tx = realm.openTx(this.certificate, "test", true);){
                        LogMessageDao logMessageDao = tx.getPersistenceHandler().getLogMessageDao(tx);
                        List logMessages = logMessageDao.queryLatest(this.realmName, Integer.MAX_VALUE);
                        Assert.assertEquals((long)2L, (long)logMessages.size());
                        LogMessage m = (LogMessage)logMessages.get(0);
                        Assert.assertEquals((Object)logMessage.getId(), (Object)m.getId());
                        Assert.assertEquals((Object)logMessage.getRealm(), (Object)m.getRealm());
                        Assert.assertEquals((Object)logMessage.getLocator(), (Object)m.getLocator());
                        Assert.assertEquals((Object)logMessage.getZonedDateTime(), (Object)m.getZonedDateTime());
                        Assert.assertEquals((Object)logMessage.getSeverity(), (Object)m.getSeverity());
                        Assert.assertEquals((Object)logMessage.getUsername(), (Object)m.getUsername());
                        Assert.assertEquals((Object)logMessage.getStackTrace(), (Object)m.getStackTrace());
                        Assert.assertEquals((Object)logMessage.getKey(), (Object)m.getKey());
                        Assert.assertEquals((Object)logMessage.getMessage(), (Object)m.getMessage());
                        Assert.assertEquals((Object)logMessage.getValues(), (Object)m.getValues());
                    }
                }
                List ids = this.operationsLog.getMessages(this.realmName).stream().map(LogMessage::getId).collect(Collectors.toList());
                for (int i = 0; i < 200; ++i) {
                    LogMessage m = new LogMessage(this.realmName, "agent", Locator.valueOf((String[])new String[]{"Agent", "li.strolch.testbase", StrolchAgent.getUniqueId()}), LogSeverity.Exception, LogMessageState.Information, bundle, "test-message");
                    this.operationsLog.addMessage(m);
                    ids.add(m.getId());
                }
                Thread.sleep(1500L);
                int trimSize = 10;
                int expectedSize = 100 - trimSize + 2;
                if (realm.getMode().isTransient()) {
                    List messages = this.operationsLog.getMessages(this.realmName);
                    Assert.assertEquals((long)expectedSize, (long)messages.size());
                } else {
                    try (StrolchTransaction tx = realm.openTx(this.certificate, "test", true);){
                        LogMessageDao logMessageDao = tx.getPersistenceHandler().getLogMessageDao(tx);
                        List logMessageIds = logMessageDao.queryLatest(this.realmName, Integer.MAX_VALUE).stream().map(LogMessage::getId).sorted().collect(Collectors.toList());
                        Assert.assertEquals((long)expectedSize, (long)logMessageIds.size());
                        Assert.assertEquals(ids.subList(ids.size() - expectedSize, ids.size()), logMessageIds);
                    }
                }
                LogMessage logMessage1 = new LogMessage(this.realmName, "agent", Locator.valueOf((String[])new String[]{"Agent", "test", "@1"}), LogSeverity.Error, LogMessageState.Active, bundle, "test-message");
                LogMessage logMessage2 = new LogMessage(this.realmName, "agent", Locator.valueOf((String[])new String[]{"Agent", "test", "@2"}), LogSeverity.Error, LogMessageState.Active, bundle, "test-message");
                LogMessage logMessage3 = new LogMessage(this.realmName, "agent", Locator.valueOf((String[])new String[]{"Agent", "test", "@3"}), LogSeverity.Error, LogMessageState.Active, bundle, "test-message");
                this.operationsLog.addMessage(logMessage1);
                this.operationsLog.addMessage(logMessage2);
                this.operationsLog.addMessage(logMessage3);
                this.operationsLog.updateState(this.realmName, logMessage1.getLocator(), LogMessageState.Inactive);
                Assert.assertEquals((Object)LogMessageState.Inactive, (Object)logMessage1.getState());
                Thread.sleep(50L);
                this.operationsLog.updateState(this.realmName, logMessage1.getId(), LogMessageState.Active);
                Assert.assertEquals((Object)LogMessageState.Active, (Object)logMessage1.getState());
                Thread.sleep(50L);
                this.operationsLog.removeMessage(logMessage1);
                Assert.assertFalse((boolean)this.operationsLog.getMessagesFor(this.realmName, logMessage1.getLocator()).isPresent());
                List<LogMessage> toRemove = Arrays.asList(logMessage2, logMessage3);
                this.operationsLog.removeMessages(toRemove);
                Thread.sleep(300L);
                if (realm.getMode().isTransient()) {
                    List messages = this.operationsLog.getMessages(this.realmName);
                    Assert.assertFalse((boolean)messages.contains(logMessage1));
                    Assert.assertFalse((boolean)messages.contains(logMessage2));
                    Assert.assertFalse((boolean)messages.contains(logMessage3));
                    break block28;
                }
                try (StrolchTransaction tx = realm.openTx(this.certificate, "test", true);){
                    LogMessageDao logMessageDao = tx.getPersistenceHandler().getLogMessageDao(tx);
                    List logMessageIds = logMessageDao.queryLatest(this.realmName, Integer.MAX_VALUE).stream().map(LogMessage::getId).sorted().collect(Collectors.toList());
                    Assert.assertFalse((boolean)logMessageIds.contains(logMessage1.getId()));
                    Assert.assertFalse((boolean)logMessageIds.contains(logMessage2.getId()));
                    Assert.assertFalse((boolean)logMessageIds.contains(logMessage3.getId()));
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Interrupted!");
            }
        }
    }
}

