/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.testbase.runtime;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import li.strolch.agent.api.OrderMap;
import li.strolch.agent.impl.DataStoreMode;
import li.strolch.model.ModelGenerator;
import li.strolch.model.Order;
import li.strolch.model.StrolchElement;
import li.strolch.model.parameter.StringParameter;
import li.strolch.persistence.api.OrderDao;
import li.strolch.persistence.api.PersistenceHandler;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.testbase.runtime.RuntimeMock;
import li.strolch.utils.collections.DateRange;
import org.junit.Assert;

public class OrderModelTestRunner {
    private static final String ID = "@testOrder";
    private static final String NAME = "Test Order";
    private static final String TYPE = "ToStock";
    private RuntimeMock runtimeMock;
    private String realmName;
    private Certificate certificate;

    public OrderModelTestRunner(RuntimeMock runtimeMock, String realmName) {
        this.runtimeMock = runtimeMock;
        this.realmName = realmName;
        PrivilegeHandler privilegeHandler = runtimeMock.getContainer().getPrivilegeHandler();
        this.certificate = privilegeHandler.authenticate("test", "test".toCharArray());
    }

    public void runCreateOrderTest() {
        Order newOrder = ModelGenerator.createOrder((String)"MyTestOrder", (String)"Test Name", (String)"TestType");
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.add(newOrder);
            tx.commitOnClose();
        }
    }

    public void runQuerySizeTest() {
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.getOrderMap().removeAll(tx, tx.getOrderMap().getAllElements(tx));
            tx.commitOnClose();
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            long size = tx.getOrderMap().querySize(tx);
            Assert.assertEquals((String)"Should have 0 objects", (long)0L, (long)size);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Order order1 = ModelGenerator.createOrder((String)"myTestOrder1", (String)"Test Name", (String)"QTestType1");
        Order order2 = ModelGenerator.createOrder((String)"myTestOrder2", (String)"Test Name", (String)"QTestType2");
        Order order3 = ModelGenerator.createOrder((String)"myTestOrder3", (String)"Test Name", (String)"QTestType3");
        order1.setDate(LocalDate.of(2018, 3, 1));
        order2.setDate(LocalDate.of(2019, 4, 1));
        order3.setDate(LocalDate.of(2019, 5, 1));
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.add(order1);
            tx.add(order2);
            tx.add(order3);
            tx.commitOnClose();
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            long size = tx.getOrderMap().querySize(tx);
            Assert.assertEquals((String)"Should have three objects", (long)3L, (long)size);
            size = tx.getOrderMap().querySize(tx, "QTestType1");
            Assert.assertEquals((String)"Should have only one object of type 'QTestType1'", (long)1L, (long)size);
            size = tx.getOrderMap().querySize(tx, "QTestType2");
            Assert.assertEquals((String)"Should have only one object of type 'QTestType1'", (long)1L, (long)size);
            size = tx.getOrderMap().querySize(tx, "QTestType3");
            Assert.assertEquals((String)"Should have only one object of type 'QTestType1'", (long)1L, (long)size);
            size = tx.getOrderMap().querySize(tx, "NonExistingType");
            Assert.assertEquals((String)"Should have zero objects of type 'NonExistingType'", (long)0L, (long)size);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            PersistenceHandler persistenceHandler = this.runtimeMock.getComponent(PersistenceHandler.class);
            OrderDao dao = persistenceHandler.getOrderDao(tx);
            LocalDate _2017 = LocalDate.of(2017, 1, 1);
            LocalDate _2018 = LocalDate.of(2018, 1, 1);
            LocalDate _20180301 = LocalDate.of(2018, 3, 1);
            LocalDate _20190401 = LocalDate.of(2019, 4, 1);
            LocalDate _20190501 = LocalDate.of(2019, 5, 1);
            LocalDate _2020 = LocalDate.of(2020, 1, 1);
            long size = dao.querySize(new DateRange().to(_2017, true));
            Assert.assertEquals((String)"Expect 0 Orders before 2017 inc", (long)0L, (long)size);
            size = dao.querySize(new DateRange().from(_2017, true).to(_2018, true));
            Assert.assertEquals((String)"Expect 0 Orders between _2017 inc and _2018 inc", (long)0L, (long)size);
            size = dao.querySize(new DateRange().from(_2018, true).to(_20180301, false));
            Assert.assertEquals((String)"Expect 0 Orders between _2018 inc and _20180301 exc", (long)0L, (long)size);
            size = dao.querySize(new DateRange().from(_2018, true).to(_20180301, true));
            Assert.assertEquals((String)"Expect 1 Orders between 2018 inc and _20180301 inc", (long)1L, (long)size);
            size = dao.querySize(new DateRange().from(_20180301, false).to(_20190401, false));
            Assert.assertEquals((String)"Expect 0 Orders between _20180301 exc and _20190401 exc", (long)0L, (long)size);
            size = dao.querySize(new DateRange().from(_2017, true));
            Assert.assertEquals((String)"Expect 3 Orders from _2017 inc", (long)3L, (long)size);
            size = dao.querySize(new DateRange().from(_2020, true));
            Assert.assertEquals((String)"Expect 0 Orders from _2020 inc", (long)0L, (long)size);
            size = dao.querySize(new DateRange().from(_20190501, true).to(_2020, true));
            Assert.assertEquals((String)"Expect 1 Orders from _20190501 inc to _2020 inc", (long)1L, (long)size);
            DateRange dateRange = new DateRange().from(_2017, true).to(_20190401, true);
            String[] types = new String[]{"QTestType1", "QTestType2", "QTestType3"};
            size = dao.querySize(dateRange, types);
            Assert.assertEquals((String)"Expect 2 Orders from _2017 inc to _20190401 inc by types", (long)2L, (long)size);
            List orders = dao.queryAll(dateRange);
            Assert.assertEquals((String)"Expect 2 Orders from _2017 inc to _20190401 inc", (long)2L, (long)orders.size());
            if (dao.supportsPaging()) {
                orders = dao.queryAll(dateRange, 2L, 1L, true);
                Assert.assertEquals((String)"Expect 1 Orders from _2017 inc to _20190401 inc offset 1 limit 2", (long)1L, (long)orders.size());
                Assert.assertEquals((String)"Expect order myTestOrder2", (Object)"myTestOrder2", (Object)((Order)orders.get(0)).getId());
                orders = dao.queryAll(new DateRange().from(_2017, true).to(_2020, true), 2L, 1L, true);
                Assert.assertEquals((String)"Expect 2 Orders from _2017 inc to _2020 inc offset 1 limit 2", (long)2L, (long)orders.size());
                Assert.assertEquals((String)"Expect order myTestOrder2", (Object)"myTestOrder2", (Object)((Order)orders.get(0)).getId());
                Assert.assertEquals((String)"Expect order myTestOrder3", (Object)"myTestOrder3", (Object)((Order)orders.get(1)).getId());
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    public void runCrudTests() {
        Order newOrder = ModelGenerator.createOrder((String)ID, (String)NAME, (String)TYPE);
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.add(newOrder);
            tx.commitOnClose();
        }
        Order readOrder = null;
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            readOrder = tx.getOrderBy(TYPE, ID);
        }
        Assert.assertNotNull((String)"Should read Order with id @testOrder", (Object)readOrder);
        StringParameter sParam = (StringParameter)readOrder.getParameter("@bag01", "@param5");
        String newStringValue = "Giddiya!";
        sParam.setValue(newStringValue);
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.update(readOrder);
            tx.commitOnClose();
        }
        Order updatedOrder = null;
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);){
            updatedOrder = tx.getOrderBy(TYPE, ID);
        }
        Assert.assertNotNull((String)"Should read Order with id @testOrder", (Object)updatedOrder);
        if (this.runtimeMock.getRealm(this.realmName).getMode() != DataStoreMode.CACHED) {
            Assert.assertNotSame((String)"Objects can't be the same reference after re-reading!", (Object)readOrder, (Object)updatedOrder);
        }
        StringParameter updatedParam = (StringParameter)readOrder.getParameter("@bag01", "@param5");
        Assert.assertEquals((Object)newStringValue, (Object)updatedParam.getValue());
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.remove(readOrder);
            tx.commitOnClose();
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            Order order = tx.getOrderBy(TYPE, ID);
            Assert.assertNull((String)"Should not read Order with id @testOrder", (Object)order);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    public void runBulkOperationTests() {
        OrderMap orderMap;
        ArrayList<Order> orders = new ArrayList<Order>();
        orders.addAll(ModelGenerator.createOrders((int)orders.size(), (int)5, (String)"@", (String)"My Order", (String)"MyType1"));
        orders.addAll(ModelGenerator.createOrders((int)orders.size(), (int)5, (String)"@", (String)"Other Order", (String)"MyType2"));
        orders.addAll(ModelGenerator.createOrders((int)orders.size(), (int)5, (String)"@", (String)"Further Order", (String)"MyType3"));
        orders.sort(Comparator.comparing(StrolchElement::getId));
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            orderMap = tx.getOrderMap();
            List allElements = orderMap.getAllElements(tx);
            long removed = orderMap.removeAll(tx);
            Assert.assertEquals((long)allElements.size(), (long)removed);
            Assert.assertEquals((long)0L, (long)orderMap.querySize(tx));
            tx.commitOnClose();
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            orderMap = tx.getOrderMap();
            Assert.assertEquals((long)0L, (long)orderMap.querySize(tx));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            tx.getOrderMap().addAll(tx, orders);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            orderMap = tx.getOrderMap();
            Assert.assertEquals((long)orders.size(), (long)orderMap.querySize(tx));
            Assert.assertEquals((long)5L, (long)orderMap.querySize(tx, "MyType3"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            tx.getOrderMap().removeAllBy(tx, "MyType3");
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            orderMap = tx.getOrderMap();
            Assert.assertEquals((long)(orders.size() - 5), (long)orderMap.querySize(tx));
            Assert.assertEquals((long)0L, (long)orderMap.querySize(tx, "MyType3"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            long removed = tx.getOrderMap().removeAll(tx);
            Assert.assertEquals((long)(orders.size() - 5), (long)removed);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            OrderMap orderMap2 = tx.getOrderMap();
            Assert.assertEquals((long)0L, (long)orderMap2.querySize(tx));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        orders.forEach(t -> t.setVersion(null));
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            tx.getOrderMap().addAll(tx, orders);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        HashSet<String> expectedTypes = new HashSet<String>();
        expectedTypes.add("MyType1");
        expectedTypes.add("MyType2");
        expectedTypes.add("MyType3");
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);){
            List allOrders = tx.getOrderMap().getAllElements(tx);
            allOrders.sort(Comparator.comparing(StrolchElement::getId));
            Assert.assertEquals(orders, (Object)allOrders);
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            OrderMap orderMap3 = tx.getOrderMap();
            Set types = orderMap3.getTypes(tx);
            Assert.assertEquals(expectedTypes, (Object)types);
            Set keySet = orderMap3.getAllKeys(tx);
            Assert.assertEquals((long)15L, (long)keySet.size());
            for (String type : types) {
                Set idsByType = orderMap3.getKeysBy(tx, type);
                Assert.assertEquals((long)5L, (long)idsByType.size());
                List ordersByType = orderMap3.getElementsBy(tx, type);
                Assert.assertEquals((long)5L, (long)ordersByType.size());
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            Order order = tx.getOrderBy("MyType1", "@00000001");
            Assert.assertNotNull((Object)order);
            order = tx.getOrderBy("MyType2", "@00000006");
            Assert.assertNotNull((Object)order);
            order = tx.getOrderBy("MyType3", "@00000011");
            Assert.assertNotNull((Object)order);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

