/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.testbase.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import li.strolch.agent.api.ResourceMap;
import li.strolch.agent.impl.DataStoreMode;
import li.strolch.model.ModelGenerator;
import li.strolch.model.Resource;
import li.strolch.model.StrolchElement;
import li.strolch.model.StrolchRootElement;
import li.strolch.model.parameter.StringParameter;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.testbase.runtime.RuntimeMock;
import org.junit.Assert;

public class ResourceModelTestRunner {
    private static final String ID = "@testResource";
    private static final String NAME = "Test Resource";
    private static final String TYPE = "Box";
    private RuntimeMock runtimeMock;
    private String realmName;
    private Certificate certificate;

    public ResourceModelTestRunner(RuntimeMock runtimeMock, String realmName) {
        this.runtimeMock = runtimeMock;
        this.realmName = realmName;
        PrivilegeHandler privilegeHandler = runtimeMock.getContainer().getPrivilegeHandler();
        this.certificate = privilegeHandler.authenticate("test", "test".toCharArray());
    }

    public void runCreateResourceTest() {
        Resource newResource = ModelGenerator.createResource((String)"MyTestResource", (String)"Test Name", (String)"TestType");
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.add(newResource);
            tx.commitOnClose();
        }
    }

    public void runQuerySizeTest() {
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.getResourceMap().removeAll(tx, tx.getResourceMap().getAllElements(tx));
            tx.commitOnClose();
        }
        Resource resource1 = ModelGenerator.createResource((String)"myTestResource1", (String)"Test Name", (String)"QTestType1");
        Resource resource2 = ModelGenerator.createResource((String)"myTestResource2", (String)"Test Name", (String)"QTestType2");
        Resource resource3 = ModelGenerator.createResource((String)"myTestResource3", (String)"Test Name", (String)"QTestType3");
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.add(resource1);
            tx.add(resource2);
            tx.add(resource3);
            tx.commitOnClose();
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            long size = tx.getResourceMap().querySize(tx);
            Assert.assertEquals((String)"Should have three objects", (long)3L, (long)size);
            size = tx.getResourceMap().querySize(tx, "QTestType1");
            Assert.assertEquals((String)"Should have only one object of type 'QTestType1'", (long)1L, (long)size);
            size = tx.getResourceMap().querySize(tx, "QTestType2");
            Assert.assertEquals((String)"Should have only one object of type 'QTestType1'", (long)1L, (long)size);
            size = tx.getResourceMap().querySize(tx, "QTestType3");
            Assert.assertEquals((String)"Should have only one object of type 'QTestType1'", (long)1L, (long)size);
            size = tx.getResourceMap().querySize(tx, "NonExistingType");
            Assert.assertEquals((String)"Should have zero objects of type 'NonExistingType'", (long)0L, (long)size);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    public void runCrudTests() {
        Resource updatedResource;
        Resource readResource;
        Resource newResource = ModelGenerator.createResource((String)ID, (String)NAME, (String)TYPE);
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.add(newResource);
            tx.commitOnClose();
        }
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);){
            readResource = tx.getResourceBy(TYPE, ID);
        }
        Assert.assertNotNull((String)"Should read Resource with id @testResource", (Object)readResource);
        StringParameter sParam = (StringParameter)readResource.getParameter("@bag01", "@param5");
        String newStringValue = "Giddiya!";
        sParam.setValue(newStringValue);
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.getResourceMap().update(tx, (StrolchRootElement)readResource);
            tx.commitOnClose();
        }
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);){
            updatedResource = tx.getResourceBy(TYPE, ID);
        }
        Assert.assertNotNull((String)"Should read Resource with id @testResource", (Object)updatedResource);
        if (this.runtimeMock.getRealm(this.realmName).getMode() != DataStoreMode.CACHED) {
            Assert.assertNotSame((String)"Objects can't be the same reference after re-reading!", (Object)readResource, (Object)updatedResource);
        }
        StringParameter updatedParam = (StringParameter)readResource.getParameter("@bag01", "@param5");
        Assert.assertEquals((Object)newStringValue, (Object)updatedParam.getValue());
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            tx.getResourceMap().remove(tx, (StrolchRootElement)readResource);
            tx.commitOnClose();
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            Resource resource = tx.getResourceBy(TYPE, ID);
            Assert.assertNull((String)"Should no read Resource with id @testResource", (Object)resource);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    public void runBulkOperationTests() {
        ResourceMap resourceMap;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.addAll(ModelGenerator.createResources((int)resources.size(), (int)5, (String)"@", (String)"My Resource", (String)"MyType1"));
        resources.addAll(ModelGenerator.createResources((int)resources.size(), (int)5, (String)"@", (String)"Other Resource", (String)"MyType2"));
        resources.addAll(ModelGenerator.createResources((int)resources.size(), (int)5, (String)"@", (String)"Further Resource", (String)"MyType3"));
        resources.sort(Comparator.comparing(StrolchElement::getId));
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);){
            resourceMap = tx.getResourceMap();
            List allElements = resourceMap.getAllElements(tx);
            long removed = resourceMap.removeAll(tx);
            Assert.assertEquals((long)allElements.size(), (long)removed);
            Assert.assertEquals((long)0L, (long)resourceMap.querySize(tx));
            tx.commitOnClose();
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            resourceMap = tx.getResourceMap();
            Assert.assertEquals((long)0L, (long)resourceMap.querySize(tx));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            tx.getResourceMap().addAll(tx, resources);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            resourceMap = tx.getResourceMap();
            Assert.assertEquals((long)resources.size(), (long)resourceMap.querySize(tx));
            Assert.assertEquals((long)5L, (long)resourceMap.querySize(tx, "MyType3"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            long removed = tx.getResourceMap().removeAllBy(tx, "MyType3");
            Assert.assertEquals((long)5L, (long)removed);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            ResourceMap resourceMap2 = tx.getResourceMap();
            Assert.assertEquals((long)(resources.size() - 5), (long)resourceMap2.querySize(tx));
            Assert.assertEquals((long)0L, (long)resourceMap2.querySize(tx, "MyType3"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            long removed = tx.getResourceMap().removeAll(tx);
            Assert.assertEquals((long)(resources.size() - 5), (long)removed);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            ResourceMap resourceMap3 = tx.getResourceMap();
            Assert.assertEquals((long)0L, (long)resourceMap3.querySize(tx));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        resources.forEach(t -> t.setVersion(null));
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", false);
        try {
            tx.getResourceMap().addAll(tx, resources);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        HashSet<String> expectedTypes = new HashSet<String>();
        expectedTypes.add("MyType1");
        expectedTypes.add("MyType2");
        expectedTypes.add("MyType3");
        try (StrolchTransaction tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);){
            List allResources = tx.getResourceMap().getAllElements(tx);
            allResources.sort(Comparator.comparing(StrolchElement::getId));
            Assert.assertEquals(resources, (Object)allResources);
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            ResourceMap resourceMap4 = tx.getResourceMap();
            Set types = resourceMap4.getTypes(tx);
            Assert.assertEquals(expectedTypes, (Object)types);
            Set keySet = resourceMap4.getAllKeys(tx);
            Assert.assertEquals((long)15L, (long)keySet.size());
            for (String type : types) {
                Set idsByType = resourceMap4.getKeysBy(tx, type);
                Assert.assertEquals((long)5L, (long)idsByType.size());
                List resourcesByType = resourceMap4.getElementsBy(tx, type);
                Assert.assertEquals((long)5L, (long)resourcesByType.size());
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.runtimeMock.getRealm(this.realmName).openTx(this.certificate, "test", true);
        try {
            Resource resource = tx.getResourceBy("MyType1", "@00000001");
            Assert.assertNotNull((Object)resource);
            resource = tx.getResourceBy("MyType2", "@00000006");
            Assert.assertNotNull((Object)resource);
            resource = tx.getResourceBy("MyType3", "@00000011");
            Assert.assertNotNull((Object)resource);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

