/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.testbase.runtime;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchAgent;
import li.strolch.agent.api.StrolchBootstrapper;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.agent.api.StrolchVersion;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.runtime.privilege.PrivilegedRunnable;
import li.strolch.runtime.privilege.PrivilegedRunnableWithResult;
import li.strolch.service.api.Service;
import li.strolch.service.api.ServiceArgument;
import li.strolch.service.api.ServiceHandler;
import li.strolch.service.api.ServiceResult;
import li.strolch.service.api.ServiceResultState;
import li.strolch.utils.helper.FileHelper;
import li.strolch.utils.helper.StringHelper;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeMock {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeMock.class);
    private static final String TARGET = "target";
    private ComponentContainer container;
    private StrolchAgent agent;

    public ComponentContainer getContainer() {
        return this.container;
    }

    public StrolchAgent getAgent() {
        return this.agent;
    }

    public PrivilegeHandler getPrivilegeHandler() {
        return this.container.getPrivilegeHandler();
    }

    public ServiceHandler getServiceHandler() {
        return (ServiceHandler)this.container.getComponent(ServiceHandler.class);
    }

    public <T> T getComponent(Class<T> clazz) {
        return (T)this.container.getComponent(clazz);
    }

    public StrolchRealm getRealm(String realm) {
        return this.container.getRealm(realm);
    }

    public StrolchTransaction openUserTx(Certificate certificate, boolean readOnly) {
        return this.container.getRealm(certificate).openTx(certificate, this.getClass(), readOnly);
    }

    public Certificate loginAdmin() {
        return this.getPrivilegeHandler().authenticate("admin", "admin".toCharArray());
    }

    public Certificate loginTest() {
        return this.getPrivilegeHandler().authenticate("test", "test".toCharArray());
    }

    public Certificate login(String username, String password) {
        return this.getPrivilegeHandler().authenticate(username, password.toCharArray());
    }

    public boolean logout(Certificate cert) {
        return this.getPrivilegeHandler().invalidate(cert);
    }

    public RuntimeMock mockRuntime(String targetPath, String srcPath) {
        File targetPathF = new File(targetPath);
        File srcPathF = new File(srcPath);
        return this.mockRuntime(targetPathF, srcPathF);
    }

    public RuntimeMock mockRuntime(File targetPathF, File srcPathF) {
        if (!targetPathF.getParentFile().getName().equals(TARGET)) {
            String msg = "Mocking path must be in a maven target: {0}";
            msg = MessageFormat.format(msg, targetPathF.getAbsolutePath());
            throw new RuntimeException(msg);
        }
        File configSrc = new File(srcPathF, "config");
        if (!configSrc.isDirectory() || !configSrc.canRead()) {
            String msg = "Could not find config source in: {0}";
            msg = MessageFormat.format(msg, configSrc.getAbsolutePath());
            throw new RuntimeException(msg);
        }
        if (targetPathF.exists()) {
            logger.info("Deleting all files in " + targetPathF.getAbsolutePath());
            if (!FileHelper.deleteFile((File)targetPathF, (boolean)true)) {
                String msg = "Failed to delete {0}";
                msg = MessageFormat.format(msg, targetPathF.getAbsolutePath());
                throw new RuntimeException(msg);
            }
        }
        if (!targetPathF.mkdirs()) {
            String msg = "Failed to create {0}";
            msg = MessageFormat.format(msg, targetPathF.getAbsolutePath());
            throw new RuntimeException(msg);
        }
        logger.info(MessageFormat.format("Mocking runtime from {0} to {1}", srcPathF.getAbsolutePath(), targetPathF.getAbsolutePath()));
        this.agent = new StrolchBootstrapper(RuntimeMock.getAppVersion()).setupByCopyingRoot("dev", srcPathF, targetPathF);
        return this;
    }

    public void startContainer() {
        this.startContainer("dev");
    }

    public void startContainer(String environment) {
        try {
            this.agent.initialize();
            this.agent.start();
            this.container = this.agent.getContainer();
        }
        catch (Exception e) {
            logger.error("Failed to start mocked container due to: " + e.getMessage(), (Throwable)e);
            this.destroyRuntime();
            throw e;
        }
    }

    public void destroyRuntime() {
        if (this.agent == null) {
            return;
        }
        try {
            this.agent.stop();
        }
        catch (Exception e) {
            logger.info("Failed to stop container: " + e.getMessage());
        }
        try {
            this.agent.destroy();
        }
        catch (Exception e) {
            logger.info("Failed to destroy container: " + e.getMessage());
        }
    }

    public void runAsAgent(PrivilegedRunnable runnable) throws Exception {
        this.agent.runAsAgent(runnable);
    }

    public <T> T runAsAgentWithResult(PrivilegedRunnableWithResult<T> runnable) throws Exception {
        return (T)this.agent.runAsAgentWithResult(runnable);
    }

    public <T extends ServiceArgument, U extends ServiceResult> U doService(Certificate certificate, Service<T, U> service, T argument) {
        ServiceResult result = this.getServiceHandler().doService(certificate, service, argument);
        return (U)result;
    }

    public <T extends ServiceArgument, U extends ServiceResult> U doServiceAssertResult(Certificate certificate, Service<T, U> service, T argument) {
        ServiceResult result = this.getServiceHandler().doService(certificate, service, argument);
        RuntimeMock.assertServiceResult(ServiceResultState.SUCCESS, result);
        return (U)result;
    }

    public <T extends ServiceArgument, U extends ServiceResult> U doServiceAssertResultFailed(Certificate certificate, Service<T, U> service, T argument) {
        ServiceResult result = this.getServiceHandler().doService(certificate, service, argument);
        RuntimeMock.assertServiceResult(ServiceResultState.FAILED, result);
        return (U)result;
    }

    public static void assertServiceResult(ServiceResultState expectedState, Class<?> expectedResultType, ServiceResult result) {
        Assert.assertEquals((String)("Expected service result of type " + expectedResultType + " but was " + result.getClass()), expectedResultType, result.getClass());
        if (!expectedState.equals((Object)result.getState())) {
            String errorMsg = result.getThrowable() == null ? result.getMessage() : StringHelper.formatException((Throwable)result.getThrowable());
            Assert.fail((String)("Expected service result state " + expectedState + " but was " + result.getState() + ": Reason: " + errorMsg));
        }
    }

    public static void assertServiceResult(ServiceResultState expectedState, ServiceResult result) {
        if (!expectedState.equals((Object)result.getState())) {
            String errorMsg = result.getThrowable() == null ? result.getMessage() : StringHelper.formatException((Throwable)result.getThrowable());
            Assert.fail((String)("Expected service result state " + expectedState + " but was " + result.getState() + ": Reason: " + errorMsg));
        }
    }

    public static StrolchVersion getAppVersion() {
        Properties properties = new Properties();
        try (InputStream in = RuntimeMock.class.getResourceAsStream("/agentVersion.properties");){
            properties.load(in);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read /agentVersion.properties", e);
        }
        return new StrolchVersion(properties);
    }
}

