/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.testbase.runtime;

import java.util.List;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchAgent;
import li.strolch.model.ModelGenerator;
import li.strolch.model.Order;
import li.strolch.model.Resource;
import li.strolch.model.StrolchRootElement;
import li.strolch.model.activity.Activity;
import li.strolch.model.activity.TimeOrdering;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.testbase.runtime.RuntimeMock;
import org.junit.Assert;
import org.junit.Assume;

public class VersioningTestRunner {
    private RuntimeMock runtimeMock;
    private Certificate certificate;

    public VersioningTestRunner(RuntimeMock runtimeMock) {
        this.runtimeMock = runtimeMock;
        PrivilegeHandler privilegeHandler = runtimeMock.getContainer().getPrivilegeHandler();
        this.certificate = privilegeHandler.authenticate("test", "test".toCharArray());
    }

    public void runTestsForVersioning() {
        Assume.assumeTrue((boolean)this.runtimeMock.getRealm("defaultRealm").isVersioningEnabled());
        this.runResourceTests();
        this.runOrderTests();
        this.runActivityTests();
    }

    private void runResourceTests() {
        Resource res1;
        ComponentContainer container = this.runtimeMock.getContainer();
        String type = "TestType";
        String id = StrolchAgent.getUniqueId();
        try (StrolchTransaction tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);){
            res1 = ModelGenerator.createResource((String)id, (String)"Test Name", (String)type);
            tx.add(res1);
            tx.flush();
            Assert.assertEquals((long)0L, (long)res1.getVersion().getVersion());
            tx.commitOnClose();
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = tx.getResourceBy(type, id, true);
            Assert.assertEquals((long)0L, (long)res1.getVersion().getVersion());
            res1.setName("Something");
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = tx.getResourceBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)res1.getName());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = tx.getResourceBy(type, id, true);
            res1.setName("Something");
            tx.update(res1);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = tx.getResourceBy(type, id, true);
            Assert.assertEquals((Object)"Something", (Object)res1.getName());
            Assert.assertEquals((long)1L, (long)res1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Resource revertedVersion = (Resource)tx.getResourceMap().revertToVersion(tx, type, id, 0);
            Assert.assertEquals((Object)"Test Name", (Object)revertedVersion.getName());
            Assert.assertEquals((long)2L, (long)revertedVersion.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = tx.getResourceBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)res1.getName());
            Assert.assertEquals((long)2L, (long)res1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = tx.getResourceBy(type, id, true);
            res1.setName("Version 3");
            tx.update(res1);
            tx.flush();
            Assert.assertEquals((long)3L, (long)res1.getVersion().getVersion());
            tx.getResourceMap().undoVersion(tx, (StrolchRootElement)res1);
            tx.clearCache();
            res1 = tx.getResourceBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)res1.getName());
            Assert.assertEquals((long)2L, (long)res1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = tx.getResourceBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)res1.getName());
            Assert.assertEquals((long)2L, (long)res1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = tx.getResourceBy(type, id, true);
            Assert.assertEquals((long)2L, (long)res1.getVersion().getVersion());
            tx.getResourceMap().undoVersion(tx, (StrolchRootElement)res1);
            tx.clearCache();
            res1 = tx.getResourceBy(type, id, true);
            Assert.assertEquals((long)1L, (long)res1.getVersion().getVersion());
            tx.getResourceMap().undoVersion(tx, (StrolchRootElement)res1);
            tx.clearCache();
            res1 = tx.getResourceBy(type, id, true);
            Assert.assertEquals((long)0L, (long)res1.getVersion().getVersion());
            tx.getResourceMap().undoVersion(tx, (StrolchRootElement)res1);
            tx.clearCache();
            Assert.assertFalse((boolean)tx.hasResource(type, id));
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = ModelGenerator.createResource((String)"ball", (String)"Red Ball", (String)"Ball");
            Assert.assertNull((Object)res1.getVersion());
            tx.add(res1);
            tx.flush();
            Assert.assertEquals((long)0L, (long)res1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = tx.getResourceBy("Ball", "ball", true);
            Assert.assertEquals((Object)"Red Ball", (Object)res1.getName());
            tx.remove(res1);
            tx.flush();
            Assert.assertEquals((long)1L, (long)res1.getVersion().getVersion());
            res1 = tx.getResourceBy("Ball", "ball");
            Assert.assertNull((Object)res1);
            Assert.assertFalse((boolean)tx.hasResource("Ball", "ball"));
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = tx.getResourceBy("Ball", "ball");
            Assert.assertNull((Object)res1);
            List versions = tx.getResourceMap().getVersionsFor(tx, "Ball", "ball");
            Assert.assertEquals((long)2L, (long)versions.size());
            res1 = (Resource)versions.get(versions.size() - 1);
            Assert.assertTrue((boolean)res1.getVersion().isDeleted());
            tx.add(res1);
            tx.flush();
            Assert.assertEquals((long)2L, (long)res1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            res1 = tx.getResourceBy("Ball", "ball");
            Assert.assertNotNull((Object)res1);
            Assert.assertEquals((long)2L, (long)res1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Resource res12 = ModelGenerator.createResource((String)StrolchAgent.getUniqueId(), (String)"Test Name", (String)type);
        try (StrolchTransaction tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);){
            tx.add(res12);
            tx.commitOnClose();
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Assert.assertTrue((boolean)tx.hasResource(res12.getType(), res12.getId()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Resource res = tx.getResourceBy(res12.getType(), res12.getId());
            Assert.assertNotNull((Object)res);
            tx.remove(res);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            tx.add(res12.getClone());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Assert.assertTrue((boolean)tx.hasResource(res12.getType(), res12.getId()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void runOrderTests() {
        Order order1;
        ComponentContainer container = this.runtimeMock.getContainer();
        String type = "TestType";
        String id = StrolchAgent.getUniqueId();
        try (StrolchTransaction tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);){
            order1 = ModelGenerator.createOrder((String)id, (String)"Test Name", (String)type);
            tx.add(order1);
            tx.flush();
            Assert.assertEquals((long)0L, (long)order1.getVersion().getVersion());
            tx.commitOnClose();
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = tx.getOrderBy(type, id, true);
            Assert.assertEquals((long)0L, (long)order1.getVersion().getVersion());
            order1.setName("Something");
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = tx.getOrderBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)order1.getName());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = tx.getOrderBy(type, id, true);
            order1.setName("Something");
            tx.update(order1);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = tx.getOrderBy(type, id, true);
            Assert.assertEquals((Object)"Something", (Object)order1.getName());
            Assert.assertEquals((long)1L, (long)order1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Order revertedVersion = (Order)tx.getOrderMap().revertToVersion(tx, type, id, 0);
            Assert.assertEquals((Object)"Test Name", (Object)revertedVersion.getName());
            Assert.assertEquals((long)2L, (long)revertedVersion.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = tx.getOrderBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)order1.getName());
            Assert.assertEquals((long)2L, (long)order1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = tx.getOrderBy(type, id, true);
            order1.setName("Version 3");
            tx.update(order1);
            tx.flush();
            Assert.assertEquals((long)3L, (long)order1.getVersion().getVersion());
            tx.getOrderMap().undoVersion(tx, (StrolchRootElement)order1);
            tx.clearCache();
            order1 = tx.getOrderBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)order1.getName());
            Assert.assertEquals((long)2L, (long)order1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = tx.getOrderBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)order1.getName());
            Assert.assertEquals((long)2L, (long)order1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = tx.getOrderBy(type, id, true);
            Assert.assertEquals((long)2L, (long)order1.getVersion().getVersion());
            tx.getOrderMap().undoVersion(tx, (StrolchRootElement)order1);
            tx.clearCache();
            order1 = tx.getOrderBy(type, id, true);
            Assert.assertEquals((long)1L, (long)order1.getVersion().getVersion());
            tx.getOrderMap().undoVersion(tx, (StrolchRootElement)order1);
            tx.clearCache();
            order1 = tx.getOrderBy(type, id, true);
            Assert.assertEquals((long)0L, (long)order1.getVersion().getVersion());
            tx.getOrderMap().undoVersion(tx, (StrolchRootElement)order1);
            tx.clearCache();
            Assert.assertFalse((boolean)tx.hasOrder(type, id));
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = ModelGenerator.createOrder((String)"ball", (String)"Red Ball", (String)"Ball");
            Assert.assertNull((Object)order1.getVersion());
            tx.add(order1);
            tx.flush();
            Assert.assertEquals((long)0L, (long)order1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = tx.getOrderBy("Ball", "ball", true);
            Assert.assertEquals((Object)"Red Ball", (Object)order1.getName());
            tx.remove(order1);
            tx.flush();
            Assert.assertEquals((long)1L, (long)order1.getVersion().getVersion());
            order1 = tx.getOrderBy("Ball", "ball");
            Assert.assertNull((Object)order1);
            Assert.assertFalse((boolean)tx.hasOrder("Ball", "ball"));
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = tx.getOrderBy("Ball", "ball");
            Assert.assertNull((Object)order1);
            List versions = tx.getOrderMap().getVersionsFor(tx, "Ball", "ball");
            Assert.assertEquals((long)2L, (long)versions.size());
            order1 = (Order)versions.get(versions.size() - 1);
            Assert.assertTrue((boolean)order1.getVersion().isDeleted());
            tx.add(order1);
            tx.flush();
            Assert.assertEquals((long)2L, (long)order1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            order1 = tx.getOrderBy("Ball", "ball");
            Assert.assertNotNull((Object)order1);
            Assert.assertEquals((long)2L, (long)order1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Order order12 = ModelGenerator.createOrder((String)StrolchAgent.getUniqueId(), (String)"Test Name", (String)type);
        try (StrolchTransaction tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);){
            tx.add(order12);
            tx.commitOnClose();
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Assert.assertTrue((boolean)tx.hasOrder(order12.getType(), order12.getId()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Order res = tx.getOrderBy(order12.getType(), order12.getId());
            Assert.assertNotNull((Object)res);
            tx.remove(res);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            tx.add(order12.getClone());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Assert.assertTrue((boolean)tx.hasOrder(order12.getType(), order12.getId()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void runActivityTests() {
        Activity act1;
        ComponentContainer container = this.runtimeMock.getContainer();
        String type = "TestType";
        String id = StrolchAgent.getUniqueId();
        try (StrolchTransaction tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);){
            act1 = ModelGenerator.createActivity((String)id, (String)"Test Name", (String)type, (TimeOrdering)TimeOrdering.SERIES);
            tx.add(act1);
            tx.flush();
            Assert.assertEquals((long)0L, (long)act1.getVersion().getVersion());
            tx.commitOnClose();
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = tx.getActivityBy(type, id, true);
            Assert.assertEquals((long)0L, (long)act1.getVersion().getVersion());
            act1.setName("Something");
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = tx.getActivityBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)act1.getName());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = tx.getActivityBy(type, id, true);
            act1.setName("Something");
            tx.update(act1);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = tx.getActivityBy(type, id, true);
            Assert.assertEquals((Object)"Something", (Object)act1.getName());
            Assert.assertEquals((long)1L, (long)act1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Activity revertedVersion = (Activity)tx.getActivityMap().revertToVersion(tx, type, id, 0);
            Assert.assertEquals((Object)"Test Name", (Object)revertedVersion.getName());
            Assert.assertEquals((long)2L, (long)revertedVersion.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = tx.getActivityBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)act1.getName());
            Assert.assertEquals((long)2L, (long)act1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = tx.getActivityBy(type, id, true);
            act1.setName("Version 3");
            tx.update(act1);
            tx.flush();
            Assert.assertEquals((long)3L, (long)act1.getVersion().getVersion());
            tx.getActivityMap().undoVersion(tx, (StrolchRootElement)act1);
            tx.clearCache();
            act1 = tx.getActivityBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)act1.getName());
            Assert.assertEquals((long)2L, (long)act1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = tx.getActivityBy(type, id, true);
            Assert.assertEquals((Object)"Test Name", (Object)act1.getName());
            Assert.assertEquals((long)2L, (long)act1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = tx.getActivityBy(type, id, true);
            Assert.assertEquals((long)2L, (long)act1.getVersion().getVersion());
            tx.getActivityMap().undoVersion(tx, (StrolchRootElement)act1);
            tx.clearCache();
            act1 = tx.getActivityBy(type, id, true);
            Assert.assertEquals((long)1L, (long)act1.getVersion().getVersion());
            tx.getActivityMap().undoVersion(tx, (StrolchRootElement)act1);
            tx.clearCache();
            act1 = tx.getActivityBy(type, id, true);
            Assert.assertEquals((long)0L, (long)act1.getVersion().getVersion());
            tx.getActivityMap().undoVersion(tx, (StrolchRootElement)act1);
            tx.clearCache();
            Assert.assertFalse((boolean)tx.hasActivity(type, id));
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = ModelGenerator.createActivity((String)"ball", (String)"Red Ball", (String)"Ball", (TimeOrdering)TimeOrdering.SERIES);
            Assert.assertNull((Object)act1.getVersion());
            tx.add(act1);
            tx.flush();
            Assert.assertEquals((long)0L, (long)act1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = tx.getActivityBy("Ball", "ball", true);
            Assert.assertEquals((Object)"Red Ball", (Object)act1.getName());
            tx.remove(act1);
            tx.flush();
            Assert.assertEquals((long)1L, (long)act1.getVersion().getVersion());
            act1 = tx.getActivityBy("Ball", "ball");
            Assert.assertNull((Object)act1);
            Assert.assertFalse((boolean)tx.hasActivity("Ball", "ball"));
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = tx.getActivityBy("Ball", "ball");
            Assert.assertNull((Object)act1);
            List versions = tx.getActivityMap().getVersionsFor(tx, "Ball", "ball");
            Assert.assertEquals((long)2L, (long)versions.size());
            act1 = (Activity)versions.get(versions.size() - 1);
            Assert.assertTrue((boolean)act1.getVersion().isDeleted());
            tx.add(act1);
            tx.flush();
            Assert.assertEquals((long)2L, (long)act1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            act1 = tx.getActivityBy("Ball", "ball");
            Assert.assertNotNull((Object)act1);
            Assert.assertEquals((long)2L, (long)act1.getVersion().getVersion());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Activity act12 = ModelGenerator.createActivity((String)StrolchAgent.getUniqueId(), (String)"Test Name", (String)type, (TimeOrdering)TimeOrdering.SERIES);
        try (StrolchTransaction tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);){
            tx.add(act12);
            tx.commitOnClose();
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Assert.assertTrue((boolean)tx.hasActivity(act12.getType(), act12.getId()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Activity res = tx.getActivityBy(act12.getType(), act12.getId());
            Assert.assertNotNull((Object)res);
            tx.remove(res);
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            tx.add(act12.getClone());
            tx.commitOnClose();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = container.getRealm(this.certificate).openTx(this.certificate, VersioningTestRunner.class, false);
        try {
            Assert.assertTrue((boolean)tx.hasActivity(act12.getType(), act12.getId()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

