/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.aop;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.StopWatch;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.io.unit.DataSizeUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.Header;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.takeshi.annotation.RepeatSubmit;
import com.takeshi.config.StaticConfig;
import com.takeshi.constants.SysCode;
import com.takeshi.exception.TakeshiException;
import com.takeshi.pojo.vo.ResponseDataVO;
import com.takeshi.util.GsonUtil;
import com.takeshi.util.TakeshiUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class ControllerAspect {
    private static final Logger log = LoggerFactory.getLogger(ControllerAspect.class);
    private final ObjectMapper objectMapper;
    private final RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* com..*..controller..*(..))")
    @AfterThrowing
    public Object around(ProceedingJoinPoint proceedingJoinPoint) {
        StopWatch stopWatch = new StopWatch(MDC.get((String)"traceId"));
        stopWatch.start();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
        String userAgent = request.getHeader(Header.USER_AGENT.getValue());
        String timestamp = request.getHeader("timestamp");
        log.info("\u8bf7\u6c42\u5f00\u59cb, \u8bf7\u6c42\u65f6\u95f4: {}, \u8bf7\u6c42IP: {}, \u8bf7\u6c42\u5de5\u5177: {}", new Object[]{timestamp, TakeshiUtil.getClientIp(request), userAgent});
        log.info("\u8bf7\u6c42\u5730\u5740: {}, \u8bf7\u6c42\u65b9\u6cd5: [{}] {}.{}", new Object[]{request.getRequestURL(), request.getMethod(), signature.getDeclaringTypeName(), signature.getName()});
        Object loginId = StpUtil.getLoginIdDefaultNull();
        if (ObjUtil.isNotNull((Object)loginId)) {
            log.info("\u8bf7\u6c42\u7528\u6237ID: {}", loginId);
        }
        this.isRepeatSubmit(request, signature, proceedingJoinPoint.getArgs());
        Object proceed = null;
        try {
            proceed = proceedingJoinPoint.proceed();
            log.info("\u54cd\u5e94\u62a5\u6587: {}", (Object)GsonUtil.toJson(proceed));
        }
        catch (Throwable e) {
            ExceptionUtil.wrapAndThrow((Throwable)e);
        }
        finally {
            stopWatch.stop();
            log.info("\u54cd\u5e94\u7ed3\u675f,\u8017\u65f6: {} ms", (Object)stopWatch.getTotalTimeMillis());
        }
        return proceed;
    }

    private void isRepeatSubmit(HttpServletRequest request, MethodSignature signature, Object[] args) {
        List list = Stream.of(args).filter(arg -> !(arg instanceof ServletRequest) && !(arg instanceof ServletResponse)).map(arg -> {
            if (arg instanceof MultipartFile) {
                MultipartFile file2 = (MultipartFile)arg;
                return StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{file2.getOriginalFilename(), "[", DataSizeUtil.format((long)file2.getSize()), "]"});
            }
            if (arg instanceof MultipartFile[]) {
                MultipartFile[] files = (MultipartFile[])arg;
                return Arrays.stream(files).map(file -> StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{file.getOriginalFilename(), "[", DataSizeUtil.format((long)file.getSize()), "]"})).toList();
            }
            return arg;
        }).collect(Collectors.toList());
        log.info("\u8bf7\u6c42\u62a5\u6587: {} ", (Object)GsonUtil.toJson(list));
        RepeatSubmit repeatSubmit = signature.getMethod().getAnnotation(RepeatSubmit.class);
        if (ObjUtil.isNotEmpty((Object)repeatSubmit)) {
            Object arg2;
            ResponseDataVO.ResBean resBean = SysCode.REPEAT_SUBMIT;
            long interval = repeatSubmit.interval();
            if (StrUtil.isNotBlank((CharSequence)repeatSubmit.msg())) {
                resBean.setInfo(repeatSubmit.msg());
            }
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("repeatUrl", request.getServletPath());
            map.put("repeatToken", StpUtil.getTokenValue());
            JSONObject jsonObject = JSONUtil.createObj();
            String[] parameterNames = signature.getParameterNames();
            for (int i = 0; !(i >= args.length || (arg2 = args[i]) instanceof ServletRequest || arg2 instanceof ServletResponse || arg2 instanceof MultipartFile || arg2 instanceof File); ++i) {
                jsonObject.set(parameterNames[i], arg2);
            }
            ObjectNode objectNode = (ObjectNode)this.objectMapper.convertValue((Object)jsonObject, ObjectNode.class);
            List<String> ignoredFieldList = Arrays.asList(repeatSubmit.ignoredFieldNames());
            if (CollUtil.isNotEmpty(ignoredFieldList)) {
                objectNode.remove(ignoredFieldList);
                ignoredFieldList.forEach(item -> {
                    ObjectNode parent = objectNode.findParent(item);
                    if (ObjUtil.isNotEmpty((Object)parent)) {
                        parent.remove(item);
                    }
                });
            }
            map.put("repeatParams", (String)objectNode);
            String key = StaticConfig.applicationName + ":repeatSubmit:" + SecureUtil.md5((String)GsonUtil.toJson(map));
            RRateLimiter rateLimiter = this.redissonClient.getRateLimiter(key);
            rateLimiter.trySetRate(RateType.PER_CLIENT, 1L, interval, RateIntervalUnit.MILLISECONDS);
            if (!rateLimiter.tryAcquire()) {
                throw new TakeshiException(resBean);
            }
        }
    }

    public ControllerAspect(ObjectMapper objectMapper, RedissonClient redissonClient) {
        this.objectMapper = objectMapper;
        this.redissonClient = redissonClient;
    }
}

