/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.component;

import cn.hutool.core.util.ArrayUtil;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.api.LockOptions;
import org.redisson.api.RLock;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisComponent {
    private static final Logger log = LoggerFactory.getLogger(RedisComponent.class);
    private final StringRedisTemplate stringRedisTemplate;
    private final RedissonClient redissonClient;

    public StringRedisTemplate redisTemplate() {
        return this.stringRedisTemplate;
    }

    public BoundValueOperations<String, String> boundValueOps(String key) {
        return this.stringRedisTemplate.boundValueOps((Object)key);
    }

    public void save(String key, String value) {
        this.boundValueOps(key).set((Object)value);
    }

    public void save(String key, String value, long expireTime) {
        this.boundValueOps(key).set((Object)value, expireTime, TimeUnit.SECONDS);
    }

    public void save(String key, String value, long expireTime, TimeUnit timeUnit) {
        this.boundValueOps(key).set((Object)value, expireTime, timeUnit);
    }

    public Boolean saveIfAbsent(String key, String value) {
        return this.boundValueOps(key).setIfAbsent((Object)value);
    }

    public Boolean saveIfAbsent(String key, String value, long expireTime) {
        return this.boundValueOps(key).setIfAbsent((Object)value, expireTime, TimeUnit.SECONDS);
    }

    public Boolean saveIfAbsent(String key, String value, long expireTime, TimeUnit timeUnit) {
        return this.boundValueOps(key).setIfAbsent((Object)value, expireTime, timeUnit);
    }

    public Boolean saveIfPresent(String key, String value) {
        return this.boundValueOps(key).setIfPresent((Object)value);
    }

    public Boolean saveIfPresent(String key, String value, long expireTime) {
        return this.boundValueOps(key).setIfPresent((Object)value, expireTime, TimeUnit.SECONDS);
    }

    public Boolean saveIfPresent(String key, String value, long expireTime, TimeUnit timeUnit) {
        return this.boundValueOps(key).setIfPresent((Object)value, expireTime, timeUnit);
    }

    public void saveToDateTime(String key, String value, long dateTime) {
        long timeout = dateTime - ZonedDateTime.now().toInstant().toEpochMilli();
        this.boundValueOps(key).set((Object)value, timeout, TimeUnit.MILLISECONDS);
    }

    public void saveMidnight(String key, String value) {
        long timeout = ZonedDateTime.now().with(LocalTime.MAX).toInstant().toEpochMilli() - ZonedDateTime.now().toInstant().toEpochMilli();
        this.boundValueOps(key).set((Object)value, timeout, TimeUnit.MILLISECONDS);
    }

    public void saveSunDayMidnight(String key, String value) {
        long timeout = ZonedDateTime.now().with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).with(LocalTime.MAX).toInstant().toEpochMilli() - ZonedDateTime.now().toInstant().toEpochMilli();
        this.boundValueOps(key).set((Object)value, timeout, TimeUnit.MILLISECONDS);
    }

    public void saveSmsCode(String key, String value) {
        this.boundValueOps(key).set((Object)value, 5L, TimeUnit.MINUTES);
    }

    public String get(String key) {
        return (String)this.boundValueOps(key).get();
    }

    public Long getExpire(String key) {
        return this.stringRedisTemplate.getExpire((Object)key);
    }

    public Long getExpire(String key, TimeUnit timeUnit) {
        return this.stringRedisTemplate.getExpire((Object)key, timeUnit);
    }

    public void delete(Collection<String> keys) {
        this.stringRedisTemplate.delete(keys);
    }

    public void delete(String ... keys) {
        this.stringRedisTemplate.delete(Arrays.asList(keys));
    }

    public void delete(String key) {
        if (this.hasKey(key).booleanValue()) {
            this.stringRedisTemplate.delete((Object)key);
        }
    }

    public Set<String> keys(String pattern) {
        return this.stringRedisTemplate.keys((Object)pattern);
    }

    public Boolean hasKey(String key) {
        return this.stringRedisTemplate.hasKey((Object)key);
    }

    public Long increment(String key) {
        return this.boundValueOps(key).increment();
    }

    public Long increment(String key, long delta) {
        return this.boundValueOps(key).increment(delta);
    }

    public Double increment(String key, double delta) {
        return this.boundValueOps(key).increment(delta);
    }

    public Long decrement(String key) {
        return this.boundValueOps(key).decrement();
    }

    public Long decrement(String key, long delta) {
        return this.boundValueOps(key).decrement(delta);
    }

    public Integer append(String key, String value) {
        return this.boundValueOps(key).append(value);
    }

    public void expire(String key, long timeout, TimeUnit unit) {
        this.boundValueOps(key).expire(timeout, unit);
    }

    public BoundHashOperations<String, String, String> boundHashOps(String key) {
        return this.stringRedisTemplate.boundHashOps((Object)key);
    }

    public void hashPut(String key, String hashKey, String value) {
        this.boundHashOps(key).put((Object)hashKey, (Object)value);
    }

    public void hashPutAll(String key, Map<String, String> map) {
        this.boundHashOps(key).putAll(map);
    }

    public Boolean hashPutIfAbsent(String key, String hashKey, String value) {
        return this.boundHashOps(key).putIfAbsent((Object)hashKey, (Object)value);
    }

    public Map<String, String> hashEntries(String key) {
        return this.boundHashOps(key).entries();
    }

    public String hashGet(String key, String hashKey) {
        return (String)this.boundHashOps(key).get((Object)hashKey);
    }

    public void hashDelete(String key, String ... hashKeys) {
        this.boundHashOps(key).delete(Arrays.stream(hashKeys).toArray());
    }

    public BoundListOperations<String, String> boundListOps(String key) {
        return this.stringRedisTemplate.boundListOps((Object)key);
    }

    public void listPush(String key, String value) {
        this.boundListOps(key).rightPush((Object)value);
    }

    public List<String> listRange(String key, long start, long end) {
        return this.boundListOps(key).range(start, end);
    }

    public BoundSetOperations<String, String> boundSetOps(String key) {
        return this.stringRedisTemplate.boundSetOps((Object)key);
    }

    public void setAdd(String key, String ... values) {
        if (ArrayUtil.isNotEmpty((Object[])values)) {
            this.boundSetOps(key).add((Object[])values);
        }
    }

    public Long setRemove(String key, String ... values) {
        if (ArrayUtil.isEmpty((Object[])values)) {
            return 0L;
        }
        return this.boundSetOps(key).remove(Arrays.stream(values).toArray());
    }

    public Set<String> setMembers(String key) {
        return this.boundSetOps(key).members();
    }

    public Boolean setIsMembers(String key, String value) {
        return this.boundSetOps(key).isMember((Object)value);
    }

    public BoundZSetOperations<String, String> boundZSetOps(String key) {
        return this.stringRedisTemplate.boundZSetOps((Object)key);
    }

    public void zSetAdd(String key, String value, double score) {
        this.boundZSetOps(key).add((Object)value, score);
    }

    public Long zSetRemove(String key, String ... values) {
        return this.boundZSetOps(key).remove(Arrays.stream(values).toArray());
    }

    public Double zSetScore(String key, String value) {
        return this.boundZSetOps(key).score((Object)value);
    }

    public void zSetIncrementScore(String key, String value, double delta) {
        this.boundZSetOps(key).incrementScore((Object)value, delta);
    }

    public Set<String> zSetRange(String key, long start, long end) {
        return this.boundZSetOps(key).range(start, end);
    }

    public Long zSetRemoveRange(String key, long start, long end) {
        return this.boundZSetOps(key).removeRange(start, end);
    }

    public Long zSetRemoveRange(String key, Range<String> range) {
        return this.boundZSetOps(key).removeRangeByLex(range);
    }

    public Set<String> zSetReverseRange(String key, long start, long end) {
        return this.boundZSetOps(key).reverseRange(start, end);
    }

    public Set<String> zSetRangeByScore(String key, double min, double max) {
        return this.boundZSetOps(key).rangeByScore(min, max);
    }

    public Long zSetRemoveRange(String key, double min, double max) {
        return this.boundZSetOps(key).removeRangeByScore(min, max);
    }

    public Set<String> zSetReverseRangeByScore(String key, double min, double max) {
        return this.boundZSetOps(key).reverseRangeByScore(min, max);
    }

    public Long zSetRank(String key, String value) {
        return this.boundZSetOps(key).rank((Object)value);
    }

    public Long zSetReverseRank(String key, String value) {
        return this.boundZSetOps(key).reverseRank((Object)value);
    }

    public Set<ZSetOperations.TypedTuple<String>> zSetRankWithScore(String key, long start, long end) {
        return this.boundZSetOps(key).rangeWithScores(start, end);
    }

    public Set<ZSetOperations.TypedTuple<String>> zSetReverseRangeWithScores(String key, long start, long end) {
        return this.boundZSetOps(key).reverseRangeWithScores(start, end);
    }

    public Set<ZSetOperations.TypedTuple<String>> zSetRangeByScoreWithScores(String key, long min, long max) {
        return this.boundZSetOps(key).rangeByScoreWithScores((double)min, (double)max);
    }

    public Set<ZSetOperations.TypedTuple<String>> zSetReverseRangeByScoreWithScores(String key, long min, long max) {
        return this.boundZSetOps(key).reverseRangeByScoreWithScores((double)min, (double)max);
    }

    public BoundGeoOperations<String, String> boundGeoOps(String key) {
        return this.stringRedisTemplate.boundGeoOps((Object)key);
    }

    public Long geoAdd(String key, double lon, double lat, String member) {
        return this.boundGeoOps(key).add(new Point(lon, lat), (Object)member);
    }

    public Long geoAdd(String key, RedisGeoCommands.GeoLocation<String> location) {
        return this.boundGeoOps(key).add(location);
    }

    public Long geoAdd(String key, Map<String, Point> memberCoordinateMap) {
        return this.boundGeoOps(key).add(memberCoordinateMap);
    }

    public Long geoAdd(String key, Iterable<RedisGeoCommands.GeoLocation<String>> locations) {
        return this.boundGeoOps(key).add(locations);
    }

    public List<Point> geoPosition(String key, String ... members) {
        return this.boundGeoOps(key).position((Object[])members);
    }

    public Distance geoDistance(String key, String member1, String member2) {
        return this.boundGeoOps(key).distance((Object)member1, (Object)member2);
    }

    public Distance geoDistance(String key, String member1, String member2, Metric metric) {
        return this.boundGeoOps(key).distance((Object)member1, (Object)member2, metric);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(String key, double lon, double lat, double distance) {
        return this.boundGeoOps(key).radius(new Circle(new Point(lon, lat), new Distance(distance, (Metric)Metrics.KILOMETERS)));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(String key, double lon, double lat, double distance, Metrics metrics) {
        return this.boundGeoOps(key).radius(new Circle(new Point(lon, lat), new Distance(distance, (Metric)metrics)));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(String key, double lon, double lat, double distance, Metrics metrics, long count) {
        Circle circle = new Circle(new Point(lon, lat), new Distance(distance, (Metric)metrics));
        RedisGeoCommands.GeoRadiusCommandArgs args = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs().includeDistance().includeCoordinates().sortAscending().limit(count);
        return this.boundGeoOps(key).radius(circle, args);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(String key, String member, double distance) {
        return this.boundGeoOps(key).radius((Object)member, new Distance(distance, (Metric)Metrics.KILOMETERS));
    }

    public Long geoRemove(String key, String ... members) {
        return this.boundGeoOps(key).remove((Object[])members);
    }

    public List<String> geoHash(String key, String ... members) {
        return this.boundGeoOps(key).hash((Object[])members);
    }

    public RedissonClient redissonClient() {
        return this.redissonClient;
    }

    public RLock getLock(String key) {
        return this.redissonClient.getLock(key);
    }

    public RLock getSpinLock(String key) {
        return this.redissonClient.getSpinLock(key);
    }

    public RLock getSpinLock(String key, LockOptions.BackOff backOff) {
        return this.redissonClient.getSpinLock(key, backOff);
    }

    public RLock getMultiLock(RLock ... locks) {
        return this.redissonClient.getMultiLock(locks);
    }

    public RLock getFairLock(String key) {
        return this.redissonClient.getFairLock(key);
    }

    public RReadWriteLock getReadWriteLock(String key) {
        return this.redissonClient.getReadWriteLock(key);
    }

    public RRateLimiter getRateLimiter(String name) {
        return this.redissonClient.getRateLimiter(name);
    }

    public RedisComponent(StringRedisTemplate stringRedisTemplate, RedissonClient redissonClient) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.redissonClient = redissonClient;
    }
}

