/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.component;

import com.takeshi.util.TakeshiThreadUtil;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ShutdownManager {
    private static final Logger log = LoggerFactory.getLogger(ShutdownManager.class);
    private final ScheduledExecutorService scheduledExecutorService;
    private static final long TIMEOUT = 60L;

    @PreDestroy
    public void destroy() {
        this.shutdownAsyncManager();
    }

    private void shutdownAsyncManager() {
        try {
            log.info("====\u5173\u95ed\u540e\u53f0\u4efb\u52a1\u4efb\u52a1\u7ebf\u7a0b\u6c60====");
            TakeshiThreadUtil.shutdownAndAwaitTermination(this.scheduledExecutorService, 60L);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public ShutdownManager(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }
}

