/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.config;

import cn.hutool.core.util.ArrayUtil;
import com.takeshi.exception.TakeshiException;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@Configuration
public class AsyncConfig
implements AsyncConfigurer {
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public Executor getAsyncExecutor() {
        return this.threadPoolTaskExecutor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (throwable, method, objects) -> {
            throwable.printStackTrace();
            StringBuilder sb = new StringBuilder();
            sb.append("Exception message - ").append(throwable.getMessage()).append(", Method name - ").append(method.getName());
            if (ArrayUtil.isNotEmpty((Object[])objects)) {
                sb.append(", Parameter value - ").append(Arrays.toString(objects));
            }
            throw new TakeshiException(sb.toString());
        };
    }

    public AsyncConfig(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }
}

