/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.config;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Map;
import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;

public class MdcTaskDecorator
implements TaskDecorator {
    public Runnable decorate(Runnable runnable) {
        Map copyOfContextMap = MDC.getCopyOfContextMap();
        return () -> {
            try {
                MDC.setContextMap((Map)copyOfContextMap);
                String traceId = MDC.get((String)"traceId");
                if (StrUtil.isBlank((CharSequence)traceId)) {
                    traceId = IdUtil.fastUUID();
                    MDC.put((String)"traceId", (String)traceId);
                }
                runnable.run();
            }
            finally {
                MDC.remove((String)"traceId");
            }
        };
    }
}

