/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.config;

import cn.dev33.satoken.config.SaTokenConfig;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ReflectUtil;
import com.takeshi.annotation.ApiVersion;
import com.takeshi.config.StaticConfig;
import com.takeshi.constants.SysCode;
import com.takeshi.pojo.vo.ResponseDataVO;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Primary
@Configuration
public class OpenApiConfig {
    private final MessageSource messageSource;
    private final SaTokenConfig saTokenConfig;

    @Bean
    public GroupedOpenApi userApi() {
        return GroupedOpenApi.builder().group(ApiVersion.Version.DEFAULT.getDisplay()).pathsToMatch(new String[]{"/**"}).addOperationCustomizer((operation, handlerMethod) -> {
            ApiResponses apiResponses = operation.getResponses();
            Arrays.stream(ReflectUtil.getFields(SysCode.class)).filter(item -> item.getType().isAssignableFrom(ResponseDataVO.ResBean.class)).forEach(item -> {
                ResponseDataVO.ResBean resBean = (ResponseDataVO.ResBean)ReflectUtil.getStaticFieldValue((Field)item);
                String message = this.messageSource.getMessage(resBean.getInfo(), null, resBean.getInfo(), Locale.SIMPLIFIED_CHINESE);
                String name = String.valueOf(resBean.getCode());
                ApiResponse response = (ApiResponse)apiResponses.get((Object)name);
                if (ObjUtil.isNotNull((Object)response)) {
                    apiResponses.addApiResponse(name, response.description(message));
                } else {
                    apiResponses.addApiResponse(name, new ApiResponse().description(message));
                }
            });
            return operation;
        }).build();
    }

    @Bean
    public OpenAPI customOpenApi() {
        String tokenName = this.saTokenConfig.getTokenName();
        SecurityScheme securityScheme = new SecurityScheme().name(tokenName).type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER);
        return new OpenAPI().info(this.info()).addSecurityItem(new SecurityRequirement().addList(tokenName)).components(new Components().addSecuritySchemes(tokenName, securityScheme));
    }

    private Info info() {
        return new Info().title(StaticConfig.applicationName).description(StaticConfig.applicationName + "\u901a\u7528\u6846\u67b6\u63a5\u53e3").contact(new Contact().name("\u4e03\u6fd1\u6b66\u3010Nanase Takeshi\u3011"));
    }

    public OpenApiConfig(MessageSource messageSource, SaTokenConfig saTokenConfig) {
        this.messageSource = messageSource;
        this.saTokenConfig = saTokenConfig;
    }
}

