/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.config;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.RSA;
import com.takeshi.config.properties.TakeshiProperties;
import com.takeshi.enums.RedisKeyEnum;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="StaticConfig")
public class StaticConfig {
    public static String TAKESHI_PROPERTIES_MSG = "StaticConfig.takeshiProperties is null. Please set StaticConfig.takeshiProperties and StaticConfig.takeshiProperties.{} property value";
    public static MessageSource messageSource;
    public static RedissonClient redissonClient;
    public static StringRedisTemplate stringRedisTemplate;
    public static TakeshiProperties takeshiProperties;
    public static String applicationName;
    public static String active;
    public static String serverPort;
    public static String privateKeyBase64;
    public static String publicKeyBase64;
    public static RSA rsa;

    public StaticConfig(@Value(value="${spring.application.name}") String applicationName, @Value(value="${spring.profiles.active}") String active, @Value(value="${server.port}") String serverPort, MessageSource messageSource, RedissonClient redissonClient, StringRedisTemplate stringRedisTemplate, TakeshiProperties takeshiProperties) {
        StaticConfig.applicationName = applicationName;
        StaticConfig.active = active;
        StaticConfig.serverPort = serverPort;
        StaticConfig.messageSource = messageSource;
        StaticConfig.redissonClient = redissonClient;
        StaticConfig.stringRedisTemplate = stringRedisTemplate;
        StaticConfig.takeshiProperties = takeshiProperties;
        String projectPrivateKey = RedisKeyEnum.PRIVATE_KEY_BASE64.formatProject(new Object[0]);
        String projectPublicKey = RedisKeyEnum.PUBLIC_KEY_BASE64.formatProject(new Object[0]);
        BoundValueOperations privateKeyBoundValue = stringRedisTemplate.boundValueOps((Object)projectPrivateKey);
        BoundValueOperations publicKeyBoundValue = stringRedisTemplate.boundValueOps((Object)projectPublicKey);
        String privateKeyValue = (String)privateKeyBoundValue.get();
        String publicKeyValue = (String)publicKeyBoundValue.get();
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{privateKeyValue, publicKeyValue})) {
            KeyPair keyPair = SecureUtil.generateKeyPair((String)AsymmetricAlgorithm.RSA.getValue(), (int)1024, (byte[])takeshiProperties.getProjectName().getBytes(StandardCharsets.UTF_8));
            privateKeyValue = Base64.encode((byte[])keyPair.getPrivate().getEncoded());
            publicKeyValue = Base64.encode((byte[])keyPair.getPublic().getEncoded());
            privateKeyBoundValue.setIfAbsent((Object)privateKeyValue);
            publicKeyBoundValue.setIfAbsent((Object)publicKeyValue);
        }
        privateKeyBase64 = privateKeyValue;
        publicKeyBase64 = publicKeyValue;
        rsa = SecureUtil.rsa((String)privateKeyValue, (String)publicKeyValue);
    }

    public static boolean isDevActive() {
        return StrUtil.equals((CharSequence)"dev", (CharSequence)active);
    }

    public static boolean isProdActive() {
        return StrUtil.equals((CharSequence)"prod", (CharSequence)active);
    }
}

