/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.config;

import cn.hutool.core.thread.ThreadUtil;
import com.takeshi.config.MdcTaskDecorator;
import com.takeshi.config.StaticConfig;
import com.takeshi.util.TakeshiThreadUtil;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ThreadPoolConfig {
    private final int CORE = Runtime.getRuntime().availableProcessors() + 1;

    @Bean(value={"threadPoolTaskExecutor"})
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.CORE);
        executor.setMaxPoolSize(this.CORE * 2);
        int QUEUE_CAPACITY = 128;
        executor.setQueueCapacity(QUEUE_CAPACITY);
        int KEEP_ALIVE_SECONDS = 300;
        executor.setKeepAliveSeconds(KEEP_ALIVE_SECONDS);
        executor.setTaskDecorator((TaskDecorator)new MdcTaskDecorator());
        executor.setThreadNamePrefix("task-" + StaticConfig.serverPort + "-exec-");
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Bean(value={"scheduledExecutorService"})
    protected ScheduledExecutorService scheduledExecutorService() {
        return new ScheduledThreadPoolExecutor(this.CORE, ThreadUtil.newNamedThreadFactory((String)("schedule-" + StaticConfig.serverPort + "-exec-"), (boolean)true), new ThreadPoolExecutor.CallerRunsPolicy()){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                TakeshiThreadUtil.printException(r, t);
            }
        };
    }
}

