/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.config.properties;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.StrUtil;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.regions.Regions;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="takeshi")
public class TakeshiProperties {
    private String projectName;
    private boolean appPlatform;
    private boolean signature;
    private AWSSecretsManagerCredentials awsCredentials = new AWSSecretsManagerCredentials();
    private MandrillCredentials mandrillCredentials = new MandrillCredentials();
    private FirebaseCredentials firebaseCredentials = new FirebaseCredentials();

    public String getProjectName() {
        Assert.isFalse((boolean)StrUtil.isBlank((CharSequence)this.projectName), (String)"Properties {takeshi.projectName} is null", (Object[])new Object[0]);
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        if (StrUtil.isNotBlank((CharSequence)projectName) && StrUtil.isBlank((CharSequence)this.getAwsCredentials().bucketName)) {
            this.getAwsCredentials().setBucketName(NamingCase.toKebabCase((CharSequence)projectName) + "-bucket");
        }
    }

    public boolean isAppPlatform() {
        return this.appPlatform;
    }

    public boolean isSignature() {
        return this.signature;
    }

    public AWSSecretsManagerCredentials getAwsCredentials() {
        return this.awsCredentials;
    }

    public MandrillCredentials getMandrillCredentials() {
        return this.mandrillCredentials;
    }

    public FirebaseCredentials getFirebaseCredentials() {
        return this.firebaseCredentials;
    }

    public void setAppPlatform(boolean appPlatform) {
        this.appPlatform = appPlatform;
    }

    public void setSignature(boolean signature) {
        this.signature = signature;
    }

    public void setAwsCredentials(AWSSecretsManagerCredentials awsCredentials) {
        this.awsCredentials = awsCredentials;
    }

    public void setMandrillCredentials(MandrillCredentials mandrillCredentials) {
        this.mandrillCredentials = mandrillCredentials;
    }

    public void setFirebaseCredentials(FirebaseCredentials firebaseCredentials) {
        this.firebaseCredentials = firebaseCredentials;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TakeshiProperties)) {
            return false;
        }
        TakeshiProperties other = (TakeshiProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAppPlatform() != other.isAppPlatform()) {
            return false;
        }
        if (this.isSignature() != other.isSignature()) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        AWSSecretsManagerCredentials this$awsCredentials = this.getAwsCredentials();
        AWSSecretsManagerCredentials other$awsCredentials = other.getAwsCredentials();
        if (this$awsCredentials == null ? other$awsCredentials != null : !((Object)this$awsCredentials).equals(other$awsCredentials)) {
            return false;
        }
        MandrillCredentials this$mandrillCredentials = this.getMandrillCredentials();
        MandrillCredentials other$mandrillCredentials = other.getMandrillCredentials();
        if (this$mandrillCredentials == null ? other$mandrillCredentials != null : !((Object)this$mandrillCredentials).equals(other$mandrillCredentials)) {
            return false;
        }
        FirebaseCredentials this$firebaseCredentials = this.getFirebaseCredentials();
        FirebaseCredentials other$firebaseCredentials = other.getFirebaseCredentials();
        return !(this$firebaseCredentials == null ? other$firebaseCredentials != null : !((Object)this$firebaseCredentials).equals(other$firebaseCredentials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TakeshiProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAppPlatform() ? 79 : 97);
        result = result * 59 + (this.isSignature() ? 79 : 97);
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        AWSSecretsManagerCredentials $awsCredentials = this.getAwsCredentials();
        result = result * 59 + ($awsCredentials == null ? 43 : ((Object)$awsCredentials).hashCode());
        MandrillCredentials $mandrillCredentials = this.getMandrillCredentials();
        result = result * 59 + ($mandrillCredentials == null ? 43 : ((Object)$mandrillCredentials).hashCode());
        FirebaseCredentials $firebaseCredentials = this.getFirebaseCredentials();
        result = result * 59 + ($firebaseCredentials == null ? 43 : ((Object)$firebaseCredentials).hashCode());
        return result;
    }

    public String toString() {
        return "TakeshiProperties(projectName=" + this.getProjectName() + ", appPlatform=" + this.isAppPlatform() + ", signature=" + this.isSignature() + ", awsCredentials=" + this.getAwsCredentials() + ", mandrillCredentials=" + this.getMandrillCredentials() + ", firebaseCredentials=" + this.getFirebaseCredentials() + ")";
    }

    public static class AWSSecretsManagerCredentials
    implements AWSCredentials {
        private String accessKey;
        private String secretKey;
        private String bucketName;
        private String region;

        public String getBucketName() {
            Assert.isFalse((boolean)StrUtil.isBlank((CharSequence)this.bucketName), (String)"Properties {takeshi.awsCredentials.bucketName} or {takeshi.projectName} is null", (Object[])new Object[0]);
            return this.bucketName;
        }

        public Regions getRegion() {
            return StrUtil.isBlank((CharSequence)this.region) ? Regions.GovCloud : Regions.fromName((String)this.region);
        }

        public String getAWSAccessKeyId() {
            return this.accessKey;
        }

        public String getAWSSecretKey() {
            return this.secretKey;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AWSSecretsManagerCredentials)) {
                return false;
            }
            AWSSecretsManagerCredentials other = (AWSSecretsManagerCredentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accessKey = this.getAccessKey();
            String other$accessKey = other.getAccessKey();
            if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
                return false;
            }
            Regions this$region = this.getRegion();
            Regions other$region = other.getRegion();
            return !(this$region == null ? other$region != null : !this$region.equals(other$region));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AWSSecretsManagerCredentials;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accessKey = this.getAccessKey();
            result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            Regions $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            return result;
        }

        public String toString() {
            return "TakeshiProperties.AWSSecretsManagerCredentials(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", bucketName=" + this.getBucketName() + ", region=" + this.getRegion() + ")";
        }
    }

    public static class MandrillCredentials {
        private String apiKey;
        private String fromEmail;
        private String fromName;

        public String getApiKey() {
            return this.apiKey;
        }

        public String getFromEmail() {
            return this.fromEmail;
        }

        public String getFromName() {
            return this.fromName;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public void setFromEmail(String fromEmail) {
            this.fromEmail = fromEmail;
        }

        public void setFromName(String fromName) {
            this.fromName = fromName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MandrillCredentials)) {
                return false;
            }
            MandrillCredentials other = (MandrillCredentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$apiKey = this.getApiKey();
            String other$apiKey = other.getApiKey();
            if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
                return false;
            }
            String this$fromEmail = this.getFromEmail();
            String other$fromEmail = other.getFromEmail();
            if (this$fromEmail == null ? other$fromEmail != null : !this$fromEmail.equals(other$fromEmail)) {
                return false;
            }
            String this$fromName = this.getFromName();
            String other$fromName = other.getFromName();
            return !(this$fromName == null ? other$fromName != null : !this$fromName.equals(other$fromName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MandrillCredentials;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $apiKey = this.getApiKey();
            result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
            String $fromEmail = this.getFromEmail();
            result = result * 59 + ($fromEmail == null ? 43 : $fromEmail.hashCode());
            String $fromName = this.getFromName();
            result = result * 59 + ($fromName == null ? 43 : $fromName.hashCode());
            return result;
        }

        public String toString() {
            return "TakeshiProperties.MandrillCredentials(apiKey=" + this.getApiKey() + ", fromEmail=" + this.getFromEmail() + ", fromName=" + this.getFromName() + ")";
        }
    }

    public static class FirebaseCredentials {
        private String jsonFileName;
        private String databaseUrl;

        public String getJsonFileName() {
            return this.jsonFileName;
        }

        public String getDatabaseUrl() {
            return this.databaseUrl;
        }

        public void setJsonFileName(String jsonFileName) {
            this.jsonFileName = jsonFileName;
        }

        public void setDatabaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FirebaseCredentials)) {
                return false;
            }
            FirebaseCredentials other = (FirebaseCredentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jsonFileName = this.getJsonFileName();
            String other$jsonFileName = other.getJsonFileName();
            if (this$jsonFileName == null ? other$jsonFileName != null : !this$jsonFileName.equals(other$jsonFileName)) {
                return false;
            }
            String this$databaseUrl = this.getDatabaseUrl();
            String other$databaseUrl = other.getDatabaseUrl();
            return !(this$databaseUrl == null ? other$databaseUrl != null : !this$databaseUrl.equals(other$databaseUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FirebaseCredentials;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jsonFileName = this.getJsonFileName();
            result = result * 59 + ($jsonFileName == null ? 43 : $jsonFileName.hashCode());
            String $databaseUrl = this.getDatabaseUrl();
            result = result * 59 + ($databaseUrl == null ? 43 : $databaseUrl.hashCode());
            return result;
        }

        public String toString() {
            return "TakeshiProperties.FirebaseCredentials(jsonFileName=" + this.getJsonFileName() + ", databaseUrl=" + this.getDatabaseUrl() + ")";
        }
    }
}

