/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.config.satoken;

import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.exception.BackResultException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.router.SaRouteFunction;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.servlet.model.SaRequestForServlet;
import cn.dev33.satoken.servlet.model.SaResponseForServlet;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Header;
import cn.hutool.http.useragent.UserAgentUtil;
import com.takeshi.annotation.SystemSecurity;
import com.takeshi.config.StaticConfig;
import com.takeshi.constants.SysCode;
import com.takeshi.constants.SysConstants;
import com.takeshi.pojo.vo.ResponseDataVO;
import com.takeshi.util.GsonUtil;
import com.takeshi.util.TakeshiUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class TakeshiInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TakeshiInterceptor.class);
    public SaRouteFunction function = (req, res, handler) -> StpUtil.checkLogin();

    public TakeshiInterceptor() {
    }

    private TakeshiInterceptor(SaRouteFunction function) {
        this.function = function;
    }

    public static TakeshiInterceptor newInstance() {
        return new TakeshiInterceptor();
    }

    public static TakeshiInterceptor newInstance(SaRouteFunction function) {
        return new TakeshiInterceptor(function);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            if (handler instanceof HandlerMethod) {
                HandlerMethod handlerMethod = (HandlerMethod)handler;
                StrBuilder name = StrUtil.strBuilder((CharSequence[])new CharSequence[]{StaticConfig.applicationName, ":", TakeshiUtil.getClientIp(request), ":", request.getServletPath()});
                RRateLimiter rateLimiter = StaticConfig.redissonClient.getRateLimiter(name.toString());
                rateLimiter.trySetRate(RateType.PER_CLIENT, 30L, 1L, RateIntervalUnit.SECONDS);
                if (!rateLimiter.tryAcquire()) {
                    throw new BackResultException((Object)SysCode.RATE_LIMIT);
                }
                if (this.verifySystemSecurity(request, handlerMethod)) {
                    this.function.run((SaRequest)new SaRequestForServlet(request), (SaResponse)new SaResponseForServlet(response), handler);
                }
                Method method = ((HandlerMethod)handler).getMethod();
                SaStrategy.me.checkMethodAnnotation.accept(method);
            }
        }
        catch (StopMatchException handlerMethod) {
        }
        catch (BackResultException e) {
            String str;
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            response.setStatus(HttpStatus.OK.value());
            Object object = e.result;
            if (object instanceof ResponseDataVO.ResBean) {
                ResponseDataVO.ResBean resBean = (ResponseDataVO.ResBean)object;
                str = GsonUtil.toJson(ResponseDataVO.success(resBean));
            } else {
                str = e.getMessage();
            }
            log.error("TakeshiInterceptor.preHandle --> \u8bf7\u6c42URL: " + request.getRequestURL() + ", \u63a5\u53e3\u9a8c\u8bc1\u9519\u8bef: " + str, (Throwable)e);
            response.getWriter().write(str);
            return false;
        }
        return true;
    }

    private boolean verifySystemSecurity(HttpServletRequest request, HandlerMethod handlerMethod) {
        SystemSecurity methodAnnotation = (SystemSecurity)handlerMethod.getMethodAnnotation(SystemSecurity.class);
        if (Objects.nonNull(methodAnnotation)) {
            this.saRouterBack(request, methodAnnotation.all(), methodAnnotation.platform(), methodAnnotation.signature());
            return !methodAnnotation.all() && !methodAnnotation.token();
        }
        SystemSecurity classAnnotation = (SystemSecurity)AnnotationUtil.getAnnotation((AnnotatedElement)handlerMethod.getBeanType(), SystemSecurity.class);
        if (Objects.nonNull(classAnnotation)) {
            this.saRouterBack(request, classAnnotation.all(), classAnnotation.platform(), classAnnotation.signature());
            return !classAnnotation.all() && !classAnnotation.token();
        }
        return true;
    }

    private void saRouterBack(HttpServletRequest request, boolean all, boolean platform, boolean signature) {
        if (!all) {
            if (!platform && StaticConfig.takeshiProperties.isAppPlatform() && !UserAgentUtil.parse((String)request.getHeader(Header.USER_AGENT.getValue())).isMobile()) {
                SaRouter.back((Object)SysCode.USERAGENT_ERROR);
            }
            if (!signature && StaticConfig.takeshiProperties.isSignature()) {
                long between;
                String signParams;
                String sign = request.getHeader("sign");
                String timestamp = request.getHeader("timestamp");
                if (StrUtil.isBlank((CharSequence)timestamp)) {
                    SaRouter.back((Object)SysCode.PARAMETER_ERROR);
                }
                if (StrUtil.isNotBlank((CharSequence)(signParams = TakeshiUtil.signParams(request, timestamp))) && !StrUtil.equals((CharSequence)sign, (CharSequence)signParams)) {
                    SaRouter.back((Object)SysCode.SIGN_ERROR);
                }
                if ((between = ChronoUnit.SECONDS.between(Instant.ofEpochMilli(Long.parseLong(timestamp)), Instant.now())) > SysConstants.LONGS[5] || between < SysConstants.LONGS[0]) {
                    SaRouter.back((Object)SysCode.SIGN_ERROR);
                }
            }
        }
    }
}

