/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.config.security;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import com.takeshi.annotation.SystemSecurity;
import com.takeshi.config.StaticConfig;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@RestControllerAdvice
public class DecodeRequestBodyAdvice
extends RequestBodyAdviceAdapter {
    private static final Logger log = LoggerFactory.getLogger(DecodeRequestBodyAdvice.class);

    public boolean supports(MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) {
        SystemSecurity methodAnnotation = (SystemSecurity)methodParameter.getMethodAnnotation(SystemSecurity.class);
        if (Objects.nonNull(methodAnnotation)) {
            return methodAnnotation.inDecode();
        }
        SystemSecurity classAnnotation = (SystemSecurity)AnnotationUtil.getAnnotation((AnnotatedElement)methodParameter.getContainingClass(), SystemSecurity.class);
        if (Objects.nonNull(classAnnotation)) {
            return classAnnotation.inDecode();
        }
        return false;
    }

    public HttpInputMessage beforeBodyRead(final HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass) throws IOException {
        final byte[] body = StaticConfig.rsa.decrypt(IoUtil.readUtf8((InputStream)httpInputMessage.getBody()), KeyType.PrivateKey);
        return new HttpInputMessage(){

            public InputStream getBody() throws IOException {
                return IoUtil.toStream((byte[])body);
            }

            public HttpHeaders getHeaders() {
                return httpInputMessage.getHeaders();
            }
        };
    }
}

